/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.atlas;

import iskallia.vault.VaultMod;
import iskallia.vault.client.atlas.ITextureAtlas;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public abstract class AbstractTextureAtlasHolder
extends SimplePreparableReloadListener<TextureAtlas.Preparations>
implements AutoCloseable,
ITextureAtlas {
    protected final TextureAtlas textureAtlas;
    protected final Supplier<List<ResourceLocation>> validationSupplier;

    public AbstractTextureAtlasHolder(TextureManager textureManager, ResourceLocation atlasResourceLocation) {
        this(textureManager, atlasResourceLocation, null);
    }

    public AbstractTextureAtlasHolder(TextureManager textureManager, ResourceLocation atlasResourceLocation, Supplier<List<ResourceLocation>> validationSupplier) {
        this.textureAtlas = new TextureAtlas(atlasResourceLocation);
        this.validationSupplier = validationSupplier;
        textureManager.m_118495_(this.textureAtlas.m_118330_(), (AbstractTexture)this.textureAtlas);
    }

    @Nonnull
    protected TextureAtlas.Preparations prepare(@Nonnull ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_7242_();
        profiler.m_6180_("stitching");
        TextureAtlas.Preparations textureatlas$preparations = this.textureAtlas.m_118307_(resourceManager, this.getResourcesToLoad(), profiler, 0);
        profiler.m_7238_();
        profiler.m_7241_();
        return textureatlas$preparations;
    }

    protected void apply(@Nonnull TextureAtlas.Preparations preparations, @Nonnull ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_7242_();
        profiler.m_6180_("upload");
        this.textureAtlas.m_118312_(preparations);
        this.validateTextures();
        profiler.m_7238_();
        profiler.m_7241_();
    }

    protected void validateTextures() {
        if (this.validationSupplier == null) {
            return;
        }
        List<ResourceLocation> resourceLocationList = this.validationSupplier.get();
        for (ResourceLocation resourceLocation2 : resourceLocationList) {
            TextureAtlasSprite sprite = this.textureAtlas.m_118316_(resourceLocation2);
            if (sprite.m_118413_() != MissingTextureAtlasSprite.m_118071_()) continue;
            VaultMod.LOGGER.warn("Atlas is missing texture '%s'".formatted(resourceLocation2));
        }
        this.getResourcesToLoad().forEach(resourceLocation -> {
            if (!resourceLocationList.contains(resourceLocation)) {
                VaultMod.LOGGER.warn("Atlas has unused texture '%s'".formatted(resourceLocation));
            }
        });
    }

    @Override
    public void close() {
        this.textureAtlas.m_118329_();
    }

    @Nonnull
    protected abstract Stream<ResourceLocation> getResourcesToLoad();

    @Override
    public ResourceLocation getAtlasResourceLocation() {
        return this.textureAtlas.m_118330_();
    }

    @Override
    public TextureAtlasSprite getSprite(ResourceLocation resourceLocation) {
        return this.textureAtlas.m_118316_(resourceLocation);
    }

    @Nonnull
    protected ResourceLocation sanitizeResourceLocation(ResourceLocation resourceLocation) {
        return this.sanitizeResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_());
    }

    @Nonnull
    protected ResourceLocation sanitizeResourceLocation(String namespace, String path) {
        return new ResourceLocation(namespace, path.substring("textures/".length(), path.length() - 4));
    }
}

