/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.atlas;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.atlas.Buffer;
import iskallia.vault.client.atlas.IMultiBuffer;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.render.NineSlice;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;

public class AtlasMultiBuffer
implements IMultiBuffer {
    private final Map<ResourceLocation, Buffer> buffers;

    public static Builder builder() {
        return new Builder(new TreeMap<ResourceLocation, Buffer>());
    }

    private AtlasMultiBuffer(Map<ResourceLocation, Buffer> buffers) {
        this.buffers = buffers;
    }

    @Override
    public void begin() {
        this.buffers.values().forEach(buffer -> buffer.bufferBuilder().m_166779_(buffer.mode(), buffer.format()));
    }

    public VertexConsumer getFor(NineSlice.TextureRegion textureRegion) {
        return this.getFor(textureRegion.atlas().get().getAtlasResourceLocation());
    }

    public VertexConsumer getFor(TextureAtlasRegion textureAtlasRegion) {
        return this.getFor(textureAtlasRegion.atlas().get().getAtlasResourceLocation());
    }

    @Override
    public VertexConsumer getFor(ResourceLocation resourceLocation) {
        Buffer buffer = this.buffers.get(resourceLocation);
        if (buffer == null) {
            throw new IllegalStateException("No buffer registered for atlas resource location: " + resourceLocation);
        }
        return buffer.bufferBuilder();
    }

    @Override
    public void end(Function<Buffer, Supplier<ShaderInstance>> shaderFunction) {
        this.buffers.forEach((resourceLocation, buffer) -> {
            RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
            RenderSystem.m_157427_((Supplier)((Supplier)shaderFunction.apply((Buffer)buffer)));
            buffer.bufferBuilder().m_85721_();
            BufferUploader.m_85761_((BufferBuilder)buffer.bufferBuilder());
        });
    }

    public static class Builder {
        private final Map<ResourceLocation, Buffer> buffers;

        public Builder(Map<ResourceLocation, Buffer> buffers) {
            this.buffers = buffers;
        }

        public Builder add(Supplier<ITextureAtlas> atlasSupplier, VertexFormat.Mode mode, VertexFormat format) {
            return this.add(atlasSupplier.get().getAtlasResourceLocation(), mode, format);
        }

        public Builder add(ResourceLocation atlasResourceLocation, VertexFormat.Mode mode, VertexFormat format) {
            if (this.buffers.containsKey(atlasResourceLocation)) {
                throw new IllegalStateException("Duplicate buffer registered for atlas resource location: " + atlasResourceLocation);
            }
            this.buffers.put(atlasResourceLocation, new Buffer(mode, format, new BufferBuilder(256)));
            return this;
        }

        public AtlasMultiBuffer create() {
            return new AtlasMultiBuffer(this.buffers);
        }
    }
}

