/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ScrollableListSelectorElement;
import iskallia.vault.client.gui.framework.element.SelectableButtonElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextAlign;
import iskallia.vault.client.gui.framework.text.TextWrap;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.bottle.BottleEffect;
import iskallia.vault.item.bottle.BottleItem;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class AlchemyArchiveSelectorElement
extends ScrollableListSelectorElement<AlchemyArchiveSelectorElement, BottleEffect, AlchemyArchiveElement> {
    public AlchemyArchiveSelectorElement(ISpatial spatial, List<String> effects) {
        super((ISpatial)Spatials.copy(spatial).width(ScreenTextures.BUTTON_ALCHEMY_MODIFIER_TEXTURES.button().width()), new AlchemyArchiveEffectSelectorModel(effects));
        this.verticalScrollBarElement.setVisible(false);
    }

    public void onSelect(Consumer<String> fn) {
        ScrollableListSelectorElement.SelectorModel selectorModel = this.getSelectorModel();
        if (selectorModel instanceof AlchemyArchiveEffectSelectorModel) {
            AlchemyArchiveEffectSelectorModel selModel = (AlchemyArchiveEffectSelectorModel)selectorModel;
            selModel.whenSelected(cfg -> {
                AlchemyArchiveElement option = (AlchemyArchiveElement)selModel.getSelectedElement();
                if (option != null) {
                    fn.accept(option.getEffect().getEffectId());
                }
            });
        }
    }

    public static class AlchemyArchiveEffectSelectorModel
    extends ScrollableListSelectorElement.SelectorModel<AlchemyArchiveElement, BottleEffect> {
        private final List<String> effects;

        public AlchemyArchiveEffectSelectorModel(List<String> effects) {
            this.effects = effects;
        }

        @Override
        public List<BottleEffect> getEntries() {
            return this.effects.stream().map(effectId -> ModConfigs.VAULT_ALCHEMY_TABLE.getConfig((String)effectId).createEffect(BottleItem.Type.POTION)).filter(Optional::isPresent).map(Optional::get).toList();
        }

        @Override
        public AlchemyArchiveElement createSelectable(ISpatial spatial, BottleEffect entry) {
            return new AlchemyArchiveElement(spatial, entry);
        }
    }

    public static class AlchemyArchiveElement
    extends SelectableButtonElement<AlchemyArchiveElement> {
        private final BottleEffect effect;
        private final LabelTextStyle textStyle;

        public AlchemyArchiveElement(IPosition position, BottleEffect effect) {
            super(position, ScreenTextures.BUTTON_ALCHEMY_MODIFIER_TEXTURES, () -> {});
            this.effect = effect;
            this.textStyle = LabelTextStyle.defaultStyle().shadow().build();
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 1.0);
            this.getEffectDescription().ifPresent(cfgDisplay -> this.textStyle.textBorder().render(renderer, poseStack, (Component)cfgDisplay, TextWrap.wrap(), TextAlign.LEFT, this.worldSpatial.x() + 4, this.worldSpatial.y() + 3, this.worldSpatial.z(), this.worldSpatial.width()));
            poseStack.m_85849_();
        }

        public BottleEffect getEffect() {
            return this.effect;
        }

        public Optional<Component> getEffectDescription() {
            return Optional.of(this.effect.getTooltip());
        }
    }
}

