/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ScrollableListSelectorElement;
import iskallia.vault.client.gui.framework.element.SelectableButtonElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextAlign;
import iskallia.vault.client.gui.framework.text.TextWrap;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.config.AlchemyTableConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.bottle.BottleEffect;
import iskallia.vault.item.bottle.BottleItem;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class AlchemyCraftSelectorElement<E extends AlchemyCraftSelectorElement<E, V>, V extends WorkbenchListElement<V>>
extends ScrollableListSelectorElement<E, AlchemyTableConfig.CraftableEffectConfig, V> {
    private final ObservableSupplier<ItemStack> inputSupplier;

    public AlchemyCraftSelectorElement(ISpatial spatial, ObservableSupplier<ItemStack> inputSupplier, Supplier<String> searchFilter) {
        super((ISpatial)Spatials.copy(spatial).width(ScreenTextures.BUTTON_ALCHEMY_MODIFIER_TEXTURES.button().width()), new AlchemyTableEffectSelectorModel(inputSupplier, searchFilter));
        this.inputSupplier = inputSupplier;
    }

    public void onSelect(Consumer<CraftingOption> fn) {
        ScrollableListSelectorElement.SelectorModel selectorModel = this.getSelectorModel();
        if (selectorModel instanceof AlchemyTableEffectSelectorModel) {
            AlchemyTableEffectSelectorModel selModel = (AlchemyTableEffectSelectorModel)selectorModel;
            selModel.whenSelected(cfg -> {
                CraftingOption option = selModel.getSelectedCraftingOption();
                if (option != null) {
                    fn.accept(option);
                }
            });
        }
    }

    @Override
    public void render(IElementRenderer renderer, @Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        this.inputSupplier.ifChanged(change -> this.refreshElements());
    }

    public static class AlchemyTableEffectSelectorModel<E extends WorkbenchListElement<E>>
    extends ScrollableListSelectorElement.SelectorModel<E, AlchemyTableConfig.CraftableEffectConfig> {
        private final ObservableSupplier<ItemStack> inputSupplier;
        private final Supplier<String> searchFilter;

        public AlchemyTableEffectSelectorModel(ObservableSupplier<ItemStack> inputSupplier, Supplier<String> searchFilter) {
            this.inputSupplier = inputSupplier;
            this.searchFilter = searchFilter;
        }

        @Override
        public List<AlchemyTableConfig.CraftableEffectConfig> getEntries() {
            ItemStack input = this.inputSupplier.get();
            if (input.m_41619_()) {
                return Collections.emptyList();
            }
            if (Minecraft.m_91087_().f_91074_ == null) {
                return Collections.emptyList();
            }
            String searchTerm = this.searchFilter.get().toLowerCase(Locale.ROOT);
            ArrayList<AlchemyTableConfig.CraftableEffectConfig> out = new ArrayList<AlchemyTableConfig.CraftableEffectConfig>();
            ModConfigs.VAULT_ALCHEMY_TABLE.getCraftableEffects().forEach(cfg -> BottleItem.getType(input).flatMap(cfg::createEffect).ifPresent(effect -> {
                String locDisplay = effect.getTooltip().getString().toLowerCase(Locale.ROOT);
                if (searchTerm.isEmpty() || locDisplay.contains(searchTerm)) {
                    out.add((AlchemyTableConfig.CraftableEffectConfig)cfg);
                }
            }));
            return out;
        }

        @Override
        public E createSelectable(ISpatial spatial, AlchemyTableConfig.CraftableEffectConfig entry) {
            return (E)new AlchemyCraftElement((IPosition)spatial, this.inputSupplier.get(), entry);
        }

        @Nullable
        protected CraftingOption getSelectedCraftingOption() {
            WorkbenchListElement element = (WorkbenchListElement)this.getSelectedElement();
            if (element == null) {
                return null;
            }
            if (element instanceof AlchemyCraftElement) {
                AlchemyCraftElement craftElement = (AlchemyCraftElement)element;
                return new CraftingOption(craftElement.getEffect());
            }
            return new CraftingOption(null);
        }
    }

    public record CraftingOption(@Nullable AlchemyTableConfig.CraftableEffectConfig cfg) {
        public List<ItemStack> getCraftingCost(ItemStack input) {
            if (this.cfg() == null) {
                return Collections.emptyList();
            }
            return this.cfg().createCraftingCost(input);
        }
    }

    public static class AlchemyCraftElement<E extends AlchemyCraftElement<E>>
    extends WorkbenchListElement<E> {
        private final ItemStack bottleStack;
        private final AlchemyTableConfig.CraftableEffectConfig effect;
        private final LabelTextStyle textStyle;
        private final BottleEffect displayEffect;

        public AlchemyCraftElement(IPosition position, ItemStack bottleStack, AlchemyTableConfig.CraftableEffectConfig effectCfg) {
            super(position);
            this.bottleStack = bottleStack;
            this.effect = effectCfg;
            this.textStyle = LabelTextStyle.defaultStyle().shadow().build();
            this.displayEffect = BottleItem.getType(bottleStack).flatMap(effectCfg::createEffect).orElse(null);
            this.tooltip((ITooltipRenderer tooltipRenderer, PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) -> {
                if (this.canCraft()) {
                    return false;
                }
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return false;
                }
                if (!this.effect.hasPrerequisites((Player)player)) {
                    String displayStr = this.getEffect().getUnlockCategory().formatDisplay(new Object[0]);
                    tooltipRenderer.renderTooltip(poseStack, (Component)new TextComponent(displayStr).m_130940_(ChatFormatting.RED), mouseX, mouseY, TooltipDirection.RIGHT);
                    return true;
                }
                return false;
            });
        }

        public AlchemyTableConfig.CraftableEffectConfig getEffect() {
            return this.effect;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            this.setDisabled(!this.canCraft());
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            if (this.displayEffect != null) {
                this.getEffectDescription().ifPresent(cfgDisplay -> this.textStyle.textBorder().render(renderer, poseStack, (Component)cfgDisplay, TextWrap.wrap(), TextAlign.LEFT, this.worldSpatial.x() + 4, this.worldSpatial.y() + 3, this.worldSpatial.z(), this.worldSpatial.width()));
            }
        }

        @Override
        protected List<ItemStack> createNeededInputs() {
            return this.effect.createCraftingCost(this.bottleStack);
        }

        public Optional<Component> getEffectDescription() {
            return Optional.of(this.displayEffect.getTooltip());
        }

        private boolean canCraft() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            return player != null && !this.bottleStack.m_41619_() && this.effect.hasPrerequisites((Player)player);
        }
    }

    public static abstract class WorkbenchListElement<E extends WorkbenchListElement<E>>
    extends SelectableButtonElement<E> {
        private List<ItemStack> inputs;

        public WorkbenchListElement(IPosition position) {
            super(position, ScreenTextures.BUTTON_ALCHEMY_MODIFIER_TEXTURES, () -> {});
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            ItemRenderer ir = Minecraft.m_91087_().m_91291_();
            Font font = Minecraft.m_91087_().f_91062_;
            int offsetX = this.worldSpatial.x() + this.worldSpatial.width() - 18;
            int offsetY = this.worldSpatial.y() + this.worldSpatial.height() - 18;
            List<ItemStack> inputs = this.getInputs();
            List<Object> missingInputs = new ArrayList();
            if (Minecraft.m_91087_().f_91074_ != null) {
                missingInputs = InventoryUtil.getMissingInputs(inputs, Minecraft.m_91087_().f_91074_.m_150109_());
            }
            for (ItemStack stack : inputs) {
                ir.m_115123_(stack, offsetX, offsetY);
                TextComponent text = new TextComponent(String.valueOf(stack.m_41613_()));
                if (missingInputs.contains(stack)) {
                    text.m_130940_(ChatFormatting.RED);
                }
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 200.0);
                MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                font.m_92841_((Component)text, (float)(offsetX + 17 - font.m_92852_((FormattedText)text)), (float)(offsetY + 9), 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffers, false, 0, LightmapHelper.getPackedFullbrightCoords());
                buffers.m_109911_();
                poseStack.m_85849_();
                offsetX -= 17;
            }
        }

        protected List<ItemStack> getInputs() {
            if (this.inputs == null) {
                this.inputs = this.createNeededInputs();
            }
            return this.inputs;
        }

        protected abstract List<ItemStack> createNeededInputs();
    }
}

