/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.element.FakeItemSlotElement;
import iskallia.vault.client.gui.framework.element.ScrollableItemStackSelectorElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AscensionForgeSelectElement<E extends AscensionForgeSelectElement<E>>
extends ScrollableItemStackSelectorElement<E, AscencionForgeModelEntry> {
    protected int columns;
    protected ObservableSupplier<Set<ResourceLocation>> discoveredModelIds;

    public AscensionForgeSelectElement(ISpatial spatial, int columns, ObservableSupplier<Set<ResourceLocation>> discoveredModelIds, BiConsumer<ResourceLocation, ItemStack> onItemSelected) {
        super((ISpatial)Spatials.copy(spatial), columns, new DiscoveredModelSelectorModel(discoveredModelIds, onItemSelected));
        this.columns = columns;
        this.discoveredModelIds = discoveredModelIds;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        this.discoveredModelIds.ifChanged(models -> this.refreshElements());
    }

    public static class DiscoveredModelSelectorModel
    extends ScrollableItemStackSelectorElement.SelectorModel<AscencionForgeModelEntry> {
        private final ObservableSupplier<Set<ResourceLocation>> discoveredModelIds;
        private final BiConsumer<ResourceLocation, ItemStack> onItemSelected;

        public DiscoveredModelSelectorModel(ObservableSupplier<Set<ResourceLocation>> discoveredModelIds, BiConsumer<ResourceLocation, ItemStack> onItemSelected) {
            this.discoveredModelIds = discoveredModelIds;
            this.onItemSelected = onItemSelected;
        }

        @Override
        public List<AscencionForgeModelEntry> getEntries() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return Collections.emptyList();
            }
            Set<ResourceLocation> discoveredIds = this.discoveredModelIds.get();
            ArrayList<AscencionForgeModelEntry> entries = new ArrayList<AscencionForgeModelEntry>();
            ModConfigs.ASCENSION_FORGE.getListings().forEach(listing -> {
                if (listing.modelId() != null) {
                    ModDynamicModels.REGISTRIES.getModelAndAssociatedItem(listing.modelId()).ifPresent(pair -> {
                        ItemStack stack = new ItemStack((ItemLike)pair.getSecond());
                        Item patt3894$temp = stack.m_41720_();
                        if (patt3894$temp instanceof VaultGearItem) {
                            VaultGearItem vaultGearItem = (VaultGearItem)patt3894$temp;
                            VaultGearData gearData = VaultGearData.read(stack);
                            gearData.setState(VaultGearState.IDENTIFIED);
                            gearData.updateAttribute(ModGearAttributes.GEAR_MODEL, listing.modelId());
                            gearData.write(stack);
                            VaultGearRarity rarity = ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRarityOf(vaultGearItem, listing.modelId());
                            TextComponent cmp = new TextComponent(((DynamicModel)pair.getFirst()).getDisplayName());
                            cmp.m_130948_(Style.f_131099_.m_131148_(rarity.getColor()));
                            entries.add(new AscencionForgeModelEntry(stack, discoveredIds.contains(listing.modelId()), listing.modelId(), (Component)cmp));
                        }
                    });
                } else {
                    entries.add(new AscencionForgeModelEntry(listing.stack(), false, null, listing.stack().m_41786_()));
                }
            });
            Comparator<AscencionForgeModelEntry> comparator = Comparator.comparing(entry -> entry.getModelId() != null ? -1 : 1).thenComparing(entry -> discoveredIds.contains(entry.getModelId()) ? 1 : -1).thenComparing(entry -> entry.getTooltip().getString());
            entries.sort(comparator);
            return entries;
        }

        @Override
        public void onSelect(FakeItemSlotElement<?> slot, AscencionForgeModelEntry entry) {
            super.onSelect(slot, entry);
            this.onItemSelected.accept(entry.getModelId(), entry.getDisplayStack());
        }
    }

    public static class AscencionForgeModelEntry
    extends ScrollableItemStackSelectorElement.ItemSelectorEntry {
        @Nullable
        private final ResourceLocation modelId;
        private final Component tooltip;

        public AscencionForgeModelEntry(ItemStack displayStack, boolean isDisabled, @Nullable ResourceLocation modelId, Component tooltip) {
            super(displayStack, isDisabled);
            this.modelId = modelId;
            this.tooltip = tooltip;
        }

        @Nullable
        public ResourceLocation getModelId() {
            return this.modelId;
        }

        public Component getTooltip() {
            return this.tooltip;
        }

        @Override
        public void adjustSlot(FakeItemSlotElement<?> slot) {
            slot.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                if (this.isDisabled()) {
                    tooltipRenderer.renderTooltip(poseStack, (Component)new TextComponent("Discovered").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))), mouseX, mouseY, TooltipDirection.RIGHT);
                    return true;
                }
                tooltipRenderer.renderTooltip(poseStack, this.tooltip, mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            });
        }
    }
}

