/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.jetbrains.annotations.NotNull;

public class ClickableLabelElement
extends LabelElement<ClickableLabelElement>
implements IGuiEventElement {
    private Consumer<ClickableLabelElement> onClick;
    protected Supplier<Boolean> disabled;
    protected boolean wasDisabled = false;
    protected boolean clickHeld = false;
    protected Component originalComponent;
    protected TextColor baseColor;
    protected TextColor hoverColor;
    protected TextColor disabledColor;

    public ClickableLabelElement(IPosition position, Component component, LabelTextStyle.Builder labelTextStyle, Runnable onClick) {
        this(position, component, TextColor.m_131270_((ChatFormatting)ChatFormatting.BLACK), TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN), TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY), labelTextStyle, onClick);
    }

    public ClickableLabelElement(IPosition position, Component component, TextColor baseColor, TextColor hoverColor, TextColor disabledColor, LabelTextStyle.Builder labelTextStyle, Runnable onClick) {
        super(position, component, labelTextStyle);
        this.baseColor = baseColor;
        this.hoverColor = hoverColor;
        this.disabledColor = disabledColor;
        this.originalComponent = this.component = component.m_6881_().m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131148_(baseColor));
        this.onClick = label -> onClick.run();
        this.setDisabled(false);
    }

    public void setOnClick(Consumer<ClickableLabelElement> onClick) {
        this.onClick = this.onClick.andThen(onClick);
    }

    public void setOnClick(Runnable onClick) {
        this.setOnClick((ClickableLabelElement btn) -> onClick.run());
    }

    public ClickableLabelElement setDisabled(boolean disabled) {
        this.setDisabled(() -> disabled);
        return this;
    }

    public ClickableLabelElement setDisabled(Supplier<Boolean> disabled) {
        if (this.disabled != null && this.isDisabled() && !disabled.get().booleanValue()) {
            this.wasDisabled = true;
        }
        this.disabled = disabled;
        return this;
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
        if (buttonIndex == 0) {
            this.clickHeld = true;
        }
        return true;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int buttonIndex, double dragX, double dragY) {
        boolean dragged = IGuiEventElement.super.m_7979_(mouseX, mouseY, buttonIndex, dragX, dragY);
        if (!this.containsMouse(mouseX, mouseY)) {
            this.clickHeld = false;
            this.component = this.originalComponent;
        }
        return dragged;
    }

    @Override
    public void onMouseMoved(double mouseX, double mouseY) {
        IGuiEventElement.super.onMouseMoved(mouseX, mouseY);
        this.component = this.containsMouse(mouseX, mouseY) ? this.component.m_6881_().m_130948_(this.component.m_7383_().m_131148_(this.hoverColor)) : this.originalComponent;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int buttonIndex) {
        if (!this.isDisabled() && this.clickHeld) {
            this.onClick.accept(this);
            this.playDownSound(Minecraft.m_91087_().m_91106_());
        }
        return true;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int buttonIndex) {
        boolean release = IGuiEventElement.super.m_6348_(mouseX, mouseY, buttonIndex);
        this.clickHeld = false;
        return release;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        if (this.isDisabled()) {
            this.component = this.component.m_6881_().m_130948_(this.component.m_7383_().m_131148_(this.disabledColor));
        } else if (this.wasDisabled) {
            this.component = this.originalComponent;
            this.wasDisabled = false;
        }
    }
}

