/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.element.FakeItemSlotElement;
import iskallia.vault.client.gui.framework.element.ScrollableItemStackSelectorElement;
import iskallia.vault.client.gui.framework.element.SelectableFakeItemSlotElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftingSelectorElement<E extends CraftingSelectorElement<E>>
extends ScrollableItemStackSelectorElement<E, CraftingEntry> {
    private final ObservableSupplier<Set<ResourceLocation>> discoveredTrinkets;

    public CraftingSelectorElement(ISpatial spatial, int slotColumns, List<VaultForgeRecipe> recipes, ObservableSupplier<Set<ResourceLocation>> discoveredTrinkets, BiConsumer<VaultForgeRecipe, Boolean> onRecipeSelect, Function<List<ItemStack>, List<ItemStack>> inputItemCheck) {
        this(spatial, slotColumns, recipes, discoveredTrinkets, onRecipeSelect, inputItemCheck, () -> VaultBarOverlay.vaultLevel);
    }

    public CraftingSelectorElement(ISpatial spatial, int slotColumns, List<VaultForgeRecipe> recipes, ObservableSupplier<Set<ResourceLocation>> discoveredTrinkets, BiConsumer<VaultForgeRecipe, Boolean> onRecipeSelect, Function<List<ItemStack>, List<ItemStack>> inputItemCheck, Supplier<Integer> craftingLevelSupplier) {
        super(spatial, slotColumns, new CraftingSelector(recipes, onRecipeSelect, inputItemCheck, craftingLevelSupplier));
        this.discoveredTrinkets = discoveredTrinkets;
        this.selectorModel.onSlotSelect(this::changeSelection);
    }

    private void changeSelection(FakeItemSlotElement<?> slotElement) {
        this.getSelectorElements().forEach(fakeSlot -> {
            if (fakeSlot instanceof SelectableFakeItemSlotElement) {
                SelectableFakeItemSlotElement selectableSlot = (SelectableFakeItemSlotElement)fakeSlot;
                selectableSlot.setSelected(false);
            }
        });
        if (slotElement instanceof SelectableFakeItemSlotElement) {
            SelectableFakeItemSlotElement selectableSlot = (SelectableFakeItemSlotElement)slotElement;
            selectableSlot.setSelected(true);
        }
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        this.discoveredTrinkets.ifChanged(models -> this.refreshElements());
    }

    public boolean canCraftSelectedEntry() {
        CraftingSelector craftingSelector;
        CraftingEntry entry;
        ScrollableItemStackSelectorElement.SelectorModel selector = this.getSelectorModel();
        if (selector instanceof CraftingSelector && (entry = (CraftingEntry)(craftingSelector = (CraftingSelector)selector).getSelectedElement()) != null) {
            return entry.canCraft();
        }
        return false;
    }

    @Override
    protected FakeItemSlotElement<?> makeElementSlot(ISpatial spatial, Supplier<ItemStack> itemStack, TextureAtlasRegion slotTexture, TextureAtlasRegion disabledSlotTexture, Supplier<Boolean> disabled) {
        return new SelectableFakeItemSlotElement(spatial, itemStack, slotTexture, disabledSlotTexture, disabled);
    }

    public static class CraftingSelector
    extends ScrollableItemStackSelectorElement.SelectorModel<CraftingEntry> {
        private final List<VaultForgeRecipe> recipes;
        private final BiConsumer<VaultForgeRecipe, Boolean> onRecipeSelect;
        private final Function<List<ItemStack>, List<ItemStack>> inputItemCheck;
        private final Supplier<Integer> craftingLevelSupplier;

        public CraftingSelector(List<VaultForgeRecipe> recipes, BiConsumer<VaultForgeRecipe, Boolean> onRecipeSelect, Function<List<ItemStack>, List<ItemStack>> inputItemCheck, Supplier<Integer> craftingLevelSupplier) {
            this.recipes = recipes;
            this.onRecipeSelect = onRecipeSelect;
            this.inputItemCheck = inputItemCheck;
            this.craftingLevelSupplier = craftingLevelSupplier;
        }

        @Override
        public List<CraftingEntry> getEntries() {
            return this.recipes.stream().map(entry -> new CraftingEntry((VaultForgeRecipe)entry, this.inputItemCheck, this.craftingLevelSupplier)).toList();
        }

        @Override
        public void onSelect(FakeItemSlotElement<?> slot, CraftingEntry entry) {
            super.onSelect(slot, entry);
            this.onRecipeSelect.accept(entry.recipe, entry.canCraft());
        }
    }

    public static class CraftingEntry
    extends ScrollableItemStackSelectorElement.ItemSelectorEntry {
        private final VaultForgeRecipe recipe;
        private final Function<List<ItemStack>, List<ItemStack>> inputItemCheck;
        private final Supplier<Integer> craftingLevelSupplier;

        public CraftingEntry(VaultForgeRecipe recipe, Function<List<ItemStack>, List<ItemStack>> inputItemCheck, Supplier<Integer> craftingLevelSupplier) {
            super(recipe.getDisplayOutput(craftingLevelSupplier.get()), Minecraft.m_91087_().f_91074_ == null || !recipe.canCraft((Player)Minecraft.m_91087_().f_91074_));
            this.recipe = recipe;
            this.inputItemCheck = inputItemCheck;
            this.craftingLevelSupplier = craftingLevelSupplier;
        }

        public boolean canCraft() {
            List<ItemStack> inputs = this.recipe.getInputs();
            return this.inputItemCheck.apply(inputs).isEmpty();
        }

        @Override
        public ItemStack getDisplayStack() {
            return this.recipe.getDisplayOutput(this.craftingLevelSupplier.get());
        }

        @Override
        public void adjustSlot(FakeItemSlotElement<?> slot) {
            slot.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 500.0);
                if (this.isDisabled()) {
                    tooltipRenderer.renderTooltip(poseStack, this.recipe.getDisabledText(), mouseX, mouseY, TooltipDirection.RIGHT);
                    poseStack.m_85849_();
                    return true;
                }
                List<ItemStack> inputs = this.recipe.getInputs();
                List<ItemStack> missingInputs = this.inputItemCheck.apply(inputs);
                ArrayList<Component> text = new ArrayList<Component>();
                ItemStack result = this.recipe.getDisplayOutput(this.craftingLevelSupplier.get());
                text.add((Component)new TextComponent("Craft: ").m_7220_(result.m_41786_()));
                this.recipe.addCraftingDisplayTooltip(result, text);
                for (ItemStack in : this.recipe.getInputs()) {
                    ChatFormatting color = ChatFormatting.GREEN;
                    if (missingInputs.contains(in)) {
                        color = ChatFormatting.RED;
                    }
                    text.add((Component)new TextComponent("- ").m_7220_(in.m_41786_()).m_130946_(" x" + in.m_41613_()).m_130940_(color));
                }
                tooltipRenderer.renderComponentTooltip(poseStack, text, mouseX, mouseY, TooltipDirection.RIGHT);
                poseStack.m_85849_();
                return true;
            });
        }
    }
}

