/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.TransmogTableBlock;
import iskallia.vault.client.gui.framework.element.FakeItemSlotElement;
import iskallia.vault.client.gui.framework.element.ScrollableItemStackSelectorElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.dynamodel.registry.DynamicModelRegistry;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DiscoveredModelSelectElement<E extends DiscoveredModelSelectElement<E>>
extends ScrollableItemStackSelectorElement<E, TransmogModelEntry> {
    protected int columns;
    protected ObservableSupplier<Item> gearItem;
    protected ObservableSupplier<Set<ResourceLocation>> discoveredModelIds;

    public DiscoveredModelSelectElement(ISpatial spatial, int columns, Supplier<Item> gearItem, ObservableSupplier<Set<ResourceLocation>> discoveredModelIds, Consumer<ResourceLocation> onModelSelected) {
        super((ISpatial)Spatials.copy(spatial), columns, new DiscoveredModelSelectorModel(ObservableSupplier.of(gearItem, Objects::deepEquals), discoveredModelIds, onModelSelected));
        this.columns = columns;
        this.gearItem = ObservableSupplier.of(gearItem, Objects::deepEquals);
        this.discoveredModelIds = discoveredModelIds;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        this.gearItem.ifChanged(item -> {
            this.verticalScrollBarElement.setValue(0.0f);
            this.refreshElements();
        });
        this.discoveredModelIds.ifChanged(models -> this.refreshElements());
    }

    public static class DiscoveredModelSelectorModel
    extends ScrollableItemStackSelectorElement.SelectorModel<TransmogModelEntry> {
        private final ObservableSupplier<Item> usedItem;
        private final ObservableSupplier<Set<ResourceLocation>> discoveredModelIds;
        private final Consumer<ResourceLocation> onModelSelected;

        public DiscoveredModelSelectorModel(ObservableSupplier<Item> usedItem, ObservableSupplier<Set<ResourceLocation>> discoveredModelIds, Consumer<ResourceLocation> onModelSelected) {
            this.usedItem = usedItem;
            this.discoveredModelIds = discoveredModelIds;
            this.onModelSelected = onModelSelected;
        }

        @Override
        public List<TransmogModelEntry> getEntries() {
            Item item = this.usedItem.get();
            if (!(item instanceof VaultGearItem)) {
                return Collections.emptyList();
            }
            VaultGearItem vaultGearItem = (VaultGearItem)item;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return Collections.emptyList();
            }
            Set<ResourceLocation> discoveredIds = this.discoveredModelIds.get();
            return ModDynamicModels.REGISTRIES.getAssociatedRegistry(item).map(arg_0 -> this.lambda$getEntries$2(discoveredIds, vaultGearItem, (Player)player, arg_0)).orElse(Collections.emptyList());
        }

        private ItemStack makeModelItem(VaultGearItem item, ResourceLocation modelId) {
            ItemStack stack = item.defaultItem();
            VaultGearData gearData = VaultGearData.read(stack);
            gearData.setState(VaultGearState.IDENTIFIED);
            gearData.updateAttribute(ModGearAttributes.GEAR_MODEL, modelId);
            gearData.write(stack);
            return stack;
        }

        @Override
        public void onSelect(FakeItemSlotElement<?> slot, TransmogModelEntry entry) {
            super.onSelect(slot, entry);
            this.onModelSelected.accept(entry.getModelId());
        }

        private /* synthetic */ List lambda$getEntries$2(Set discoveredIds, VaultGearItem vaultGearItem, Player player, DynamicModelRegistry modelRegistry) {
            ArrayList<ResourceLocation> modelIds = new ArrayList<ResourceLocation>(modelRegistry.getIds());
            modelIds.sort((id1, id2) -> {
                VaultGearRarity rarity2;
                boolean special2;
                boolean discovered2;
                boolean discovered1 = discoveredIds.contains(id1);
                if (discovered1 != (discovered2 = discoveredIds.contains(id2))) {
                    return discovered1 ? -1 : 1;
                }
                boolean special1 = ModConfigs.GEAR_MODEL_ROLL_RARITIES.canAppearNormally(vaultGearItem, (ResourceLocation)id1);
                if (special1 != (special2 = ModConfigs.GEAR_MODEL_ROLL_RARITIES.canAppearNormally(vaultGearItem, (ResourceLocation)id2))) {
                    return special1 ? -1 : 1;
                }
                VaultGearRarity rarity1 = ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRarityOf(vaultGearItem, (ResourceLocation)id1);
                if (rarity1 != (rarity2 = ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRarityOf(vaultGearItem, (ResourceLocation)id2))) {
                    return Integer.compare(rarity1.ordinal(), rarity2.ordinal());
                }
                String name1 = modelRegistry.get((ResourceLocation)id1).map(DynamicModel::getDisplayName).orElse("");
                String name2 = modelRegistry.get((ResourceLocation)id2).map(DynamicModel::getDisplayName).orElse("");
                return name1.compareTo(name2);
            });
            return modelIds.stream().map(modelRegistry::get).filter(Optional::isPresent).map(Optional::get).map(model -> new TransmogModelEntry(this.makeModelItem(vaultGearItem, model.getId()), !TransmogTableBlock.canTransmogModel(player, discoveredIds, model.getId()), (DynamicModel)model)).toList();
        }
    }

    public static class TransmogModelEntry
    extends ScrollableItemStackSelectorElement.ItemSelectorEntry {
        private final DynamicModel model;

        public TransmogModelEntry(ItemStack displayStack, boolean isDisabled, DynamicModel model) {
            super(displayStack, isDisabled);
            this.model = model;
        }

        public ResourceLocation getModelId() {
            return this.model.getId();
        }

        @Override
        public void adjustSlot(FakeItemSlotElement<?> slot) {
            slot.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                Item patt7754$temp = this.getDisplayStack().m_41720_();
                if (!(patt7754$temp instanceof VaultGearItem)) {
                    return true;
                }
                VaultGearItem vaultGearItem = (VaultGearItem)patt7754$temp;
                VaultGearRarity rarity = ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRarityOf(vaultGearItem, this.model.getId());
                if (this.isDisabled()) {
                    tooltipRenderer.renderTooltip(poseStack, (Component)new TextComponent("Undiscovered").m_130948_(Style.f_131099_.m_131148_(rarity.getColor()).m_131155_(Boolean.valueOf(true))), mouseX, mouseY, TooltipDirection.RIGHT);
                    return true;
                }
                TextComponent cmp = new TextComponent(this.model.getDisplayName());
                cmp.m_130948_(Style.f_131099_.m_131148_(rarity.getColor()));
                tooltipRenderer.renderTooltip(poseStack, (Component)cmp, mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            });
        }
    }
}

