/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextAlign;
import iskallia.vault.client.gui.framework.text.TextWrap;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class EnchantBookElement<E extends EnchantBookElement<E>>
extends ElasticContainerElement<E> {
    private static final ResourceLocation VANILLA_BOOK_LOCATION = new ResourceLocation("textures/entity/enchanting_table_book.png");
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    private ResourceLocation texture = VANILLA_BOOK_LOCATION;
    private final Random random = new Random();
    private BookModel bookModel = new BookModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171271_));
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    private boolean last;
    private LabelTextStyle topTextstyle;
    private LabelTextStyle bottomTextStyle;
    protected Supplier<Integer> levelCost;
    protected Supplier<Boolean> shouldOpen;

    public EnchantBookElement(IPosition position, ISize size, Supplier<Integer> levelCost, Supplier<Boolean> shouldOpen) {
        super(Spatials.positionXYZ(position).size(size));
        this.levelCost = levelCost;
        this.shouldOpen = shouldOpen;
        this.topTextstyle = LabelTextStyle.border4(TextColor.m_131266_((int)-14664184)).left().build();
        this.bottomTextStyle = LabelTextStyle.border8(TextColor.m_131266_((int)-14664184)).left().build();
    }

    public EnchantBookElement<E> withCustomTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    @Override
    public void render(IElementRenderer renderer, @Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        int posX = this.getWorldSpatial().x();
        int posY = this.getWorldSpatial().y();
        Lighting.m_84930_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (screenWidth - this.imageWidth) / 2;
        int j = (screenHeight - this.imageHeight) / 2;
        int k = (int)Minecraft.m_91087_().m_91268_().m_85449_();
        RenderSystem.m_69949_((int)(posX * k - 100 * k), (int)(-posY * k + screenHeight * k - 145 * k), (int)(320 * k), (int)(240 * k));
        Matrix4f matrix4f = Matrix4f.m_27653_((float)-0.34f, (float)0.23f, (float)0.0f);
        matrix4f.m_27644_(Matrix4f.m_27625_((double)90.0, (float)1.3333334f, (float)9.0f, (float)80.0f));
        RenderSystem.m_157183_();
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        poseStack.m_85836_();
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        posestack$pose.m_85861_().m_27624_();
        posestack$pose.m_85864_().m_8180_();
        poseStack.m_85837_(0.0, 0.0, 1984.0);
        float f = 4.0f;
        poseStack.m_85841_(f, f, f);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(20.0f));
        float f1 = Mth.m_14179_((float)partialTick, (float)this.oOpen, (float)this.open);
        poseStack.m_85837_((double)((1.0f - f1) * 0.2f), (double)((1.0f - f1) * 0.1f), (double)((1.0f - f1) * 0.25f));
        float f2 = -(1.0f - f1) * 90.0f - 90.0f;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(f2));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        float f3 = Mth.m_14179_((float)partialTick, (float)this.oFlip, (float)this.flip) + 0.25f;
        float f4 = Mth.m_14179_((float)partialTick, (float)this.oFlip, (float)this.flip) + 0.75f;
        f3 = (f3 - (float)Mth.m_14080_((double)f3)) * 1.6f - 0.3f;
        f4 = (f4 - (float)Mth.m_14080_((double)f4)) * 1.6f - 0.3f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.bookModel.m_102292_(0.0f, f3, f4, f1);
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer vertexconsumer = multibuffersource$buffersource.m_6299_(this.bookModel.m_103119_(this.texture));
        this.bookModel.m_7695_(poseStack, vertexconsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        multibuffersource$buffersource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.m_69949_((int)0, (int)0, (int)Minecraft.m_91087_().m_91268_().m_85441_(), (int)Minecraft.m_91087_().m_91268_().m_85442_());
        RenderSystem.m_157424_();
        Integer cost = this.levelCost.get();
        if (this.shouldOpen.get().booleanValue() && cost != null && cost != 0) {
            this.topTextstyle.textBorder().render(renderer, poseStack, (Component)new TextComponent(String.valueOf(cost)).m_130948_(Style.f_131099_.m_178520_(-8455136)), TextWrap.wrap(), TextAlign.CENTER, posX - 45, posY - 10, 300, 100);
            float scl = 0.45f;
            poseStack.m_85836_();
            poseStack.m_85841_(scl, scl, scl);
            this.bottomTextStyle.textBorder().render(renderer, poseStack, (Component)new TextComponent("Level Cost").m_130948_(Style.f_131099_.m_178520_(-8455136)), TextWrap.wrap(), TextAlign.CENTER, (int)((float)(posX - 44) / scl), (int)((float)(posY - 1) / scl), 300, (int)(100.0f / scl));
            poseStack.m_85849_();
        }
    }

    public void tickBook() {
        boolean shouldOpen = this.shouldOpen.get();
        if (this.last != shouldOpen) {
            this.last = shouldOpen;
            do {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (this.flip <= this.flipT + 1.0f && this.flip >= this.flipT - 1.0f);
        }
        ++this.time;
        this.oFlip = this.flip;
        this.oOpen = this.open;
        boolean hasLevelCost = shouldOpen;
        this.open = hasLevelCost ? (this.open += 0.2f) : (this.open -= 0.2f);
        this.open = Mth.m_14036_((float)this.open, (float)0.0f, (float)1.0f);
        float f1 = (this.flipT - this.flip) * 0.4f;
        float f = 0.2f;
        f1 = Mth.m_14036_((float)f1, (float)-0.2f, (float)0.2f);
        this.flipA += (f1 - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }
}

