/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ScrollableListSelectorElement;
import iskallia.vault.client.gui.framework.element.SelectableButtonElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextAlign;
import iskallia.vault.client.gui.framework.text.TextWrap;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.util.ItemRenderHelper;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.EnchantmentEntry;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.RomanNumber;
import iskallia.vault.util.StringUtils;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EnchanterEnchantSelectorElement<E extends EnchanterEnchantSelectorElement<E, V>, V extends EnchanterListElement<V>>
extends ScrollableListSelectorElement<E, EnchantmentEntry, V> {
    public static final ResourceLocation ENCHANT_FONT = new ResourceLocation("minecraft", "alt");
    private final ObservableSupplier<ItemStack> inputSupplier;

    public EnchanterEnchantSelectorElement(ISpatial spatial, ObservableSupplier<ItemStack> inputSupplier, Supplier<String> searchFilter) {
        super((ISpatial)Spatials.copy(spatial).width(ScreenTextures.BUTTON_ENCHANTER_TEXTURES.button().width()), new EnchanterEnchantSelectorModel(inputSupplier, searchFilter));
        this.inputSupplier = inputSupplier;
    }

    public void onSelect(Consumer<EnchantmentEntry> fn) {
        ScrollableListSelectorElement.SelectorModel selectorModel = this.getSelectorModel();
        if (selectorModel instanceof EnchanterEnchantSelectorModel) {
            EnchanterEnchantSelectorModel selModel = (EnchanterEnchantSelectorModel)selectorModel;
            selModel.whenSelected(cfg -> {
                EnchantmentEntry entry = selModel.getSelectedEnchantingEntry();
                if (entry != null) {
                    fn.accept(entry);
                }
            });
        }
    }

    @Override
    public void render(IElementRenderer renderer, @Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        this.inputSupplier.ifChanged(change -> this.refreshElements());
    }

    public static class EnchanterEnchantSelectorModel<E extends EnchanterListElement<E>>
    extends ScrollableListSelectorElement.SelectorModel<E, EnchantmentEntry> {
        private final ObservableSupplier<ItemStack> inputSupplier;
        private final Supplier<String> searchFilter;

        public EnchanterEnchantSelectorModel(ObservableSupplier<ItemStack> inputSupplier, Supplier<String> searchFilter) {
            this.inputSupplier = inputSupplier;
            this.searchFilter = searchFilter;
        }

        @Override
        public List<EnchantmentEntry> getEntries() {
            ItemStack input = this.inputSupplier.get();
            if (input.m_41619_()) {
                return Collections.emptyList();
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return Collections.emptyList();
            }
            String searchTerm = this.searchFilter.get().toLowerCase(Locale.ROOT);
            Map currentEnchantments = EnchantmentHelper.m_44831_((ItemStack)input);
            ArrayList<EnchantmentEntry> out = new ArrayList<EnchantmentEntry>();
            for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
                String enchantName;
                if (enchantment.m_6589_() || !enchantment.m_6081_(input) || !(enchantName = new TranslatableComponent(enchantment.m_44704_()).getString()).toLowerCase(Locale.ROOT).contains(searchTerm)) continue;
                out.add(new EnchantmentEntry(enchantment, enchantment.m_6586_()));
            }
            HashMap canCraftLookup = new HashMap();
            out.forEach(enchantmentEntry -> canCraftLookup.put(enchantmentEntry, EnchanterEnchantSelectorModel.canCraft(input, enchantmentEntry)));
            HashMap alreadyHasLookup = new HashMap();
            out.forEach(enchantmentEntry -> alreadyHasLookup.put(enchantmentEntry, currentEnchantments.getOrDefault(enchantmentEntry.getEnchantment(), 0) >= enchantmentEntry.getLevel()));
            out.sort(Comparator.comparing(o -> o.getEnchantment().getRegistryName().toString()));
            out.sort((c1, c2) -> -Boolean.compare((Boolean)canCraftLookup.get(c1), (Boolean)canCraftLookup.get(c2)));
            out.sort((c1, c2) -> Boolean.compare((Boolean)alreadyHasLookup.get(c1), (Boolean)alreadyHasLookup.get(c2)));
            return out;
        }

        @Override
        public E createSelectable(ISpatial spatial, EnchantmentEntry entry) {
            EnchanterListElement e = new EnchanterListElement((IPosition)spatial, this.inputSupplier.get(), entry);
            return (E)e;
        }

        @Nullable
        protected EnchantmentEntry getSelectedEnchantingEntry() {
            EnchanterListElement element = (EnchanterListElement)this.getSelectedElement();
            if (element == null) {
                return null;
            }
            return element.getConfig();
        }

        public static boolean canCraft(ItemStack gearStack, EnchantmentEntry config) {
            boolean hasExp;
            if (gearStack.m_41619_()) {
                return false;
            }
            if (config.getEnchantment() == null) {
                return false;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return false;
            }
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)gearStack);
            boolean bl = hasExp = player.m_7500_() || player.f_36078_ >= ModConfigs.VAULT_GEAR_ENCHANTMENT_CONFIG.getCost(config).getLevels();
            if (!hasExp) {
                return false;
            }
            return config.getEnchantment() != null && (enchantments.get(config.getEnchantment()) == null || (Integer)enchantments.get(config.getEnchantment()) < config.getLevel());
        }
    }

    public static class EnchanterListElement<E extends EnchanterListElement<E>>
    extends SelectableButtonElement<E> {
        private final ItemStack gearStack;
        private final EnchantmentEntry config;
        private final LabelTextStyle textStyle;
        private List<ItemStack> inputs;
        private List<Enchantment> incompatibleEnchants;

        public EnchanterListElement(IPosition position, ItemStack gearStack, EnchantmentEntry config) {
            super(position, ScreenTextures.BUTTON_ENCHANTER_TEXTURES, () -> {});
            this.gearStack = gearStack;
            this.config = config;
            this.textStyle = LabelTextStyle.defaultStyle().shadow().build();
            Enchantment enchantment = this.config.getEnchantment();
            Map gearEnchantments = EnchantmentHelper.m_44831_((ItemStack)this.gearStack);
            this.incompatibleEnchants = gearEnchantments.keySet().stream().filter(other -> other != enchantment && !other.m_44695_(enchantment)).toList();
            this.tooltip((ITooltipRenderer tooltipRenderer, PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return false;
                }
                List<ItemStack> missingItems = InventoryUtil.getMissingInputs(config.getCost().getItems(), player.m_150109_());
                LinkedList<Component> tooltip = new LinkedList<Component>();
                tooltip.add((Component)new TranslatableComponent(enchantment.m_44704_()).m_130946_(" " + RomanNumber.toRoman(config.getLevel())).m_130940_(ChatFormatting.LIGHT_PURPLE));
                if (this.isSelected()) {
                    tooltip.add((Component)new TextComponent("Currently selected").m_130940_(ChatFormatting.DARK_PURPLE).m_130940_(ChatFormatting.ITALIC));
                }
                if (gearEnchantments.get(config.getEnchantment()) != null && (Integer)gearEnchantments.get(config.getEnchantment()) >= config.getLevel()) {
                    tooltip.add((Component)new TextComponent(""));
                    tooltip.add((Component)new TextComponent("Already enchanted with this enchantment").m_130940_(ChatFormatting.RED));
                }
                if (!this.incompatibleEnchants.isEmpty()) {
                    tooltip.add((Component)new TextComponent(""));
                    tooltip.add((Component)new TextComponent("Enchanting with this will ").m_130940_(ChatFormatting.DARK_RED));
                    tooltip.add((Component)new TextComponent("remove following enchantment(s):").m_130940_(ChatFormatting.DARK_RED));
                    for (Enchantment incompatibleEnchant : this.incompatibleEnchants) {
                        tooltip.add((Component)new TextComponent("\u2600 ").m_7220_((Component)new TranslatableComponent(incompatibleEnchant.m_44704_())).m_130946_(" " + RomanNumber.toRoman((Integer)gearEnchantments.get(incompatibleEnchant))).m_130940_(ChatFormatting.RED));
                    }
                }
                tooltip.add((Component)new TextComponent(""));
                tooltip.add((Component)new TextComponent("Cost:"));
                for (ItemStack costStack : config.getCost().getItems()) {
                    boolean missing = missingItems.contains(costStack);
                    tooltip.add((Component)new TextComponent((missing ? "\u2718 " : "\u2714 ") + costStack.m_41613_() + "x ").m_7220_((Component)costStack.m_41786_().m_6881_()).m_130940_(missing ? ChatFormatting.RED : ChatFormatting.GREEN));
                }
                int levelCost = config.getCost().getLevels();
                if (levelCost != 0) {
                    boolean missing = player.f_36078_ < levelCost;
                    tooltip.add((Component)new TextComponent((missing ? "\u2718 " : "\u2714 ") + levelCost + " EXP Levels").m_130940_(missing ? ChatFormatting.RED : ChatFormatting.GREEN));
                }
                tooltipRenderer.renderTooltip(poseStack, tooltip, mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.RIGHT);
                return true;
            });
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)this.gearStack);
            int currentLevel = enchantments.getOrDefault(this.config.getEnchantment(), 0);
            this.setDisabled(currentLevel >= this.config.getLevel());
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            Font font = Minecraft.m_91087_().f_91062_;
            int offsetX = this.worldSpatial.x() + this.worldSpatial.width() - 18;
            int offsetY = this.worldSpatial.y() + this.worldSpatial.height() - 18;
            List<ItemStack> inputs = this.getInputs();
            List<Object> missingInputs = new ArrayList();
            if (Minecraft.m_91087_().f_91074_ != null) {
                missingInputs = InventoryUtil.getMissingInputs(inputs, Minecraft.m_91087_().f_91074_.m_150109_());
            }
            for (ItemStack stack : inputs) {
                float scl = 0.8f;
                ItemRenderHelper.renderGuiItem(stack, offsetX, offsetY, modelViewStack -> modelViewStack.m_85841_(scl, scl, scl));
                TextComponent text = new TextComponent(String.valueOf(stack.m_41613_()));
                if (missingInputs.contains(stack)) {
                    text.m_130940_(ChatFormatting.RED);
                }
                poseStack.m_85836_();
                poseStack.m_85837_((double)(offsetX + 17 - font.m_92852_((FormattedText)text)), (double)(offsetY + 9), 200.0);
                poseStack.m_85841_(scl, scl, scl);
                MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                font.m_92841_((Component)text, 0.0f, 0.0f, 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffers, false, 0, LightmapHelper.getPackedFullbrightCoords());
                buffers.m_109911_();
                poseStack.m_85849_();
                offsetX -= 17;
            }
            Enchantment enchantment = this.config.getEnchantment();
            TranslatableComponent enchantNameText = new TranslatableComponent(enchantment.m_44704_());
            this.textStyle.textBorder().render(renderer, poseStack, (Component)enchantNameText.m_6881_().m_130946_(" " + RomanNumber.toRoman(this.config.getLevel())).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)(this.isDisabled() ? -9740731 : -11911124)))), TextWrap.overflow(), TextAlign.LEFT, this.worldSpatial.x() + 4, this.worldSpatial.y() + 4, this.worldSpatial.z(), this.worldSpatial.width());
            String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toUpperCase();
            String gibberishName = enchantNameText.getString().replaceAll("\\s+", "") + alphabet.charAt(this.config.getLevel() % alphabet.length());
            this.textStyle.textBorder().render(renderer, poseStack, (Component)new TextComponent(StringUtils.truncateMaxLength(gibberishName, 12)).m_130948_(Style.f_131099_.m_131150_(ENCHANT_FONT)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)(this.incompatibleEnchants.isEmpty() ? -10003127 : -5307855)))), TextWrap.wrap(), TextAlign.LEFT, this.worldSpatial.x() + 4, this.worldSpatial.y() + 15, this.worldSpatial.z(), this.worldSpatial.width());
        }

        public EnchantmentEntry getConfig() {
            return this.config;
        }

        protected List<ItemStack> getInputs() {
            if (this.inputs == null) {
                this.inputs = this.createNeededInputs();
            }
            return this.inputs;
        }

        protected List<ItemStack> createNeededInputs() {
            return this.config.getCost().getItems();
        }

        private boolean canCraft() {
            return EnchanterEnchantSelectorModel.canCraft(this.gearStack, this.config);
        }
    }
}

