/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.render.NineSlice;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class EntityModelElement<E extends EntityModelElement<E>>
extends ElasticContainerElement<E>
implements IGuiEventElement {
    protected final Supplier<LivingEntity> livingEntitySupplier;
    protected Vector3f entityOffset;
    protected float entityScale;
    protected boolean advancedControl;
    protected boolean dragging;
    protected int draggedButton;
    private float xYaw = 0.0f;
    private float yPitch = 0.0f;
    private double mouseX;
    private double mouseY;
    private double prevMouseX;
    private double prevMouseY;

    private double mouseDeltaX() {
        return this.mouseX - this.prevMouseX;
    }

    private double mouseDeltaY() {
        return this.mouseY - this.prevMouseY;
    }

    public EntityModelElement(IPosition position, ISize size, Supplier<LivingEntity> livingEntitySupplier) {
        this(position, size, livingEntitySupplier, IPosition.ZERO, 1.0f);
    }

    public EntityModelElement(IPosition position, ISize size, Supplier<LivingEntity> livingEntitySupplier, IPosition entityOffset, float entityScale) {
        this(position, size, livingEntitySupplier, entityOffset, entityScale, ScreenTextures.INSET_BLACK_BACKGROUND);
    }

    public EntityModelElement(IPosition position, ISize size, Supplier<LivingEntity> livingEntitySupplier, IPosition entityOffset, float entityScale, NineSlice.TextureRegion background) {
        super(Spatials.positionXYZ(position));
        this.livingEntitySupplier = livingEntitySupplier;
        this.entityOffset = new Vector3f((float)entityOffset.x(), (float)entityOffset.y(), (float)entityOffset.z());
        this.entityScale = entityScale;
        this.addElement(new NineSliceElement(Spatials.size(size), background));
    }

    public EntityModelElement(IPosition position, ISize size, Supplier<LivingEntity> livingEntitySupplier, Vector3f entityOffset, float entityScale) {
        this(position, size, livingEntitySupplier, entityOffset, entityScale, ScreenTextures.INSET_BLACK_BACKGROUND);
    }

    public EntityModelElement(IPosition position, ISize size, Supplier<LivingEntity> livingEntitySupplier, Vector3f entityOffset, float entityScale, NineSlice.TextureRegion background) {
        super(Spatials.positionXYZ(position));
        this.livingEntitySupplier = livingEntitySupplier;
        this.entityOffset = new Vector3f(entityOffset.m_122239_(), entityOffset.m_122260_(), entityOffset.m_122269_());
        this.entityScale = entityScale;
        this.addElement(new NineSliceElement(Spatials.size(size), background));
    }

    public EntityModelElement<?> advancedControl() {
        this.advancedControl = true;
        this.addElement(new LabelElement((IPosition)Spatials.positionXY(2, 2).width(this.width()), (Component)new TextComponent("Scroll: Zoom").m_130940_(ChatFormatting.DARK_GRAY), LabelTextStyle.defaultStyle().wrap()));
        this.addElement(new LabelElement((IPosition)Spatials.positionXY(2, 26).width(this.width()), (Component)new TextComponent("Right Click: Move").m_130940_(ChatFormatting.DARK_GRAY), LabelTextStyle.defaultStyle().wrap()));
        this.addElement(new LabelElement((IPosition)Spatials.positionXY(2, 14).width(this.width()), (Component)new TextComponent("Left Click: Rotate").m_130940_(ChatFormatting.DARK_GRAY), LabelTextStyle.defaultStyle().wrap()));
        return this;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
        if (this.advancedControl && (buttonIndex == 0 || buttonIndex == 1)) {
            this.dragging = true;
            this.draggedButton = buttonIndex;
        }
        return true;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int buttonIndex) {
        if (this.advancedControl && (buttonIndex == 0 || buttonIndex == 1)) {
            this.dragging = false;
            this.draggedButton = -1;
        }
        return super.m_6348_(mouseX, mouseY, buttonIndex);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int buttonIndex, double dragX, double dragY) {
        if (!this.advancedControl) {
            return super.m_7979_(mouseX, mouseY, buttonIndex, dragX, dragY);
        }
        return this.dragging && this.isEnabled() && this.onMouseDragged(mouseX, mouseY, buttonIndex, dragX, dragY);
    }

    @Override
    public boolean onMouseDragged(double mouseX, double mouseY, int buttonIndex, double dragX, double dragY) {
        if (this.advancedControl && buttonIndex == 1) {
            this.entityOffset = new Vector3f((float)((double)this.entityOffset.m_122239_() + dragX), (float)((double)this.entityOffset.m_122260_() + dragY), this.entityOffset.m_122269_());
            return true;
        }
        return super.onMouseDragged(mouseX, mouseY, buttonIndex, dragX, dragY);
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.advancedControl) {
            float increment = (float)(delta * (double)0.1f);
            float newScale = this.entityScale + increment;
            this.entityScale = Mth.m_14036_((float)newScale, (float)0.1f, (float)5.0f);
        }
        return super.onMouseScrolled(mouseX, mouseY, delta);
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        this.prevMouseX = this.mouseX;
        this.prevMouseY = this.mouseY;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        IMutableSpatial bounds = Spatials.copy(this.getWorldSpatial()).add(Spatials.positionXY(1, 1).size(-2, -2));
        renderer.beginClipRegion(bounds);
        LivingEntity livingEntity = this.livingEntitySupplier.get();
        if (livingEntity != null) {
            ISpatial worldSpatial = this.getWorldSpatial();
            float entityRenderX = (float)worldSpatial.x() + (float)worldSpatial.width() / 2.0f + this.entityOffset.m_122239_();
            float entityRenderY = (float)(worldSpatial.y() + (worldSpatial.height() - 16)) + this.entityOffset.m_122260_();
            poseStack.m_85836_();
            poseStack.m_85837_((double)entityRenderX, (double)entityRenderY, (double)this.entityOffset.m_122269_());
            poseStack.m_85841_(this.entityScale, this.entityScale, this.entityScale);
            this.renderEntity(livingEntity, poseStack, entityRenderX - (float)mouseX, entityRenderY - (float)mouseY - 50.0f);
            poseStack.m_85849_();
        }
        renderer.endClipRegion();
    }

    public void renderEntity(LivingEntity entity, PoseStack renderStack, float containerMouseX, float containerMouseY) {
        if (this.advancedControl) {
            boolean advancedRotation;
            boolean bl = advancedRotation = this.dragging && this.draggedButton == 0;
            if (advancedRotation) {
                this.xYaw = (float)((double)this.xYaw - this.mouseDeltaX());
                this.yPitch = (float)((double)this.yPitch - this.mouseDeltaY());
            }
        } else {
            this.xYaw = (float)Math.atan(containerMouseX / 40.0f);
            this.yPitch = (float)Math.atan(containerMouseY / 40.0f);
        }
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_(0.0, 0.0, 350.0);
        modelViewStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        renderStack.m_85836_();
        renderStack.m_85841_(30.0f, 30.0f, 30.0f);
        Quaternion rotationZ = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion rotationX = Vector3f.f_122223_.m_122240_(this.advancedControl ? this.yPitch * 2.0f : this.yPitch * 20.0f);
        rotationZ.m_80148_(rotationX);
        if (this.advancedControl) {
            renderStack.m_85837_(0.0, (double)(-entity.m_20206_()), 0.0);
            renderStack.m_85837_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
        }
        renderStack.m_85845_(rotationZ);
        if (this.advancedControl) {
            renderStack.m_85837_(0.0, (double)(-(entity.m_20206_() / 2.0f)), 0.0);
        }
        float yBodyRot = entity.f_20883_;
        float yRot = entity.m_146908_();
        float xRot = entity.m_146909_();
        float yHeadRotO = entity.f_20886_;
        float yHeadRot = entity.f_20885_;
        entity.f_20883_ = 180.0f + this.xYaw * (this.advancedControl ? 3.0f : 20.0f);
        entity.m_146922_(180.0f + this.xYaw * (this.advancedControl ? 3.0f : 40.0f));
        if (!this.advancedControl) {
            entity.m_146926_(-this.yPitch * 20.0f);
            entity.f_20885_ = entity.m_146908_();
            entity.f_20886_ = entity.m_146908_();
        } else {
            entity.f_20885_ = entity.f_20883_;
            entity.f_20886_ = entity.f_20883_;
        }
        RenderSystem.m_157450_((Vector3f)((Vector3f)Util.m_137469_((Object)new Vector3f(0.2f, -1.0f, -1.0f), Vector3f::m_122278_)), (Vector3f)((Vector3f)Util.m_137469_((Object)new Vector3f(0.0f, -0.5f, 1.0f), Vector3f::m_122278_)));
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        rotationX.m_80157_();
        entityRenderDispatcher.m_114412_(rotationX);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multiBufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, renderStack, (MultiBufferSource)multiBufferSource, 0xF000F0));
        multiBufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        if (!this.advancedControl) {
            entity.f_20883_ = yBodyRot;
            entity.m_146922_(yRot);
            entity.m_146926_(xRot);
            entity.f_20886_ = yHeadRotO;
            entity.f_20885_ = yHeadRot;
        }
        renderStack.m_85849_();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69482_();
        Lighting.m_84931_();
    }
}

