/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.block.entity.VaultJewelCuttingStationTileEntity;
import iskallia.vault.client.ClientExpertiseData;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.config.VaultJewelCuttingConfig;
import iskallia.vault.container.VaultJewelCuttingStationContainer;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.expertise.type.JewelExpertise;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class JewelCuttingButtonElement<E extends JewelCuttingButtonElement<E>>
extends ButtonElement<E> {
    private static final Random rand = new Random();

    public JewelCuttingButtonElement(IPosition position, Runnable onClick, VaultJewelCuttingStationContainer container) {
        super(position, ScreenTextures.BUTTON_CRAFT_TEXTURES, onClick);
        this.tooltip(Tooltips.multi(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return List.of();
            }
            long window = Minecraft.m_91087_().m_91268_().m_85439_();
            boolean shiftDown = InputConstants.m_84830_((long)window, (int)340) || InputConstants.m_84830_((long)window, (int)344);
            ItemStack inputItem = ItemStack.f_41583_;
            Slot inputSlot = container.getJewelInputSlot();
            if (inputSlot != null && !inputSlot.m_7993_().m_41619_()) {
                inputItem = inputSlot.m_7993_();
            }
            boolean hasInput = !inputItem.m_41619_();
            ArrayList<Object> tooltip = new ArrayList<Object>();
            VaultJewelCuttingConfig.JewelCuttingInput input = container.getTileEntity().getRecipeInput();
            VaultJewelCuttingConfig.JewelCuttingRange range = container.getTileEntity().getJewelCuttingRange();
            float chance = container.getTileEntity().getJewelCuttingModifierRemovalChance();
            int numberOfFreeCuts = 0;
            for (TieredSkill learnedTalentNode : ClientExpertiseData.getLearnedTalentNodes()) {
                LearnableSkill patt3197$temp = learnedTalentNode.getChild();
                if (!(patt3197$temp instanceof JewelExpertise)) continue;
                JewelExpertise jewelExpertise = (JewelExpertise)patt3197$temp;
                numberOfFreeCuts = jewelExpertise.getNumberOfFreeCuts();
            }
            ItemStack scrap = container.getScrapSlot().m_7993_();
            ItemStack bronze = container.getBronzeSlot().m_7993_();
            ItemStack finalInputItem = inputItem;
            if (hasInput) {
                VaultGearData data = VaultGearData.read(inputItem);
                ArrayList prefix = new ArrayList(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
                ArrayList suffix = new ArrayList(data.getModifiers(VaultGearModifier.AffixType.SUFFIX));
                int affixSize = prefix.size() + suffix.size();
                VaultGearRarity lowerRarity = VaultJewelCuttingStationTileEntity.getNewRarity(affixSize - 1);
                String jewelLowerRarity = "item.the_vault.jewel." + lowerRarity.name().toLowerCase(Locale.ROOT);
                MutableComponent lowerRarityComponent = new TranslatableComponent(jewelLowerRarity).m_130940_(ChatFormatting.YELLOW);
                VaultGearRarity rarity = VaultJewelCuttingStationTileEntity.getNewRarity(affixSize);
                String jewelRarity = "item.the_vault.jewel." + rarity.name().toLowerCase(Locale.ROOT);
                MutableComponent rarityComponent = new TranslatableComponent(jewelRarity).m_130940_(ChatFormatting.YELLOW);
                if (affixSize < 2) {
                    tooltip.add(new TextComponent("Cut the Jewel into a Gemstone"));
                } else {
                    tooltip.add(new TextComponent("Cut the jewel down in size (" + range.getMin() + "-" + range.getMax() + "), making it ").m_7220_((Component)lowerRarityComponent).m_7220_((Component)new TextComponent(".")));
                    tooltip.add(new TextComponent("This will make it lose a random affix."));
                }
                if (numberOfFreeCuts > 0) {
                    tooltip.add(TextComponent.f_131282_);
                    tooltip.add(new TextComponent("").m_7220_((Component)new TextComponent("* ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)new TextComponent("Your ")).m_7220_((Component)new TextComponent("Jeweler Expertise").m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)new TextComponent(" gives you ")).m_7220_((Component)new TextComponent(String.valueOf(numberOfFreeCuts)).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)new TextComponent(" free cut" + (numberOfFreeCuts == 1 ? "" : "s"))));
                    tooltip.add(new TextComponent("retaining its current grade."));
                    int usedFreeCuts = !inputItem.m_41784_().m_128441_("freeCuts") ? 0 : inputItem.m_41784_().m_128451_("freeCuts");
                    int remaining = numberOfFreeCuts - usedFreeCuts;
                    tooltip.add(new TextComponent("Expertise Cuts: ").m_7220_(this.addTooltipDots(usedFreeCuts, ChatFormatting.YELLOW)).m_7220_(this.addTooltipDots(remaining, ChatFormatting.GRAY)));
                }
                tooltip.add(TextComponent.f_131282_);
                tooltip.add(new TextComponent("Cost"));
                tooltip.add(new TextComponent("- ").m_7220_(input.getMainInput().m_41786_()).m_130946_(" x" + input.getMainInput().m_41613_()).m_130946_(" [%s]".formatted(scrap.m_41613_())).m_130940_(input.getMainInput().m_41613_() > scrap.m_41613_() ? ChatFormatting.RED : ChatFormatting.GREEN));
                tooltip.add(new TextComponent("- ").m_7220_(input.getSecondInput().m_41786_()).m_130946_(" x" + input.getSecondInput().m_41613_()).m_130946_(" [%s]".formatted(bronze.m_41613_())).m_130940_(input.getSecondInput().m_41613_() > bronze.m_41613_() ? ChatFormatting.RED : ChatFormatting.GREEN));
                tooltip.add(new TextComponent(""));
                if (shiftDown) {
                    tooltip.addAll(finalInputItem.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.ADVANCED));
                } else {
                    tooltip.addAll(finalInputItem.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL));
                }
                for (VaultGearAttributeInstance<Integer> sizeAttribute : data.getModifiers(ModGearAttributes.JEWEL_SIZE, VaultGearData.Type.ALL_MODIFIERS)) {
                    if (sizeAttribute.getValue() > 10) continue;
                    tooltip.add(new TextComponent(""));
                    tooltip.add(new TextComponent("Cannot cut size to lower than 10").m_130940_(ChatFormatting.RED));
                }
            } else {
                tooltip.add(new TextComponent("Requires Jewel").m_130940_(ChatFormatting.RED));
            }
            return tooltip;
        }));
    }

    private Component addTooltipDots(int amount, ChatFormatting formatting) {
        return new TextComponent("\u2b22 ".repeat(Math.max(0, amount))).m_130940_(formatting);
    }
}

