/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.container.VaultArtisanStationContainer;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.gear.modification.GearModificationAction;
import iskallia.vault.gear.modification.GearModificationCost;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.gear.tooltip.VaultGearTooltipItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModificationButtonElement<E extends ModificationButtonElement<E>>
extends ButtonElement<E> {
    private static final Random rand = new Random();

    public ModificationButtonElement(IPosition position, Runnable onClick, VaultArtisanStationContainer container, GearModification modification) {
        super(position, ScreenTextures.BUTTON_CRAFT_TEXTURES, onClick);
        this.tooltip(Tooltips.multi(() -> {
            GearModificationAction action = container.getModificationAction(modification);
            if (action == null) {
                return Collections.emptyList();
            }
            ItemStack inputItem = ItemStack.f_41583_;
            Slot inputSlot = action.getCorrespondingSlot(container);
            if (inputSlot != null && !inputSlot.m_7993_().m_41619_()) {
                inputItem = inputSlot.m_7993_();
            }
            ItemStack gearStack = container.getGearInputSlot().m_7993_();
            Integer itemData = AttributeGearData.read(gearStack);
            int potential = ((AttributeGearData)((Object)itemData)).getFirstValue(ModGearAttributes.CRAFTING_POTENTIAL).orElse(Integer.MIN_VALUE);
            boolean hasInput = !gearStack.m_41619_() && potential != Integer.MIN_VALUE;
            boolean failedModification = false;
            ArrayList<Component> tooltip = new ArrayList<Component>(modification.getDescription(inputItem));
            if (hasInput && !((AttributeGearData)((Object)itemData)).isModifiable()) {
                return List.of(new TranslatableComponent("the_vault.gear_modification.unmodifiable").m_130940_(ChatFormatting.RED));
            }
            if (hasInput && !inputItem.m_41619_() && !action.modification().canApply(gearStack, inputItem, container.getPlayer(), rand)) {
                tooltip.add(action.modification().getInvalidDescription(inputItem));
                failedModification = true;
            }
            if (!failedModification && hasInput) {
                MutableComponent focusCmp = !inputItem.m_41619_() ? new TextComponent("- ").m_7220_(modification.getDisplayStack().m_41786_()).m_130946_(" x1").m_130946_(" [%s]".formatted(inputItem.m_41613_())) : new TextComponent("Requires ").m_7220_(modification.getDisplayStack().m_41786_());
                focusCmp.m_130940_(inputItem.m_41619_() ? ChatFormatting.RED : ChatFormatting.GREEN);
                tooltip.add((Component)focusCmp);
            }
            if (hasInput) {
                if (!failedModification && !inputItem.m_41619_()) {
                    VaultGearData data = VaultGearData.read(gearStack);
                    String rollType = (String)data.get(ModGearAttributes.GEAR_ROLL_TYPE, VaultGearAttributeTypeMerger.firstNonNull());
                    GearModificationCost cost = GearModificationCost.getCost(data.getRarity(), rollType, data.getItemLevel(), potential, modification);
                    ItemStack plating = container.getPlatingSlot().m_7993_();
                    ItemStack bronze = container.getBronzeSlot().m_7993_();
                    tooltip.add((Component)new TextComponent("- ").m_7220_(new ItemStack((ItemLike)ModItems.VAULT_PLATING).m_41786_()).m_130946_(" x" + cost.costPlating()).m_130946_(" [%s]".formatted(plating.m_41613_())).m_130940_(cost.costPlating() > plating.m_41613_() ? ChatFormatting.RED : ChatFormatting.GREEN));
                    tooltip.add((Component)new TextComponent("- ").m_7220_(new ItemStack((ItemLike)ModBlocks.VAULT_BRONZE).m_41786_()).m_130946_(" x" + cost.costBronze()).m_130946_(" [%s]".formatted(bronze.m_41613_())).m_130940_(cost.costBronze() > bronze.m_41613_() ? ChatFormatting.RED : ChatFormatting.GREEN));
                }
                tooltip.add(TextComponent.f_131282_);
                tooltip.add(gearStack.m_41786_());
                Item patt5642$temp = gearStack.m_41720_();
                if (patt5642$temp instanceof VaultGearTooltipItem) {
                    VaultGearTooltipItem gearTooltipItem = (VaultGearTooltipItem)patt5642$temp;
                    tooltip.addAll(gearTooltipItem.createTooltip(gearStack, GearTooltip.craftingView()));
                }
            }
            return tooltip;
        }));
    }
}

