/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ScrollableListSelectorElement;
import iskallia.vault.client.gui.framework.element.SelectableButtonElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextAlign;
import iskallia.vault.client.gui.framework.text.TextWrap;
import iskallia.vault.config.gear.VaultGearWorkbenchConfig;
import iskallia.vault.gear.attribute.VaultGearModifier;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ModifierDiscoverySelectorElement
extends ScrollableListSelectorElement<ModifierDiscoverySelectorElement, Tuple<Item, ResourceLocation>, ModifierDiscoveryElement> {
    public ModifierDiscoverySelectorElement(ISpatial spatial, List<Tuple<Item, ResourceLocation>> gearModifiers) {
        super((ISpatial)Spatials.copy(spatial).width(ScreenTextures.BUTTON_MODIFIER_DISCOVERY_TEXTURES.button().width()), new ModifierDiscoverySelectorModel(gearModifiers));
        this.verticalScrollBarElement.setVisible(false);
    }

    public void onSelect(Consumer<Tuple<Item, ResourceLocation>> fn) {
        ScrollableListSelectorElement.SelectorModel selectorModel = this.getSelectorModel();
        if (selectorModel instanceof ModifierDiscoverySelectorModel) {
            ModifierDiscoverySelectorModel selModel = (ModifierDiscoverySelectorModel)selectorModel;
            selModel.whenSelected(cfg -> {
                ModifierDiscoveryElement option = (ModifierDiscoveryElement)selModel.getSelectedElement();
                if (option != null) {
                    fn.accept(new Tuple((Object)option.gearStack.m_41720_(), (Object)option.modifierId));
                }
            });
        }
    }

    public static class ModifierDiscoverySelectorModel
    extends ScrollableListSelectorElement.SelectorModel<ModifierDiscoveryElement, Tuple<Item, ResourceLocation>> {
        private final List<Tuple<Item, ResourceLocation>> gearModifiers;

        public ModifierDiscoverySelectorModel(List<Tuple<Item, ResourceLocation>> gearModifiers) {
            this.gearModifiers = gearModifiers;
        }

        @Override
        public List<Tuple<Item, ResourceLocation>> getEntries() {
            return this.gearModifiers;
        }

        @Override
        public ModifierDiscoveryElement createSelectable(ISpatial spatial, Tuple<Item, ResourceLocation> entry) {
            return new ModifierDiscoveryElement((IPosition)spatial, (Item)entry.m_14418_(), (ResourceLocation)entry.m_14419_());
        }
    }

    public static class ModifierDiscoveryElement
    extends SelectableButtonElement<ModifierDiscoveryElement> {
        private final ItemStack gearStack;
        @Nullable
        private final VaultGearModifier<?> displayModifier;
        private final LabelTextStyle textStyle;
        private final ResourceLocation modifierId;

        public ModifierDiscoveryElement(IPosition position, Item gearItem, ResourceLocation modifierId) {
            super(position, ScreenTextures.BUTTON_MODIFIER_DISCOVERY_TEXTURES, () -> {});
            this.gearStack = new ItemStack((ItemLike)gearItem);
            this.modifierId = modifierId;
            this.displayModifier = VaultGearWorkbenchConfig.getConfig(gearItem).map(c -> c.getConfig(modifierId)).flatMap(VaultGearWorkbenchConfig.CraftableModifierConfig::createModifier).orElse(null);
            this.textStyle = LabelTextStyle.defaultStyle().shadow().build();
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 1.0);
            this.getModifierDescription().ifPresent(cfgDisplay -> {
                this.textStyle.textBorder().render(renderer, poseStack, (Component)cfgDisplay, TextWrap.wrap(), TextAlign.LEFT, this.worldSpatial.x() + 4, this.worldSpatial.y() + 3, this.worldSpatial.z(), this.worldSpatial.width());
                this.textStyle.textBorder().render(renderer, poseStack, (Component)new TextComponent("(").m_130946_(this.gearStack.m_41786_().getString()).m_7220_((Component)new TextComponent(")")).m_130940_(ChatFormatting.GRAY), TextWrap.wrap(), TextAlign.LEFT, this.worldSpatial.x() + 4, this.worldSpatial.y() + 15, this.worldSpatial.z(), this.worldSpatial.width());
            });
            poseStack.m_85849_();
        }

        public Optional<MutableComponent> getModifierDescription() {
            return this.displayModifier == null ? Optional.empty() : this.displayModifier.getConfigDisplay(this.gearStack);
        }
    }
}

