/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.dynamodel.DynamicModelItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModRelics;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class RelicPedestalPreviewElement<E extends RelicPedestalPreviewElement<E>>
extends ElasticContainerElement<E> {
    protected Supplier<ResourceLocation> relicId;

    public RelicPedestalPreviewElement(IPosition position, ISize size, Supplier<ResourceLocation> relicId) {
        super(Spatials.positionXYZ(position).size(size));
        this.relicId = relicId;
        this.addElement(new NineSliceElement(Spatials.size(size), ScreenTextures.INSET_BLACK_BACKGROUND));
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85837_(0.0, (double)-0.2f, 0.0);
        matrixStack.m_85845_(Quaternion.m_175228_((float)0.5233334f, (float)0.0f, (float)0.0f));
        float scale = 0.8f;
        matrixStack.m_85841_(scale, scale, scale);
        this.renderItemStack(matrixStack, new ItemStack((ItemLike)ModBlocks.RELIC_PEDESTAL.m_5456_()));
        if (this.relicId.get() != ModRelics.EMPTY.getResultingRelic()) {
            matrixStack.m_85837_(0.0, 1.0, 0.0);
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.RELIC);
            DynamicModelItem.setGenericModelId(itemStack, this.relicId.get());
            this.renderItemStack(matrixStack, itemStack);
        }
    }

    private void renderItemStack(PoseStack matrixStack, ItemStack itemStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        ISpatial worldSpatial = this.getWorldSpatial();
        int playerRenderX = worldSpatial.x() + worldSpatial.width() / 2;
        int playerRenderY = worldSpatial.y() + worldSpatial.height() / 2;
        BakedModel bakedModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)playerRenderX, (double)playerRenderY, 350.0);
        posestack.m_85841_(32.0f, -32.0f, 32.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        matrixStack.m_85836_();
        double rotat = -90.0 * ((double)System.currentTimeMillis() / 1000.0) % 360.0 * 0.01745329238474369;
        matrixStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)((float)rotat), (float)0.0f));
        Lighting.m_84930_();
        minecraft.m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.FIXED, false, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        matrixStack.m_85849_();
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        posestack.m_85849_();
        RenderSystem.m_157182_();
    }
}

