/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.element.FakeItemSlotElement;
import iskallia.vault.client.gui.framework.element.ScrollableItemStackSelectorElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.dynamodel.DynamicModelItem;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModItems;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class RelicSelectElement<E extends RelicSelectElement<E>>
extends ScrollableItemStackSelectorElement<E, RelicEntry> {
    protected int columns;

    public RelicSelectElement(ISpatial spatial, int columns, Supplier<Set<ResourceLocation>> discoveredRelics, Consumer<ResourceLocation> onRelicSelect) {
        super((ISpatial)Spatials.copy(spatial), columns, new RelicSelectorModel(discoveredRelics, onRelicSelect));
        this.columns = columns;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
    }

    public static class RelicSelectorModel
    extends ScrollableItemStackSelectorElement.SelectorModel<RelicEntry> {
        private final Supplier<Set<ResourceLocation>> discoveredRelics;
        private final Consumer<ResourceLocation> onRelicSelected;

        public RelicSelectorModel(Supplier<Set<ResourceLocation>> discoveredRelics, Consumer<ResourceLocation> onRelicSelected) {
            this.discoveredRelics = discoveredRelics;
            this.onRelicSelected = onRelicSelected;
        }

        @Override
        public List<RelicEntry> getEntries() {
            Set<ResourceLocation> discoveredRelics = this.discoveredRelics.get();
            ArrayList<ResourceLocation> relicIds = new ArrayList<ResourceLocation>(ModDynamicModels.Relics.RELIC_REGISTRY.getIds());
            relicIds.sort((relic1, relic2) -> {
                boolean discovered2;
                boolean discovered1 = discoveredRelics.contains(relic1);
                if (discovered1 != (discovered2 = discoveredRelics.contains(relic2))) {
                    return discovered1 ? -1 : 1;
                }
                String name1 = ModDynamicModels.Relics.RELIC_REGISTRY.get((ResourceLocation)relic1).map(DynamicModel::getDisplayName).orElse("");
                String name2 = ModDynamicModels.Relics.RELIC_REGISTRY.get((ResourceLocation)relic2).map(DynamicModel::getDisplayName).orElse("");
                return name1.compareTo(name2);
            });
            return relicIds.stream().map(ModDynamicModels.Relics.RELIC_REGISTRY::get).filter(Optional::isPresent).map(Optional::get).map(relicModel -> new RelicEntry(this.makeModelItem(relicModel.getId()), discoveredRelics.contains(relicModel.getId()), (DynamicModel)relicModel)).toList();
        }

        private ItemStack makeModelItem(ResourceLocation relicId) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.RELIC);
            DynamicModelItem.setGenericModelId(stack, relicId);
            return stack;
        }

        @Override
        public void onSelect(FakeItemSlotElement<?> slot, RelicEntry entry) {
            super.onSelect(slot, entry);
            this.onRelicSelected.accept(entry.getModelId());
        }
    }

    public static class RelicEntry
    extends ScrollableItemStackSelectorElement.ItemSelectorEntry {
        private final boolean discovered;
        private final DynamicModel model;

        public RelicEntry(ItemStack displayStack, boolean discovered, DynamicModel model) {
            super(displayStack, false);
            this.discovered = discovered;
            this.model = model;
        }

        public ResourceLocation getModelId() {
            return this.model.getId();
        }

        @Override
        public void adjustSlot(FakeItemSlotElement<?> slot) {
            slot.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                LinkedList<Component> components = new LinkedList<Component>();
                components.add((Component)new TextComponent(this.model.getDisplayName()).m_130948_(Style.f_131099_.m_178520_(-2505149)));
                if (!this.discovered) {
                    components.add((Component)new TextComponent("Not Assembled Before"));
                }
                tooltipRenderer.renderTooltip(poseStack, components, mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.LEFT);
                return true;
            });
        }
    }
}

