/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.SelectableElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.screen.layout.ScreenLayout;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class ScrollableListSelectorElement<E extends ScrollableListSelectorElement<E, V, S>, V, S extends SelectableElement<S>>
extends VerticalScrollClipContainer<E> {
    protected final SelectorModel<S, V> selectorModel;
    private final SelectorContainer<?> elementContainer;

    public ScrollableListSelectorElement(ISpatial spatial, SelectorModel<S, V> selectorModel) {
        super(Spatials.copy(spatial).width(spatial.width() + 17));
        this.selectorModel = selectorModel;
        this.elementContainer = new SelectorContainer(spatial.width());
        this.addElement(this.elementContainer);
    }

    public void refreshElements() {
        this.elementContainer.removeAllElements();
        this.elementContainer.buildElements();
        ScreenLayout.requestLayout();
    }

    protected SelectorModel<S, V> getSelectorModel() {
        return this.selectorModel;
    }

    public static abstract class SelectorModel<S extends SelectableElement<S>, V> {
        private Consumer<S> onSelect = selected -> {};
        private S selectedElement = null;

        public abstract List<V> getEntries();

        public abstract S createSelectable(ISpatial var1, V var2);

        public void whenSelected(Consumer<S> onSelect) {
            this.onSelect = this.onSelect.andThen(onSelect);
        }

        public void select(S entry) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            this.selectedElement = entry;
            this.onSelect.accept(entry);
        }

        @Nullable
        public S getSelectedElement() {
            return this.selectedElement;
        }
    }

    private class SelectorContainer<T extends SelectorContainer<T>>
    extends ElasticContainerElement<T> {
        protected final List<S> selectables;

        private SelectorContainer(int width) {
            super(Spatials.positionXY(0, 0).width(width));
            this.selectables = new ArrayList();
            this.buildElements();
        }

        public void buildElements() {
            this.selectables.clear();
            ScrollableListSelectorElement.this.verticalScrollBarElement.setValue(0.0f);
            SelectorModel selectorModel = ScrollableListSelectorElement.this.getSelectorModel();
            int offsetY = 0;
            for (Object entry : selectorModel.getEntries()) {
                IMutableSpatial position = Spatials.positionXY(0, offsetY);
                Object selectable = selectorModel.createSelectable(position, entry);
                selectable.onSelect(selectorModel::select);
                selectable.onSelect(this::updateSelection);
                this.addElement(selectable);
                this.selectables.add(selectable);
                offsetY += selectable.height();
            }
        }

        private void updateSelection(S selected) {
            this.selectables.forEach(element -> element.setSelected(false));
            selected.setSelected(true);
        }
    }
}

