/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.gui.screen.block.VaultJewelApplicationStationScreen;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.RenderProperties;

public class ToolItemSlotElement<E extends ToolItemSlotElement<E>>
extends ElasticContainerElement<E> {
    protected Supplier<ItemStack> itemStack;
    protected Supplier<Boolean> disabled;
    protected boolean ignoreGlint;
    protected Runnable onClickHandler;
    protected Supplier<Component> labelSupplier = () -> null;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;

    public ToolItemSlotElement(ISpatial spatial, Supplier<ItemStack> itemStack, Supplier<Boolean> disabled, int width, int height) {
        super(Spatials.copy(spatial).size(width, height));
        this.itemStack = itemStack;
        this.disabled = disabled;
        this.scaleWidth = (float)width / 16.0f;
        this.scaleHeight = (float)height / 16.0f;
    }

    public ToolItemSlotElement<E> whenClicked(Runnable onClickHandler) {
        this.onClickHandler = onClickHandler;
        return this;
    }

    public ToolItemSlotElement<E> setLabel(Supplier<Component> countLabelSupplier) {
        this.labelSupplier = countLabelSupplier;
        return this;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int buttonIndex) {
        return super.m_6375_(mouseX, mouseY, buttonIndex);
    }

    public void setItemStack(Supplier<ItemStack> sup) {
        this.itemStack = sup;
    }

    public ToolItemSlotElement<E> setLabelStackCount() {
        this.labelSupplier = () -> {
            ItemStack stack = this.getDisplayStack();
            if (stack.m_41619_() || stack.m_41613_() <= 1) {
                return null;
            }
            return new TextComponent(String.valueOf(stack.m_41613_()));
        };
        return this;
    }

    public ToolItemSlotElement<E> ignoringGlint() {
        this.ignoreGlint = true;
        return this;
    }

    public void setDisabled(Supplier<Boolean> disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    public ItemStack getDisplayStack() {
        return this.itemStack.get();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
        if (!this.isDisabled() && this.onClickHandler != null) {
            Runnable runnable = this.onClickHandler;
            if (runnable instanceof VaultJewelApplicationStationScreen.MouseClickRunnable) {
                VaultJewelApplicationStationScreen.MouseClickRunnable mouseClickRunnable = (VaultJewelApplicationStationScreen.MouseClickRunnable)runnable;
                mouseClickRunnable.setType(buttonIndex);
            }
            this.onClickHandler.run();
        }
        return super.onMouseClicked(mouseX, mouseY, buttonIndex);
    }

    @Override
    public void render(IElementRenderer renderer, @Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.renderItemStack(this.getDisplayStack(), this.worldSpatial.x() + 1, this.worldSpatial.y() + 1, this.isDisabled());
    }

    private void renderItemStack(ItemStack itemStack, float x, float y, boolean disabled) {
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel bakedModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        PoseStack poseStack2 = new PoseStack();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)x, (double)y, 350.0);
        posestack.m_85837_((double)(8.0f * this.scaleWidth), (double)(8.0f * this.scaleHeight), (double)(8.0f * this.scaleWidth));
        posestack.m_85841_(16.0f * this.scaleWidth, -16.0f * this.scaleHeight, 16.0f * this.scaleWidth);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        if (disabled) {
            Lighting.m_84931_();
        } else {
            Lighting.m_84930_();
        }
        this.renderItemStack(itemStack, ItemTransforms.TransformType.GUI, false, poseStack2, (MultiBufferSource)bufferSource, LightmapHelper.getPackedFullbrightCoords(), OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    private void renderItemStack(ItemStack pItemStack, ItemTransforms.TransformType pTransformType, boolean pLeftHand, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay, BakedModel pModel) {
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        ItemModelShaper itemModelShaper = itemRenderer.m_115103_();
        if (!pItemStack.m_41619_()) {
            boolean flag;
            pMatrixStack.m_85836_();
            boolean bl = flag = pTransformType == ItemTransforms.TransformType.GUI || pTransformType == ItemTransforms.TransformType.GROUND || pTransformType == ItemTransforms.TransformType.FIXED;
            if (flag) {
                if (pItemStack.m_150930_(Items.f_42713_)) {
                    pModel = itemModelShaper.m_109393_().m_119422_(new ModelResourceLocation("minecraft:trident#inventory"));
                } else if (pItemStack.m_150930_(Items.f_151059_)) {
                    pModel = itemModelShaper.m_109393_().m_119422_(new ModelResourceLocation("minecraft:spyglass#inventory"));
                }
            }
            pModel = ForgeHooksClient.handleCameraTransforms((PoseStack)pMatrixStack, (BakedModel)pModel, (ItemTransforms.TransformType)pTransformType, (boolean)pLeftHand);
            pMatrixStack.m_85837_(-0.5, -0.5, -0.5);
            if (!(pModel.m_7521_() || pItemStack.m_150930_(Items.f_42713_) && !flag)) {
                Block block;
                boolean flag1 = pTransformType != ItemTransforms.TransformType.GUI && !pTransformType.m_111841_() && pItemStack.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)pItemStack.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                if (pModel.isLayered()) {
                    ForgeHooksClient.drawItemLayered((ItemRenderer)itemRenderer, (BakedModel)pModel, (ItemStack)pItemStack, (PoseStack)pMatrixStack, (MultiBufferSource)pBuffer, (int)pCombinedLight, (int)pCombinedOverlay, (boolean)flag1);
                } else {
                    VertexConsumer vertexconsumer;
                    RenderType rendertype = ItemBlockRenderTypes.m_109279_((ItemStack)pItemStack, (boolean)flag1);
                    if (pItemStack.m_150930_(Items.f_42522_) && pItemStack.m_41790_()) {
                        pMatrixStack.m_85836_();
                        PoseStack.Pose posestack$pose = pMatrixStack.m_85850_();
                        if (pTransformType == ItemTransforms.TransformType.GUI) {
                            posestack$pose.m_85861_().m_27630_(0.5f);
                        } else if (pTransformType.m_111841_()) {
                            posestack$pose.m_85861_().m_27630_(0.75f);
                        }
                        vertexconsumer = flag1 ? ToolItemSlotElement.getCompassFoilBufferDirect(pBuffer, rendertype, posestack$pose) : ToolItemSlotElement.getCompassFoilBuffer(pBuffer, rendertype, posestack$pose);
                        pMatrixStack.m_85849_();
                    } else {
                        vertexconsumer = flag1 ? ToolItemSlotElement.getFoilBufferDirect(pBuffer, rendertype, true, !this.ignoreGlint && pItemStack.m_41790_()) : ToolItemSlotElement.getFoilBuffer(pBuffer, rendertype, true, !this.ignoreGlint && pItemStack.m_41790_());
                    }
                    itemRenderer.m_115189_(pModel, pItemStack, pCombinedLight, pCombinedOverlay, pMatrixStack, vertexconsumer);
                }
            } else {
                RenderProperties.get((ItemStack)pItemStack).getItemStackRenderer().m_108829_(pItemStack, pTransformType, pMatrixStack, pBuffer, pCombinedLight, pCombinedOverlay);
            }
            pMatrixStack.m_85849_();
        }
    }

    public static VertexConsumer getCompassFoilBuffer(MultiBufferSource pBuffer, RenderType pRenderType, PoseStack.Pose pMatrixEntry) {
        return VertexMultiConsumer.m_86168_((VertexConsumer)new SheetedDecalTextureGenerator(pBuffer.m_6299_(RenderType.m_110490_()), pMatrixEntry.m_85861_(), pMatrixEntry.m_85864_()), (VertexConsumer)pBuffer.m_6299_(pRenderType));
    }

    public static VertexConsumer getCompassFoilBufferDirect(MultiBufferSource pBuffer, RenderType pRenderType, PoseStack.Pose pMatrixEntry) {
        return VertexMultiConsumer.m_86168_((VertexConsumer)new SheetedDecalTextureGenerator(pBuffer.m_6299_(RenderType.m_110493_()), pMatrixEntry.m_85861_(), pMatrixEntry.m_85864_()), (VertexConsumer)pBuffer.m_6299_(pRenderType));
    }

    public static VertexConsumer getFoilBuffer(MultiBufferSource pBuffer, RenderType pRenderType, boolean pIsItem, boolean pGlint) {
        if (pGlint) {
            return Minecraft.m_91085_() && pRenderType == Sheets.m_110791_() ? VertexMultiConsumer.m_86168_((VertexConsumer)pBuffer.m_6299_(RenderType.m_110487_()), (VertexConsumer)pBuffer.m_6299_(pRenderType)) : VertexMultiConsumer.m_86168_((VertexConsumer)pBuffer.m_6299_(pIsItem ? RenderType.m_110490_() : RenderType.m_110496_()), (VertexConsumer)pBuffer.m_6299_(pRenderType));
        }
        return pBuffer.m_6299_(pRenderType);
    }

    public static VertexConsumer getFoilBufferDirect(MultiBufferSource pBuffer, RenderType pRenderType, boolean pNoEntity, boolean pWithGlint) {
        return pWithGlint ? VertexMultiConsumer.m_86168_((VertexConsumer)pBuffer.m_6299_(pNoEntity ? RenderType.m_110493_() : RenderType.m_110499_()), (VertexConsumer)pBuffer.m_6299_(pRenderType)) : pBuffer.m_6299_(pRenderType);
    }
}

