/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.render.NineSlice;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class VerticalScrollbarElement<E extends VerticalScrollbarElement<E>>
extends ContainerElement<E>
implements IGuiEventElement {
    private static final double SCROLL_SENSITIVITY = 0.05;
    private final TextureAtlasElement<?> handle;
    private final TextureAtlasElement<?> handleDisabled;
    private final NineSliceElement<?> background;
    private final ObservableSupplier<Float> changeObserver;
    private final Consumer<Float> changeObserverAction;
    private final int topPadding;
    private final int bottomPadding;
    private final float handleOffset;
    private boolean dragging;
    private float value;

    public VerticalScrollbarElement(IPosition position, int height, Consumer<Float> changeObserverAction) {
        this(position, height, ScreenTextures.SCROLLBAR_HANDLE, ScreenTextures.SCROLLBAR_HANDLE_DISABLED, ScreenTextures.INSET_GREY_BACKGROUND, changeObserverAction);
    }

    public VerticalScrollbarElement(IPosition position, int height, TextureAtlasRegion handleTextureRegion, TextureAtlasRegion handleDisabledTextureRegion, NineSlice.TextureRegion backgroundTextureRegion, Consumer<Float> changeObserverAction) {
        super(Spatials.positionXYZ(position).width(VerticalScrollbarElement.calculateWidth(handleTextureRegion, backgroundTextureRegion)).height(height));
        this.handleOffset = (float)handleTextureRegion.height() / 2.0f;
        this.topPadding = backgroundTextureRegion.slices().top();
        this.bottomPadding = backgroundTextureRegion.slices().bottom();
        this.background = (NineSliceElement)new NineSliceElement(Spatials.width(VerticalScrollbarElement.calculateWidth(handleTextureRegion, backgroundTextureRegion)).height(height), backgroundTextureRegion).layout(this::layoutBackground);
        IElement[] iElementArray = new IElement[2];
        this.handle = new TextureAtlasElement(Spatials.positionX(1).positionZ(1), handleTextureRegion);
        iElementArray[0] = this.handle;
        this.handleDisabled = new TextureAtlasElement(Spatials.positionX(1).positionZ(1), handleDisabledTextureRegion);
        iElementArray[1] = this.handleDisabled;
        this.addElements(this.background, iElementArray);
        this.changeObserver = ObservableSupplier.of(() -> Float.valueOf(this.value), Mth::m_14033_);
        this.changeObserverAction = changeObserverAction;
        this.value = 0.0f;
        this.changeObserver.ifChanged(this.changeObserverAction);
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    private void layoutBackground(ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) {
        world.height(parent);
    }

    private static int calculateWidth(TextureAtlasRegion handleTextureRegion, NineSlice.TextureRegion backgroundTextureRegion) {
        int handleWidth = handleTextureRegion.width();
        int leftPadding = backgroundTextureRegion.slices().left();
        int rightPadding = backgroundTextureRegion.slices().right();
        return handleWidth + leftPadding + rightPadding;
    }

    private int calculateScrollableRangeMin() {
        return (int)Math.floor((float)this.topPadding + this.handleOffset);
    }

    private int calculateScrollableRangeMax() {
        return (int)Math.floor((float)(this.worldSpatial.height() - this.bottomPadding) - this.handleOffset);
    }

    private float calculateValue(float mouseY) {
        int scrollableRangeMin = this.worldSpatial.y() + this.calculateScrollableRangeMin();
        int scrollableRangeMax = this.worldSpatial.y() + this.calculateScrollableRangeMax();
        return Mth.m_14036_((float)((mouseY - (float)scrollableRangeMin) / (float)(scrollableRangeMax - scrollableRangeMin)), (float)0.0f, (float)1.0f);
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
        this.dragging = true;
        this.value = this.calculateValue((float)mouseY);
        this.changeObserver.ifChanged(this.changeObserverAction);
        return true;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int buttonIndex, double dragX, double dragY) {
        return this.dragging && this.isEnabled() && this.onMouseDragged(mouseX, mouseY, buttonIndex, dragX, dragY);
    }

    @Override
    public boolean onMouseDragged(double mouseX, double mouseY, int buttonIndex, double dragX, double dragY) {
        this.value = this.calculateValue((float)mouseY);
        this.changeObserver.ifChanged(this.changeObserverAction);
        return true;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int buttonIndex) {
        this.dragging = false;
        return super.m_6348_(mouseX, mouseY, buttonIndex);
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        this.value = (float)Mth.m_14008_((double)((double)this.value - delta * 0.05), (double)0.0, (double)1.0);
        this.changeObserver.ifChanged(this.changeObserverAction);
        return true;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.background.render(renderer, poseStack, mouseX, mouseY, partialTick);
        int scrollableRangeMin = this.calculateScrollableRangeMin();
        int scrollableRangeMax = this.calculateScrollableRangeMax();
        double y = (float)this.topPadding + (float)(scrollableRangeMax - scrollableRangeMin) * this.value;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, y, 0.0);
        if (this.isEnabled()) {
            this.handle.render(renderer, poseStack, mouseX, mouseY, partialTick);
        } else {
            this.handleDisabled.render(renderer, poseStack, mouseX, mouseY, partialTick);
        }
        poseStack.m_85849_();
    }
}

