/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ScrollableListSelectorElement;
import iskallia.vault.client.gui.framework.element.SelectableButtonElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextAlign;
import iskallia.vault.client.gui.framework.text.TextWrap;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.config.gear.VaultGearWorkbenchConfig;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.crafting.ModifierWorkbenchHelper;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class WorkbenchCraftSelectorElement<E extends WorkbenchCraftSelectorElement<E, V>, V extends WorkbenchListElement<V>>
extends ScrollableListSelectorElement<E, VaultGearWorkbenchConfig.CraftableModifierConfig, V> {
    private final ObservableSupplier<ItemStack> inputSupplier;

    public WorkbenchCraftSelectorElement(ISpatial spatial, ObservableSupplier<ItemStack> inputSupplier, Supplier<String> searchFilter) {
        super((ISpatial)Spatials.copy(spatial).width(ScreenTextures.BUTTON_WORKBENCH_MODIFIER_TEXTURES.button().width()), new WorkbenchCraftSelectorModel(inputSupplier, searchFilter));
        this.inputSupplier = inputSupplier;
    }

    public void onSelect(Consumer<ModifierWorkbenchHelper.CraftingOption> fn) {
        ScrollableListSelectorElement.SelectorModel selectorModel = this.getSelectorModel();
        if (selectorModel instanceof WorkbenchCraftSelectorModel) {
            WorkbenchCraftSelectorModel selModel = (WorkbenchCraftSelectorModel)selectorModel;
            selModel.whenSelected(cfg -> {
                ModifierWorkbenchHelper.CraftingOption option = selModel.getSelectedCraftingOption();
                if (option != null) {
                    fn.accept(option);
                }
            });
        }
    }

    @Override
    public void render(IElementRenderer renderer, @Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        this.inputSupplier.ifChanged(change -> this.refreshElements());
    }

    public static class WorkbenchCraftSelectorModel<E extends WorkbenchListElement<E>>
    extends ScrollableListSelectorElement.SelectorModel<E, VaultGearWorkbenchConfig.CraftableModifierConfig> {
        private final ObservableSupplier<ItemStack> inputSupplier;
        private final Supplier<String> searchFilter;

        public WorkbenchCraftSelectorModel(ObservableSupplier<ItemStack> inputSupplier, Supplier<String> searchFilter) {
            this.inputSupplier = inputSupplier;
            this.searchFilter = searchFilter;
        }

        @Override
        public List<VaultGearWorkbenchConfig.CraftableModifierConfig> getEntries() {
            ItemStack input = this.inputSupplier.get();
            if (input.m_41619_()) {
                return Collections.emptyList();
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return Collections.emptyList();
            }
            String searchTerm = this.searchFilter.get().toLowerCase(Locale.ROOT);
            ArrayList<VaultGearWorkbenchConfig.CraftableModifierConfig> out = new ArrayList<VaultGearWorkbenchConfig.CraftableModifierConfig>();
            String locRemove = new TranslatableComponent("the_vault.gear_workbench.remove_crafted_modifiers").getString();
            if (searchTerm.isEmpty() || locRemove.toLowerCase(Locale.ROOT).contains(searchTerm)) {
                out.add(null);
            }
            VaultGearWorkbenchConfig.getConfig(input.m_41720_()).map(VaultGearWorkbenchConfig::getAllCraftableModifiers).ifPresent(craftingConfigs -> craftingConfigs.forEach(cfg -> cfg.createModifier().flatMap(modifier -> modifier.getConfigDisplay(input)).ifPresent(display -> {
                String locDisplay = display.getString().toLowerCase(Locale.ROOT);
                if (searchTerm.isEmpty() || locDisplay.contains(searchTerm)) {
                    out.add((VaultGearWorkbenchConfig.CraftableModifierConfig)cfg);
                }
            })));
            int playerLevel = SidedHelper.getVaultLevel((Player)player);
            out.removeIf(cfg -> cfg != null && cfg.getUnlockCategory() == VaultGearWorkbenchConfig.UnlockCategory.VAULT_DISCOVERY && cfg.getMinLevel() > playerLevel);
            return out;
        }

        @Override
        public E createSelectable(ISpatial spatial, VaultGearWorkbenchConfig.CraftableModifierConfig entry) {
            if (entry == null) {
                return (E)new WorkbenchRemoveCraftElement(spatial, this.inputSupplier.get());
            }
            return (E)new WorkbenchCraftElement((IPosition)spatial, this.inputSupplier.get(), entry);
        }

        @Nullable
        protected ModifierWorkbenchHelper.CraftingOption getSelectedCraftingOption() {
            WorkbenchListElement element = (WorkbenchListElement)this.getSelectedElement();
            if (element == null) {
                return null;
            }
            if (element instanceof WorkbenchCraftElement) {
                WorkbenchCraftElement craftElement = (WorkbenchCraftElement)element;
                return new ModifierWorkbenchHelper.CraftingOption(craftElement.getModifier());
            }
            return new ModifierWorkbenchHelper.CraftingOption(null);
        }
    }

    public static class WorkbenchCraftElement<E extends WorkbenchCraftElement<E>>
    extends WorkbenchListElement<E> {
        private final ItemStack gearStack;
        private final VaultGearWorkbenchConfig.CraftableModifierConfig modifier;
        private final LabelTextStyle textStyle;
        private final VaultGearModifier<?> displayModifier;

        public WorkbenchCraftElement(IPosition position, ItemStack gearStack, VaultGearWorkbenchConfig.CraftableModifierConfig modifier) {
            super(position);
            this.gearStack = gearStack;
            this.modifier = modifier;
            this.textStyle = LabelTextStyle.defaultStyle().shadow().build();
            this.displayModifier = this.modifier.createModifier().orElse(null);
            this.tooltip((ITooltipRenderer tooltipRenderer, PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) -> {
                if (this.canCraft()) {
                    return false;
                }
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return false;
                }
                if (!this.modifier.hasPrerequisites((Player)player)) {
                    String displayStr = this.getModifier().getUnlockCategory().formatDisplay(this.modifier.getMinLevel());
                    tooltipRenderer.renderTooltip(poseStack, (Component)new TextComponent(displayStr).m_130940_(ChatFormatting.RED), mouseX, mouseY, TooltipDirection.RIGHT);
                    return true;
                }
                if (!this.gearStack.m_41619_()) {
                    int minLevel = this.modifier.getMinLevel();
                    if (VaultGearData.read(this.gearStack).getItemLevel() < minLevel) {
                        MutableComponent cmp = new TextComponent("Item Level required: " + minLevel).m_130940_(ChatFormatting.RED);
                        tooltipRenderer.renderTooltip(poseStack, (Component)cmp, mouseX, mouseY, TooltipDirection.RIGHT);
                        return true;
                    }
                    ItemStack gearCopy = this.gearStack.m_41777_();
                    ModifierWorkbenchHelper.removeCraftedModifiers(gearCopy);
                    VaultGearData data = VaultGearData.read(gearCopy);
                    Set<String> groups = data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS);
                    if (this.displayModifier != null && groups.contains(this.displayModifier.getModifierGroup())) {
                        MutableComponent cmp = new TextComponent("Item already has a modifier of this group.").m_130940_(ChatFormatting.RED);
                        tooltipRenderer.renderTooltip(poseStack, (Component)cmp, mouseX, mouseY, TooltipDirection.RIGHT);
                        return true;
                    }
                }
                String affix = this.modifier.getAffixGroup().getTargetAffixType().getSingular();
                MutableComponent cmp = new TextComponent("Item has no open " + affix).m_130940_(ChatFormatting.RED);
                tooltipRenderer.renderTooltip(poseStack, (Component)cmp, mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            });
        }

        public VaultGearWorkbenchConfig.CraftableModifierConfig getModifier() {
            return this.modifier;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            this.setDisabled(!this.canCraft());
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 1.0);
            if (this.displayModifier != null) {
                this.getCraftedModifierDescription().ifPresent(cfgDisplay -> this.textStyle.textBorder().render(renderer, poseStack, (Component)cfgDisplay, TextWrap.wrap(), TextAlign.LEFT, this.worldSpatial.x() + 4, this.worldSpatial.y() + 3, this.worldSpatial.z(), this.worldSpatial.width()));
            }
            poseStack.m_85849_();
        }

        @Override
        protected List<ItemStack> createNeededInputs() {
            return this.modifier.createCraftingCost(this.gearStack);
        }

        public Optional<MutableComponent> getCraftedModifierDescription() {
            return this.displayModifier.getConfigDisplay(this.gearStack);
        }

        private boolean hasAffixSpace() {
            ItemStack inputCopy = this.gearStack.m_41777_();
            ModifierWorkbenchHelper.removeCraftedModifiers(inputCopy);
            VaultGearModifier.AffixType affixType = this.modifier.getAffixGroup().getTargetAffixType();
            if (affixType == VaultGearModifier.AffixType.PREFIX) {
                return VaultGearModifierHelper.hasOpenPrefix(inputCopy);
            }
            return VaultGearModifierHelper.hasOpenSuffix(inputCopy);
        }

        private boolean hasGroupApplied() {
            if (!this.gearStack.m_41619_()) {
                ItemStack gearCopy = this.gearStack.m_41777_();
                ModifierWorkbenchHelper.removeCraftedModifiers(gearCopy);
                VaultGearData data = VaultGearData.read(gearCopy);
                Set<String> groups = data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS);
                return this.displayModifier != null && groups.contains(this.displayModifier.getModifierGroup());
            }
            return false;
        }

        private boolean canCraft() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            return player != null && !this.gearStack.m_41619_() && this.modifier.hasPrerequisites((Player)player) && VaultGearData.read(this.gearStack).getItemLevel() >= this.modifier.getMinLevel() && !this.hasGroupApplied() && this.hasAffixSpace();
        }
    }

    public static class WorkbenchRemoveCraftElement<E extends WorkbenchRemoveCraftElement<E>>
    extends WorkbenchListElement<E> {
        private final ItemStack gearStack;
        private final LabelTextStyle textStyle;

        public WorkbenchRemoveCraftElement(IPosition position, ItemStack gearStack) {
            super(position);
            this.gearStack = gearStack;
            this.textStyle = LabelTextStyle.defaultStyle().shadow().build();
            this.tooltip((ITooltipRenderer tooltipRenderer, PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) -> {
                if (this.canCraft()) {
                    return false;
                }
                if (this.gearStack.m_41619_()) {
                    return false;
                }
                MutableComponent cmp = new TranslatableComponent("the_vault.gear_workbench.remove_crafted_modifiers.no_modifier").m_130940_(ChatFormatting.RED);
                tooltipRenderer.renderTooltip(poseStack, (Component)cmp, mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            });
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            this.setDisabled(!this.canCraft());
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 1.0);
            this.textStyle.textBorder().render(renderer, poseStack, (Component)new TranslatableComponent("the_vault.gear_workbench.remove_crafted_modifiers"), TextWrap.wrap(), TextAlign.LEFT, this.worldSpatial.x() + 4, this.worldSpatial.y() + 3, this.worldSpatial.z(), this.worldSpatial.width());
            poseStack.m_85849_();
        }

        @Override
        protected List<ItemStack> createNeededInputs() {
            if (this.gearStack.m_41619_()) {
                return Collections.emptyList();
            }
            return VaultGearWorkbenchConfig.getConfig(this.gearStack.m_41720_()).map(VaultGearWorkbenchConfig::getCostRemoveCraftedModifiers).orElse(Collections.emptyList());
        }

        private boolean canCraft() {
            return !this.gearStack.m_41619_() && ModifierWorkbenchHelper.hasCraftedModifier(this.gearStack);
        }
    }

    public static abstract class WorkbenchListElement<E extends WorkbenchListElement<E>>
    extends SelectableButtonElement<E> {
        private List<ItemStack> inputs;

        public WorkbenchListElement(IPosition position) {
            super(position, ScreenTextures.BUTTON_WORKBENCH_MODIFIER_TEXTURES, () -> {});
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            ItemRenderer ir = Minecraft.m_91087_().m_91291_();
            Font font = Minecraft.m_91087_().f_91062_;
            int offsetX = this.worldSpatial.x() + this.worldSpatial.width() - 18;
            int offsetY = this.worldSpatial.y() + this.worldSpatial.height() - 18;
            List<ItemStack> inputs = this.getInputs();
            List<Object> missingInputs = new ArrayList();
            if (Minecraft.m_91087_().f_91074_ != null) {
                missingInputs = InventoryUtil.getMissingInputs(inputs, Minecraft.m_91087_().f_91074_.m_150109_());
            }
            for (ItemStack stack : inputs) {
                ir.m_115123_(stack, offsetX, offsetY);
                TextComponent text = new TextComponent(String.valueOf(stack.m_41613_()));
                if (missingInputs.contains(stack)) {
                    text.m_130940_(ChatFormatting.RED);
                }
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 200.0);
                MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                font.m_92841_((Component)text, (float)(offsetX + 17 - font.m_92852_((FormattedText)text)), (float)(offsetY + 9), 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffers, false, 0, LightmapHelper.getPackedFullbrightCoords());
                buffers.m_109911_();
                poseStack.m_85849_();
                offsetX -= 17;
            }
        }

        protected List<ItemStack> getInputs() {
            if (this.inputs == null) {
                this.inputs = this.createNeededInputs();
            }
            return this.inputs;
        }

        protected abstract List<ItemStack> createNeededInputs();
    }
}

