/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.atlas.IMultiBuffer;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.render.NineSlice;
import iskallia.vault.client.gui.framework.render.spi.IClipRegionStrategy;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class ElementRenderers {
    public static IElementRenderer immediate(final IClipRegionStrategy clipRegionStrategy) {
        return new IElementRenderer(){

            @Override
            public void render(Item item, PoseStack poseStack, IPosition position) {
                RenderSystem.m_69465_();
                Minecraft.m_91087_().m_91291_().m_115123_(new ItemStack((ItemLike)item), position.x(), position.y());
                RenderSystem.m_69482_();
            }

            @Override
            public void render(TextureAtlasRegion region, PoseStack poseStack, IPosition position) {
                region.blit(poseStack, position);
            }

            @Override
            public void render(TextureAtlasRegion region, PoseStack poseStack, IPosition position, ISize size) {
                region.blit(poseStack, position, size);
            }

            @Override
            public void render(TextureAtlasRegion region, PoseStack poseStack, int x, int y, int z) {
                region.blit(poseStack, x, y, z);
            }

            @Override
            public void render(TextureAtlasRegion region, PoseStack poseStack, int x, int y, int z, int width, int height) {
                region.blit(poseStack, x, y, z, width, height);
            }

            @Override
            public void render(TextureAtlasRegion region, PoseStack poseStack, int x, int y, int z, int width, int height, float u0, float u1, float v0, float v1) {
                region.blit(poseStack, x, y, z, width, height, u0, u1, v0, v1);
            }

            @Override
            public void render(NineSlice.TextureRegion region, PoseStack poseStack, ISpatial spatial) {
                region.blit(poseStack, spatial.x(), spatial.y(), spatial.z(), spatial.width(), spatial.height());
            }

            @Override
            public void render(NineSlice.TextureRegion region, PoseStack poseStack, int x, int y, int z, int width, int height) {
                region.blit(poseStack, x, y, z, width, height);
            }

            @Override
            public void renderColoredQuad(PoseStack poseStack, int color, int x, int y, int z, int width, int height) {
                ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, poseStack).at(x, y).zLevel(z).dim(width, height).color(color).drawColored());
            }

            @Override
            public void renderColoredHollowRect(PoseStack poseStack, int color, int x, int y, int z, int width, int height, int thickness) {
                ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, poseStack).at(x, y).zLevel(z).dim(width, thickness).color(color).drawColored());
                ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, poseStack).at(x + width - 1, y).zLevel(z).dim(thickness, height).color(color).drawColored());
                ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, poseStack).at(x, y + height - 1).zLevel(z).dim(width, thickness).color(color).drawColored());
                ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, poseStack).at(x, y).zLevel(z).dim(thickness, height - 1).color(color).drawColored());
            }

            @Override
            public void renderPlain(FormattedCharSequence text, Font font, PoseStack poseStack, int x, int y, int z, int color) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)x, (double)y, (double)z);
                font.m_92877_(poseStack, text, 0.0f, 0.0f, color);
                poseStack.m_85849_();
                RenderSystem.m_69482_();
            }

            @Override
            public void renderShadow(FormattedCharSequence text, FormattedCharSequence shadow, Font font, PoseStack poseStack, int x, int y, int z, int color, int shadowColor) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)x, (double)y, (double)z);
                Matrix4f matrix = poseStack.m_85850_().m_85861_();
                poseStack.m_85836_();
                poseStack.m_85837_(1.0, 1.0, -0.1);
                Matrix4f shadowMatrix = poseStack.m_85850_().m_85861_();
                MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                font.m_92733_(text, 0.0f, 0.0f, color, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                font.m_92733_(shadow, 0.0f, 0.0f, shadowColor, false, shadowMatrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                bufferSource.m_109911_();
                poseStack.m_85849_();
                poseStack.m_85849_();
                RenderSystem.m_69482_();
            }

            @Override
            public void renderBorder4(FormattedCharSequence text, FormattedCharSequence border, Font font, PoseStack poseStack, int x, int y, int z, int color, int borderColor) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, (double)z);
                Matrix4f matrix = poseStack.m_85850_().m_85861_();
                MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                font.m_92733_(border, (float)(x - 1), (float)y, borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                font.m_92733_(border, (float)(x + 1), (float)y, borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                font.m_92733_(border, (float)x, (float)(y - 1), borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                font.m_92733_(border, (float)x, (float)(y + 1), borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                bufferSource.m_109911_();
                font.m_92877_(poseStack, text, (float)x, (float)y, color);
                poseStack.m_85849_();
                RenderSystem.m_69482_();
            }

            @Override
            public void renderBorder8(FormattedCharSequence text, FormattedCharSequence border, Font font, PoseStack poseStack, int x, int y, int z, int color, int borderColor) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, (double)z);
                Matrix4f matrix = poseStack.m_85850_().m_85861_();
                MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                font.m_92733_(border, (float)(x - 1), (float)y, borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                font.m_92733_(border, (float)(x + 1), (float)y, borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                font.m_92733_(border, (float)x, (float)(y - 1), borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                font.m_92733_(border, (float)x, (float)(y + 1), borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                font.m_92733_(border, (float)(x - 1), (float)(y - 1), borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                font.m_92733_(border, (float)(x + 1), (float)(y + 1), borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                font.m_92733_(border, (float)(x + 1), (float)(y - 1), borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                font.m_92733_(border, (float)(x - 1), (float)(y + 1), borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
                bufferSource.m_109911_();
                font.m_92877_(poseStack, text, (float)x, (float)y, color);
                poseStack.m_85849_();
                RenderSystem.m_69482_();
            }

            @Override
            public void beginFrame() {
                clipRegionStrategy.beginFrame();
            }

            @Override
            public void endFrame() {
                clipRegionStrategy.endFrame();
            }

            @Override
            public void beginClipRegion(ISpatial spatial) {
                clipRegionStrategy.beginClipRegion(spatial);
            }

            @Override
            public void endClipRegion() {
                clipRegionStrategy.endClipRegion();
            }
        };
    }

    @Nonnull
    public static IElementRenderer bufferedPosTex(final IMultiBuffer buffer, final IClipRegionStrategy clipRegionStrategy) {
        return new IElementRenderer(){
            private final MultiBufferSource.BufferSource fontBuffer = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(256));

            @Override
            public void render(Item item, PoseStack poseStack, IPosition position) {
                RenderSystem.m_69465_();
                Minecraft.m_91087_().m_91291_().m_115123_(new ItemStack((ItemLike)item), position.x(), position.y());
                RenderSystem.m_69482_();
            }

            @Override
            public void render(TextureAtlasRegion region, PoseStack poseStack, IPosition position) {
                region.buffer(buffer, poseStack, position);
            }

            @Override
            public void render(TextureAtlasRegion region, PoseStack poseStack, IPosition position, ISize size) {
                region.buffer(buffer, poseStack, position, size);
            }

            @Override
            public void render(TextureAtlasRegion region, PoseStack poseStack, int x, int y, int z) {
                region.buffer(buffer, poseStack, x, y, z);
            }

            @Override
            public void render(TextureAtlasRegion region, PoseStack poseStack, int x, int y, int z, int width, int height) {
                region.buffer(buffer, poseStack, x, y, z, width, height);
            }

            @Override
            public void render(NineSlice.TextureRegion region, PoseStack poseStack, ISpatial spatial) {
                region.buffer(buffer, poseStack, spatial);
            }

            @Override
            public void render(NineSlice.TextureRegion region, PoseStack poseStack, int x, int y, int z, int width, int height) {
                region.buffer(buffer, poseStack, x, y, z, width, height);
            }

            @Override
            public void render(TextureAtlasRegion region, PoseStack poseStack, int x, int y, int z, int width, int height, float u0, float u1, float v0, float v1) {
                region.buffer(buffer, poseStack, x, y, z, width, height, u0, u1, v0, v1);
            }

            @Override
            public void renderColoredQuad(PoseStack poseStack, int color, int x, int y, int z, int width, int height) {
                throw new UnsupportedOperationException("Colored quads are not supported by buffered drawing (yet).");
            }

            @Override
            public void renderColoredHollowRect(PoseStack poseStack, int color, int x, int y, int z, int width, int height, int thickness) {
                throw new UnsupportedOperationException("Colored hollow rectangles are not supported by buffered drawing (yet).");
            }

            @Override
            public void renderPlain(FormattedCharSequence text, Font font, PoseStack poseStack, int x, int y, int z, int color) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)x, (double)y, (double)z);
                font.m_92733_(text, 0.0f, 0.0f, color, false, poseStack.m_85850_().m_85861_(), (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                poseStack.m_85849_();
                RenderSystem.m_69482_();
            }

            @Override
            public void renderShadow(FormattedCharSequence text, FormattedCharSequence shadow, Font font, PoseStack poseStack, int x, int y, int z, int color, int shadowColor) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)x, (double)y, (double)z);
                Matrix4f matrix = poseStack.m_85850_().m_85861_();
                poseStack.m_85836_();
                poseStack.m_85837_(1.0, 1.0, -0.1);
                Matrix4f shadowMatrix = poseStack.m_85850_().m_85861_();
                font.m_92733_(text, 0.0f, 0.0f, color, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                font.m_92733_(shadow, 0.0f, 0.0f, shadowColor, false, shadowMatrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                poseStack.m_85849_();
                poseStack.m_85849_();
                RenderSystem.m_69482_();
            }

            @Override
            public void renderBorder4(FormattedCharSequence text, FormattedCharSequence border, Font font, PoseStack poseStack, int x, int y, int z, int color, int borderColor) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, (double)z);
                Matrix4f matrix = poseStack.m_85850_().m_85861_();
                font.m_92733_(border, (float)(x - 1), (float)y, borderColor, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                font.m_92733_(border, (float)(x + 1), (float)y, borderColor, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                font.m_92733_(border, (float)x, (float)(y - 1), borderColor, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                font.m_92733_(border, (float)x, (float)(y + 1), borderColor, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 0.1);
                font.m_92733_(text, (float)x, (float)y, color, false, poseStack.m_85850_().m_85861_(), (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                poseStack.m_85849_();
                poseStack.m_85849_();
                RenderSystem.m_69482_();
            }

            @Override
            public void renderBorder8(FormattedCharSequence text, FormattedCharSequence border, Font font, PoseStack poseStack, int x, int y, int z, int color, int borderColor) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, (double)z);
                Matrix4f matrix = poseStack.m_85850_().m_85861_();
                font.m_92733_(border, (float)(x - 1), (float)y, borderColor, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                font.m_92733_(border, (float)(x + 1), (float)y, borderColor, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                font.m_92733_(border, (float)x, (float)(y - 1), borderColor, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                font.m_92733_(border, (float)x, (float)(y + 1), borderColor, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                font.m_92733_(border, (float)(x - 1), (float)(y - 1), borderColor, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                font.m_92733_(border, (float)(x + 1), (float)(y + 1), borderColor, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                font.m_92733_(border, (float)(x + 1), (float)(y - 1), borderColor, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                font.m_92733_(border, (float)(x - 1), (float)(y + 1), borderColor, false, matrix, (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 0.1);
                font.m_92733_(text, (float)x, (float)y, color, false, poseStack.m_85850_().m_85861_(), (MultiBufferSource)this.fontBuffer, false, 0, 0xF000F0);
                poseStack.m_85849_();
                poseStack.m_85849_();
                RenderSystem.m_69482_();
            }

            @Override
            public void beginFrame() {
                clipRegionStrategy.beginFrame();
            }

            @Override
            public void endFrame() {
                clipRegionStrategy.endFrame();
            }

            @Override
            public void begin() {
                buffer.begin();
            }

            @Override
            public void end() {
                buffer.end(buffer -> GameRenderer::m_172817_);
                this.fontBuffer.m_109911_();
                RenderSystem.m_69482_();
            }

            @Override
            public void beginClipRegion(ISpatial spatial) {
                this.end();
                clipRegionStrategy.beginClipRegion(spatial);
                this.begin();
            }

            @Override
            public void endClipRegion() {
                this.end();
                clipRegionStrategy.endClipRegion();
                this.begin();
            }
        };
    }

    private ElementRenderers() {
    }
}

