/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.spatial;

import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.util.Objects;

public class Spatial
implements IMutableSpatial {
    private int x;
    private int y;
    private int z;
    private int width;
    private int height;

    public Spatial() {
        this.positionXYZ(0, 0, 0).size(0, 0);
    }

    public Spatial(int x, int y, int z, int width, int height) {
        this.positionXYZ(x, y, z).size(width, height);
    }

    public Spatial(ISpatial elementSpatial) {
        this(elementSpatial, elementSpatial);
    }

    public Spatial(IPosition position) {
        this.positionXYZ(position);
    }

    public Spatial(ISize size) {
        this.size(size);
    }

    public Spatial(IPosition position, ISize size) {
        this.positionXYZ(position).size(size);
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int z() {
        return this.z;
    }

    @Override
    public Spatial positionX(int x) {
        this.x = x;
        return this;
    }

    @Override
    public Spatial positionX(IPosition position) {
        return this.positionX(position.x());
    }

    @Override
    public Spatial positionY(int y) {
        this.y = y;
        return this;
    }

    @Override
    public Spatial positionY(IPosition position) {
        return this.positionY(position.y());
    }

    @Override
    public Spatial positionZ(int z) {
        this.z = z;
        return this;
    }

    @Override
    public Spatial positionZ(IPosition position) {
        return this.positionZ(position.z());
    }

    @Override
    public Spatial positionXY(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    @Override
    public Spatial positionXY(IPosition position) {
        return this.positionXY(position.x(), position.y());
    }

    @Override
    public Spatial positionXYZ(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @Override
    public Spatial positionXYZ(IPosition position) {
        return this.positionXYZ(position.x(), position.y(), position.z());
    }

    @Override
    public Spatial translateX(int x) {
        return this.translateXYZ(x, 0, 0);
    }

    @Override
    public Spatial translateX(IPosition position) {
        return this.translateX(position.x());
    }

    @Override
    public Spatial translateY(int y) {
        return this.translateXYZ(0, y, 0);
    }

    @Override
    public Spatial translateY(IPosition position) {
        return this.translateY(position.y());
    }

    @Override
    public Spatial translateZ(int z) {
        return this.translateXYZ(0, 0, z);
    }

    @Override
    public Spatial translateZ(IPosition position) {
        return this.translateZ(position.z());
    }

    @Override
    public Spatial translateXY(int x, int y) {
        return this.translateXYZ(x, y, 0);
    }

    @Override
    public Spatial translateXY(IPosition position) {
        return this.translateXY(position.x(), position.y());
    }

    @Override
    public Spatial translateXYZ(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    @Override
    public Spatial translateXYZ(IPosition elementPosition) {
        return this.translateXYZ(elementPosition.x(), elementPosition.y(), elementPosition.z());
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public Spatial width(int width) {
        this.width = width;
        return this;
    }

    @Override
    public Spatial width(ISize size) {
        return this.width(size.width());
    }

    @Override
    public Spatial height(int height) {
        this.height = height;
        return this;
    }

    @Override
    public Spatial height(ISize size) {
        return this.height(size.height());
    }

    @Override
    public Spatial size(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public Spatial size(ISize size) {
        return this.size(size.width(), size.height());
    }

    @Override
    public int right() {
        return this.x + this.width;
    }

    @Override
    public int left() {
        return this.x;
    }

    @Override
    public int top() {
        return this.y;
    }

    @Override
    public int bottom() {
        return this.y + this.height;
    }

    @Override
    public boolean contains(double x, double y) {
        return x <= (double)this.right() && x >= (double)this.left() && y >= (double)this.top() && y <= (double)this.bottom();
    }

    @Override
    public Spatial copy() {
        return new Spatial(this);
    }

    @Override
    public Spatial zero() {
        return this.set(ISpatial.ZERO);
    }

    @Override
    public Spatial set(ISpatial spatial) {
        return this.positionXYZ(spatial).size(spatial);
    }

    @Override
    public Spatial add(ISpatial spatial) {
        this.x += spatial.x();
        this.y += spatial.y();
        this.z += spatial.z();
        this.width += spatial.width();
        this.height += spatial.height();
        return this;
    }

    @Override
    public Spatial include(ISpatial spatial) {
        this.width += Math.max(0, spatial.right() - this.right());
        this.height += Math.max(0, spatial.bottom() - this.bottom());
        int dX = Math.min(0, spatial.left() - this.left());
        this.x += dX;
        this.width -= dX;
        int dY = Math.min(0, spatial.top() - this.top());
        this.y += dY;
        this.height -= dY;
        return this;
    }

    public String toString() {
        return "{(" + this.x + ", " + this.y + ", " + this.z + "), width=" + this.width + ", height=" + this.height + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spatial that = (Spatial)o;
        return this.x == that.x && this.y == that.y && this.z == that.z && this.width == that.width && this.height == that.height;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.width, this.height);
    }
}

