/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.text;

import iskallia.vault.client.gui.framework.text.TextAlign;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.framework.text.TextWrap;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;

public record LabelTextStyle(TextBorder.ITextBorder textBorder, TextWrap.ITextWrap textWrap, TextAlign.ITextAlign textAlign) {
    public static Builder defaultStyle() {
        return new Builder();
    }

    public static Builder shadow() {
        return new Builder().border(TextBorder.shadow());
    }

    public static Builder shadow(ChatFormatting color) {
        return new Builder().border((TextBorder.ITextBorder)TextBorder.shadow().color(TextColor.m_131270_((ChatFormatting)color)));
    }

    public static Builder shadow(TextColor color) {
        return new Builder().border((TextBorder.ITextBorder)TextBorder.shadow().color(color));
    }

    public static Builder border4() {
        return new Builder().border(TextBorder.border4());
    }

    public static Builder border4(ChatFormatting color) {
        return new Builder().border((TextBorder.ITextBorder)TextBorder.border4().color(TextColor.m_131270_((ChatFormatting)color)));
    }

    public static Builder border4(TextColor color) {
        return new Builder().border((TextBorder.ITextBorder)TextBorder.border4().color(color));
    }

    public static Builder border8() {
        return new Builder().border(TextBorder.border8());
    }

    public static Builder border8(ChatFormatting color) {
        return new Builder().border((TextBorder.ITextBorder)TextBorder.border8().color(TextColor.m_131270_((ChatFormatting)color)));
    }

    public static Builder border8(TextColor color) {
        return new Builder().border((TextBorder.ITextBorder)TextBorder.border8().color(color));
    }

    public static Builder border(TextBorder.ITextBorder textBorder) {
        return new Builder().border(textBorder);
    }

    public static Builder wrap() {
        return new Builder().wrap(TextWrap.wrap());
    }

    public static Builder wrap(TextWrap.ITextWrap textWrap) {
        return new Builder().wrap(textWrap);
    }

    public static Builder left() {
        return new Builder().left();
    }

    public static Builder center() {
        return new Builder().center();
    }

    public static Builder right() {
        return new Builder().right();
    }

    public static Builder align(TextAlign.ITextAlign textAlign) {
        return new Builder().align(textAlign);
    }

    public int calculateLines(Component component, int width) {
        return this.textWrap.process(component, width).size();
    }

    public int getLabelHeight(Component component, int width) {
        int n = this.calculateLines(component, width);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return n * 9;
    }

    public static class Builder {
        private TextBorder.ITextBorder border = TextBorder.none();
        private TextWrap.ITextWrap wrap = TextWrap.overflow();
        private TextAlign.ITextAlign align = TextAlign.LEFT;

        public Builder shadow() {
            return this.border(TextBorder.shadow());
        }

        public Builder shadow(TextColor color) {
            return this.border((TextBorder.ITextBorder)TextBorder.shadow().color(color));
        }

        public Builder shadow(ChatFormatting color) {
            return this.border((TextBorder.ITextBorder)TextBorder.shadow().color(TextColor.m_131270_((ChatFormatting)color)));
        }

        public Builder border4() {
            return this.border(TextBorder.border4());
        }

        public Builder border4(TextColor color) {
            return this.border((TextBorder.ITextBorder)TextBorder.border4().color(color));
        }

        public Builder border4(ChatFormatting color) {
            return this.border((TextBorder.ITextBorder)TextBorder.border4().color(TextColor.m_131270_((ChatFormatting)color)));
        }

        public Builder border8() {
            return this.border(TextBorder.border8());
        }

        public Builder border8(TextColor color) {
            return this.border((TextBorder.ITextBorder)TextBorder.border8().color(color));
        }

        public Builder border8(ChatFormatting color) {
            return this.border((TextBorder.ITextBorder)TextBorder.border8().color(TextColor.m_131270_((ChatFormatting)color)));
        }

        public Builder border(TextBorder.ITextBorder border) {
            this.border = border;
            return this;
        }

        public Builder wrap() {
            return this.wrap(TextWrap.wrap());
        }

        public Builder wrap(TextWrap.ITextWrap wrap) {
            this.wrap = wrap;
            return this;
        }

        public Builder left() {
            return this.align(TextAlign.LEFT);
        }

        public Builder center() {
            return this.align(TextAlign.CENTER);
        }

        public Builder right() {
            return this.align(TextAlign.RIGHT);
        }

        public Builder align(TextAlign.ITextAlign align) {
            this.align = align;
            return this;
        }

        public LabelTextStyle build() {
            return new LabelTextStyle(this.border, this.wrap, this.align);
        }
    }
}

