/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.text;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.text.TextAlign;
import iskallia.vault.client.gui.framework.text.TextWrap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public final class TextBorder {
    public static final TextColor DEFAULT_COLOR = TextColor.m_131268_((String)"#FFFFFF");
    public static final TextColor DEFAULT_SHADOW_COLOR = TextColor.m_131268_((String)"#000000");
    public static final TextColor DEFAULT_BORDER_COLOR = TextColor.m_131268_((String)"#000000");
    public static final Supplier<Font> DEFAULT_FONT = () -> Minecraft.m_91087_().f_91062_;
    private static final None NONE = new None();

    public static None none() {
        return NONE;
    }

    public static Shadow shadow() {
        return new Shadow(DEFAULT_SHADOW_COLOR);
    }

    public static Border4 border4() {
        return new Border4(DEFAULT_BORDER_COLOR);
    }

    public static Border8 border8() {
        return new Border8(DEFAULT_BORDER_COLOR);
    }

    private TextBorder() {
    }

    public static class None
    implements ITextBorder {
        protected None() {
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, Component component, TextWrap.ITextWrap textWrap, TextAlign.ITextAlign textAlign, int x, int y, int z, int width) {
            Font font = DEFAULT_FONT.get();
            List<FormattedCharSequence> formattedCharSequenceList = textWrap.process(component, width);
            for (int i = 0; i < formattedCharSequenceList.size(); ++i) {
                FormattedCharSequence formattedCharSequence = formattedCharSequenceList.get(i);
                int n = textAlign.calculateX(x, font.m_92724_(formattedCharSequence), width);
                Objects.requireNonNull(font);
                renderer.renderPlain(formattedCharSequence, font, poseStack, n, y + 9 * i, z, DEFAULT_COLOR.m_131265_());
            }
        }
    }

    public static class Shadow
    extends AbstractBorder<Shadow> {
        protected Shadow(TextColor shadowColor) {
            super(shadowColor);
        }

        @Override
        protected void render(IElementRenderer renderer, FormattedCharSequence text, FormattedCharSequence border, Font font, PoseStack poseStack, int x, int y, int z, int color, int borderColor) {
            renderer.renderShadow(text, border, font, poseStack, x, y, z, color, borderColor);
        }
    }

    public static class Border4
    extends AbstractBorder<Border4> {
        protected Border4(TextColor borderColor) {
            super(borderColor);
        }

        @Override
        protected void render(IElementRenderer renderer, FormattedCharSequence text, FormattedCharSequence border, Font font, PoseStack poseStack, int x, int y, int z, int color, int borderColor) {
            renderer.renderBorder4(text, border, font, poseStack, x, y, z, color, borderColor);
        }
    }

    public static class Border8
    extends AbstractBorder<Border8> {
        protected Border8(TextColor borderColor) {
            super(borderColor);
        }

        @Override
        protected void render(IElementRenderer renderer, FormattedCharSequence text, FormattedCharSequence border, Font font, PoseStack poseStack, int x, int y, int z, int color, int borderColor) {
            renderer.renderBorder8(text, border, font, poseStack, x, y, z, color, borderColor);
        }
    }

    public static abstract class AbstractBorder<T extends AbstractBorder<?>>
    implements ITextBorder {
        protected TextColor borderColor;
        protected Component component;
        protected Component borderComponent;

        public AbstractBorder(TextColor borderColor) {
            this.borderColor = borderColor;
        }

        public TextColor color() {
            return this.borderColor;
        }

        public T color(TextColor color) {
            this.borderColor = color;
            return (T)this;
        }

        protected Component deepCopy(Component component) {
            MutableComponent copy = component.m_6879_();
            copy.m_130948_(component.m_7383_());
            for (Component sibling : component.m_7360_()) {
                copy.m_7220_(this.deepCopy(sibling));
            }
            return copy;
        }

        protected Component setComponentColor(Component component, TextColor color) {
            if (component instanceof MutableComponent) {
                MutableComponent mutableComponent = (MutableComponent)component;
                mutableComponent.m_130948_(mutableComponent.m_7383_().m_131148_(color));
            }
            for (Component sibling : component.m_7360_()) {
                if (!(sibling instanceof MutableComponent)) continue;
                MutableComponent mutableComponent = (MutableComponent)sibling;
                this.setComponentColor((Component)mutableComponent, color);
            }
            return component;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, Component component, TextWrap.ITextWrap textWrap, TextAlign.ITextAlign textAlign, int x, int y, int z, int width) {
            if (!component.equals(this.component)) {
                this.component = component;
                this.borderComponent = this.setComponentColor(this.deepCopy(component), this.borderColor);
            }
            List<FormattedCharSequence> formattedCharSequenceList = textWrap.process(this.component, width);
            List<FormattedCharSequence> formattedCharSequenceBorderList = textWrap.process(this.borderComponent, width);
            if (formattedCharSequenceList.size() == formattedCharSequenceBorderList.size()) {
                for (int i = 0; i < formattedCharSequenceList.size(); ++i) {
                    FormattedCharSequence formattedCharSequence = formattedCharSequenceList.get(i);
                    FormattedCharSequence formattedCharSequenceBorder = formattedCharSequenceBorderList.get(i);
                    Font font = DEFAULT_FONT.get();
                    int n = textAlign.calculateX(x, font.m_92724_(formattedCharSequence), width) + 1;
                    Objects.requireNonNull(font);
                    this.render(renderer, formattedCharSequence, formattedCharSequenceBorder, font, poseStack, n, y + 9 * i, z, DEFAULT_COLOR.m_131265_(), this.borderColor.m_131265_());
                }
            }
        }

        protected abstract void render(IElementRenderer var1, FormattedCharSequence var2, FormattedCharSequence var3, Font var4, PoseStack var5, int var6, int var7, int var8, int var9, int var10);
    }

    @FunctionalInterface
    public static interface ITextBorder {
        public void render(IElementRenderer var1, @NotNull PoseStack var2, Component var3, TextWrap.ITextWrap var4, TextAlign.ITextAlign var5, int var6, int var7, int var8, int var9);
    }
}

