/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.helper;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;

public class ArenaScoreboardContainer {
    public List<ScoreboardEntry> scoreboard = new LinkedList<ScoreboardEntry>();

    public String getMVP() {
        if (this.scoreboard.size() == 0) {
            return null;
        }
        return this.scoreboard.get((int)0).nickname;
    }

    public List<ScoreboardEntry> getTop(int n) {
        if (this.scoreboard.size() == 0) {
            return new LinkedList<ScoreboardEntry>();
        }
        return this.scoreboard.subList(0, Math.min(n, this.scoreboard.size()));
    }

    public int getSize() {
        return this.scoreboard.size();
    }

    public void onDamageDealt(String nickname, float damageDealt) {
        int index = IntStream.range(0, this.scoreboard.size()).filter(i -> this.scoreboard.get((int)i).nickname.equals(nickname)).findFirst().orElse(-1);
        if (index == -1) {
            this.scoreboard.add(new ScoreboardEntry(nickname, damageDealt));
        } else {
            ScoreboardEntry entry = this.scoreboard.get(index);
            entry.totalDamage += damageDealt;
        }
        this.scoreboard.sort(Comparator.comparingDouble(o -> -o.totalDamage));
    }

    public void reset() {
        this.scoreboard.clear();
    }

    public static class ScoreboardEntry {
        public final String nickname;
        public float totalDamage;

        public ScoreboardEntry(String nickname, float totalDamage) {
            this.nickname = nickname;
            this.totalDamage = totalDamage;
        }

        public String toString() {
            return String.format("%s=%f", this.nickname, Float.valueOf(this.totalDamage));
        }
    }
}

