/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.helper;

import java.util.function.Function;

public enum Easing {
    CONSTANT_ONE(x -> Float.valueOf(1.0f)),
    LINEAR_IN(x -> x),
    LINEAR_OUT(x -> Float.valueOf(1.0f - x.floatValue())),
    EASE_IN_OUT_SINE(x -> Float.valueOf(-((float)Math.cos(Math.PI * (double)x.floatValue()) - 1.0f) / 2.0f)),
    EXPO_OUT(x -> Float.valueOf(x.floatValue() == 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0f * x.floatValue()))),
    EASE_OUT_BOUNCE(x -> {
        float n1 = 7.5625f;
        float d1 = 2.75f;
        if (x.floatValue() < 1.0f / d1) {
            return Float.valueOf(n1 * x.floatValue() * x.floatValue());
        }
        if (x.floatValue() < 2.0f / d1) {
            x = Float.valueOf(x.floatValue() - 1.5f / d1);
            return Float.valueOf(n1 * x.floatValue() * x.floatValue() + 0.75f);
        }
        if ((double)x.floatValue() < 2.5 / (double)d1) {
            x = Float.valueOf(x.floatValue() - 2.25f / d1);
            return Float.valueOf(n1 * x.floatValue() * x.floatValue() + 0.9375f);
        }
        x = Float.valueOf(x.floatValue() - 2.625f / d1);
        return Float.valueOf(n1 * x.floatValue() * x.floatValue() + 0.984375f);
    });

    final Function<Float, Float> function;

    private Easing(Function<Float, Float> function) {
        this.function = function;
    }

    public Function<Float, Float> getFunction() {
        return this.function;
    }

    public float calc(float time) {
        return this.function.apply(Float.valueOf(time)).floatValue();
    }
}

