/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.helper;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModEntities;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class MobHeadTextures {
    private static final Map<String, ResourceLocation> REGISTRY = new HashMap<String, ResourceLocation>();

    private static void register(EntityType<?> entityType) {
        ResourceLocation registryName = entityType.getRegistryName();
        if (registryName == null) {
            throw new InternalError();
        }
        MobHeadTextures.register(registryName);
    }

    private static void register(ResourceLocation id) {
        String namespace = id.m_135827_();
        String path = id.m_135815_();
        REGISTRY.put(id.toString(), VaultMod.id("textures/gui/mob_heads/" + namespace + "/" + path + ".png"));
    }

    public static Optional<ResourceLocation> get(@Nullable ResourceLocation mobId) {
        if (mobId == null) {
            return Optional.empty();
        }
        return MobHeadTextures.get(mobId.toString());
    }

    public static Optional<ResourceLocation> get(String mobId) {
        return Optional.ofNullable(REGISTRY.get(mobId));
    }

    static {
        MobHeadTextures.register(EntityType.f_20554_);
        MobHeadTextures.register(EntityType.f_20558_);
        MobHeadTextures.register(EntityType.f_20562_);
        MobHeadTextures.register(EntityType.f_20458_);
        MobHeadTextures.register(EntityType.f_20511_);
        MobHeadTextures.register(EntityType.f_20518_);
        MobHeadTextures.register(EntityType.f_20523_);
        MobHeadTextures.register(EntityType.f_20524_);
        MobHeadTextures.register(EntityType.f_20479_);
        MobHeadTextures.register(EntityType.f_20481_);
        MobHeadTextures.register(EntityType.f_20491_);
        MobHeadTextures.register(EntityType.f_20493_);
        MobHeadTextures.register(EntityType.f_20495_);
        MobHeadTextures.register(EntityType.f_20497_);
        MobHeadTextures.register(EntityType.f_20501_);
        MobHeadTextures.register(ModEntities.BOOGIEMAN);
        MobHeadTextures.register(ModEntities.BLUE_BLAZE);
        MobHeadTextures.register(ModEntities.TREASURE_GOBLIN);
        MobHeadTextures.register(ModEntities.ROBOT);
    }
}

