/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.helper.FontHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class PlayerArmorOverlay
implements IIngameOverlay {
    public void render(ForgeIngameGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            this.renderArmor(gui, poseStack, partialTick, width, height);
        }
    }

    private void renderArmor(ForgeIngameGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        int armor = player.m_21230_();
        if (armor <= 20) {
            ForgeIngameGui.ARMOR_LEVEL_ELEMENT.render(gui, poseStack, partialTick, width, height);
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.m_69478_();
        int left = mc.m_91268_().m_85445_() / 2 - 91;
        int top = mc.m_91268_().m_85446_() - ((ForgeIngameGui)Minecraft.m_91087_().f_91065_).left_height;
        for (int i = 0; i < 8; ++i) {
            GuiComponent.m_93143_((PoseStack)poseStack, (int)left, (int)top, (int)0, (float)34.0f, (float)9.0f, (int)9, (int)9, (int)256, (int)256);
            left += 8;
        }
        FontHelper.drawStringWithBorder(poseStack, String.valueOf(armor), (float)(left + 2), (float)(top + 1), -4671036, -16777216);
        ((ForgeIngameGui)Minecraft.m_91087_().f_91065_).left_height += 10;
        gui.setupOverlayRenderState(true, false);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void setupHealthTexture(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91072_.m_105288_()) {
            return;
        }
        int armor = player.m_21230_();
        if (armor <= 20) {
            return;
        }
        PoseStack matrixStack = event.getMatrixStack();
        RenderSystem.m_69478_();
        int left = mc.m_91268_().m_85445_() / 2 - 91;
        int top = mc.m_91268_().m_85446_() - ((ForgeIngameGui)Minecraft.m_91087_().f_91065_).left_height;
        for (int i = 0; i < 8; ++i) {
            GuiComponent.m_93143_((PoseStack)matrixStack, (int)left, (int)top, (int)0, (float)34.0f, (float)9.0f, (int)9, (int)9, (int)256, (int)256);
            left += 8;
        }
        FontHelper.drawStringWithBorder(matrixStack, String.valueOf(armor), (float)(left + 2), (float)(top + 1), -4671036, -16777216);
        ((ForgeIngameGui)Minecraft.m_91087_().f_91065_).left_height += 10;
        RenderSystem.m_69461_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }
}

