/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.client.ClientDamageData;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

@OnlyIn(value=Dist.CLIENT)
public class PlayerDamageOverlay
implements IIngameOverlay {
    private static final ResourceLocation STRENGTH_ICON = new ResourceLocation("minecraft", "textures/mob_effect/strength.png");

    public void render(ForgeIngameGui gui, PoseStack matrixStack, float partialTick, int width, int height) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91072_.m_105288_()) {
            return;
        }
        float multiplier = ClientDamageData.getCurrentDamageMultiplier();
        if ((double)Math.abs(multiplier - 1.0f) < 0.001) {
            return;
        }
        DecimalFormat format = new DecimalFormat("0");
        float value = (multiplier - 1.0f) * 100.0f;
        Object displayStr = format.format(value);
        if (value >= 0.0f) {
            displayStr = "+" + (String)displayStr;
        }
        displayStr = (String)displayStr + "%";
        ChatFormatting color = value < 0.0f ? ChatFormatting.RED : ChatFormatting.DARK_GREEN;
        MutableComponent display = new TextComponent((String)displayStr).m_130940_(color);
        ((ForgeIngameGui)Minecraft.m_91087_().f_91065_).left_height += 6;
        int left = mc.m_91268_().m_85445_() / 2 - 91;
        int top = mc.m_91268_().m_85446_() - ((ForgeIngameGui)Minecraft.m_91087_().f_91065_).left_height;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)STRENGTH_ICON);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)left, (double)top, 0.0);
        ScreenDrawHelper.drawTexturedQuads(buf -> ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack).dim(16.0f, 16.0f).draw());
        matrixStack.m_85837_(16.0, 4.0, 0.0);
        mc.f_91062_.m_92763_(matrixStack, (Component)display, 0.0f, 0.0f, 0xFFFFFF);
        matrixStack.m_85849_();
    }
}

