/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.client.gui.helper.AnimationTwoPhased;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.client.gui.screen.player.AbstractSkillTabElementContainerScreen;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

@OnlyIn(value=Dist.CLIENT)
public class VaultBarOverlay
implements IIngameOverlay {
    public static final ResourceLocation VAULT_HUD_SPRITE = new ResourceLocation("the_vault", "textures/gui/vault_hud.png");
    public static int vaultLevel;
    public static int vaultExp;
    public static int tnl;
    public static int unspentSkillPoints;
    public static int unspentExpertisePoints;
    public static int unspentKnowledgePoints;
    public static int unspentArchetypePoints;
    public static int unspentRegretPoints;
    private static final ObservableSupplier<Integer> VAULT_LEVEL_SUPPLIER;
    private static final ObservableSupplier<Integer> SKILL_POINT_SUPPLIER;
    private static final ObservableSupplier<Integer> EXPERTISE_POINT_SUPPLIER;
    private static final ObservableSupplier<Integer> KNOWLEDGE_POINT_SUPPLIER;
    private static final ObservableSupplier<Integer> ARCHETYPE_POINT_SUPPLIER;
    private static final ObservableSupplier<Integer> REGRET_POINT_SUPPLIER;
    private static Component vaultLevelComponent;
    private static Component unspentSkillPointComponent;
    private static Component unspentExpertisePointComponent;
    private static Component unspentKnowledgePointComponent;
    private static Component unspentArchetypePointComponent;
    private static Component unspentRegretPointComponent;
    private static int unspentSkillPointComponentWidth;
    private static int unspentExpertisePointComponentWidth;
    private static int unspentKnowledgePointComponentWidth;
    private static int unspentArchetypePointComponentWidth;
    private static int unspentRegretPointComponentWidth;
    public static AnimationTwoPhased expGainedAnimation;
    public static long previousTick;

    public void render(ForgeIngameGui gui, PoseStack matrixStack, float partialTick, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        ProfilerFiller profiler = minecraft.m_91307_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        profiler.m_6180_("VaultBarOverlay");
        int midX = width / 2;
        int bottom = height;
        int right = width;
        int barWidth = 83;
        float expPercentage = (float)vaultExp / (float)tnl;
        if (vaultLevel >= ModConfigs.LEVELS_META.getMaxLevel()) {
            expPercentage = 1.0f;
        }
        long now = System.currentTimeMillis();
        expGainedAnimation.tick((int)(now - previousTick));
        previousTick = now;
        profiler.m_6180_("experienceBarTexture");
        if (minecraft.f_91072_ != null && minecraft.f_91072_.m_105288_()) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)VAULT_HUD_SPRITE);
            minecraft.f_91065_.m_93228_(matrixStack, midX + 9, bottom - 48, 1, 1, barWidth, 5);
            if (expGainedAnimation.getValue() != 0.0f) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)expGainedAnimation.getValue());
                minecraft.f_91065_.m_93228_(matrixStack, midX + 8, bottom - 49, 62, 41, 84, 7);
            }
            minecraft.f_91065_.m_93228_(matrixStack, midX + 9, bottom - 48, 1, 7, (int)((float)barWidth * expPercentage), 5);
            if (expGainedAnimation.getValue() != 0.0f) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)expGainedAnimation.getValue());
                minecraft.f_91065_.m_93228_(matrixStack, midX + 8, bottom - 49, 62, 49, (int)((float)barWidth * expPercentage), 7);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        profiler.m_7238_();
        profiler.m_6180_("text");
        profiler.m_6180_("batchExperienceBarText");
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        if (!player.m_7500_() && !player.m_5833_()) {
            VAULT_LEVEL_SUPPLIER.ifChanged(VaultBarOverlay::onVaultLevelChanged);
            int textX = midX + 51 - minecraft.f_91062_.m_92852_((FormattedText)vaultLevelComponent) / 2;
            int textY = bottom - 54;
            FontHelper.drawStringWithBorder(textX, textY, -6601, 3945472, vaultLevelComponent.m_7532_(), minecraft, matrixStack, buffer);
        }
        profiler.m_6182_("batchKnowledgeAndSkillPointText");
        if (ClientVaults.getActive().isEmpty() && !(minecraft.f_91080_ instanceof AbstractSkillTabElementContainerScreen)) {
            VaultBarOverlay.renderPointText(minecraft, player, matrixStack, right, buffer);
        }
        profiler.m_6182_("renderText");
        RenderSystem.m_69482_();
        buffer.m_109911_();
        RenderSystem.m_69465_();
        profiler.m_7238_();
        profiler.m_7238_();
        profiler.m_7238_();
    }

    private static void renderPointText(Minecraft minecraft, LocalPlayer player, PoseStack matrixStack, int right, MultiBufferSource.BufferSource buffer) {
        IVaultOptions options;
        minecraft.m_91307_().m_6180_("calculatePotionOffsetY");
        int potionOffsetY = VaultBarOverlay.potionOffsetY(player);
        int gap = 5;
        matrixStack.m_85836_();
        if (potionOffsetY > 0) {
            matrixStack.m_85837_(0.0, (double)potionOffsetY, 0.0);
        }
        if ((options = (IVaultOptions)Minecraft.m_91087_().f_91066_).showPointMessages()) {
            int x;
            minecraft.m_91307_().m_6182_("batchSkillPointText");
            if (unspentSkillPoints != 0) {
                SKILL_POINT_SUPPLIER.ifChanged(VaultBarOverlay::onUnspentSkillPointsChanged);
                x = right - unspentSkillPointComponentWidth - gap;
                minecraft.f_91062_.m_92841_(unspentSkillPointComponent, (float)x, 18.0f, 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, 0xF000F0);
                matrixStack.m_85837_(0.0, 12.0, 0.0);
            }
            minecraft.m_91307_().m_6182_("batchExpertisePointText");
            if (unspentExpertisePoints != 0) {
                EXPERTISE_POINT_SUPPLIER.ifChanged(VaultBarOverlay::onUnspentExpertisePointsChanged);
                x = right - unspentExpertisePointComponentWidth - gap;
                minecraft.f_91062_.m_92841_(unspentExpertisePointComponent, (float)x, 18.0f, 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, 0xF000F0);
                matrixStack.m_85837_(0.0, 12.0, 0.0);
            }
            minecraft.m_91307_().m_6182_("batchRegretPointText");
            if (unspentRegretPoints != 0) {
                REGRET_POINT_SUPPLIER.ifChanged(VaultBarOverlay::onUnspentRegretPointsChanged);
                x = right - unspentRegretPointComponentWidth - gap;
                minecraft.f_91062_.m_92841_(unspentRegretPointComponent, (float)x, 18.0f, 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, 0xF000F0);
                matrixStack.m_85837_(0.0, 12.0, 0.0);
            }
            minecraft.m_91307_().m_6182_("batchKnowledgePointText");
            if (unspentKnowledgePoints != 0) {
                KNOWLEDGE_POINT_SUPPLIER.ifChanged(VaultBarOverlay::onUnspentKnowledgePointsChanged);
                x = right - unspentKnowledgePointComponentWidth - gap;
                minecraft.f_91062_.m_92841_(unspentKnowledgePointComponent, (float)x, 18.0f, 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, 0xF000F0);
                matrixStack.m_85837_(0.0, 12.0, 0.0);
            }
            minecraft.m_91307_().m_6182_("batchArchetypePointText");
            if (unspentArchetypePoints != 0) {
                ARCHETYPE_POINT_SUPPLIER.ifChanged(VaultBarOverlay::onUnspentArchetypePointsChanged);
                x = right - unspentArchetypePointComponentWidth - gap;
                minecraft.f_91062_.m_92841_(unspentArchetypePointComponent, (float)x, 18.0f, 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, 0xF000F0);
                matrixStack.m_85837_(0.0, 12.0, 0.0);
            }
        }
        matrixStack.m_85849_();
        minecraft.m_91307_().m_7238_();
    }

    private static void onVaultLevelChanged(int vaultLevel) {
        vaultLevelComponent = new TextComponent(String.valueOf(vaultLevel));
    }

    private static void onUnspentSkillPointsChanged(int unspentSkillPoints) {
        unspentSkillPointComponent = new TextComponent(String.valueOf(unspentSkillPoints)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16766976))).m_7220_((Component)new TextComponent(" unspent skill point" + (Math.abs(unspentSkillPoints) == 1 ? "" : "s")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))));
        unspentSkillPointComponentWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)unspentSkillPointComponent);
    }

    private static void onUnspentExpertisePointsChanged(int unspentExpertisePoints) {
        unspentExpertisePointComponent = new TextComponent(String.valueOf(unspentExpertisePoints)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16724414))).m_7220_((Component)new TextComponent(" unspent expertise point" + (Math.abs(unspentExpertisePoints) == 1 ? "" : "s")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))));
        unspentExpertisePointComponentWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)unspentExpertisePointComponent);
    }

    private static void onUnspentKnowledgePointsChanged(int unspentKnowledgePoints) {
        unspentKnowledgePointComponent = new TextComponent(String.valueOf(unspentKnowledgePoints)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)4249521))).m_7220_((Component)new TextComponent(" unspent knowledge point" + (Math.abs(unspentKnowledgePoints) == 1 ? "" : "s")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))));
        unspentKnowledgePointComponentWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)unspentKnowledgePointComponent);
    }

    private static void onUnspentArchetypePointsChanged(int unspentArchetypePoints) {
        unspentArchetypePointComponent = new TextComponent(String.valueOf(unspentArchetypePoints)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14905599))).m_7220_((Component)new TextComponent(" unspent archetype point" + (Math.abs(unspentArchetypePoints) == 1 ? "" : "s")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))));
        unspentArchetypePointComponentWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)unspentArchetypePointComponent);
    }

    private static void onUnspentRegretPointsChanged(int unspentRegretPoints) {
        unspentRegretPointComponent = new TextComponent(String.valueOf(unspentRegretPoints)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14747439))).m_7220_((Component)new TextComponent(" unspent regret point" + (Math.abs(unspentRegretPoints) == 1 ? "" : "s")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF))));
        unspentRegretPointComponentWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)unspentRegretPointComponent);
    }

    private static int potionOffsetY(LocalPlayer player) {
        List<MobEffectInstance> effectInstances = player.m_21220_().stream().filter(MobEffectInstance::m_19575_).toList();
        if (effectInstances.size() == 0) {
            return 0;
        }
        for (MobEffectInstance effectInstance : effectInstances) {
            if (effectInstance.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
            return 36;
        }
        return 18;
    }

    static {
        VAULT_LEVEL_SUPPLIER = ObservableSupplier.of(() -> vaultLevel, Integer::equals);
        SKILL_POINT_SUPPLIER = ObservableSupplier.of(() -> unspentSkillPoints, Integer::equals);
        EXPERTISE_POINT_SUPPLIER = ObservableSupplier.of(() -> unspentExpertisePoints, Integer::equals);
        KNOWLEDGE_POINT_SUPPLIER = ObservableSupplier.of(() -> unspentKnowledgePoints, Integer::equals);
        ARCHETYPE_POINT_SUPPLIER = ObservableSupplier.of(() -> unspentArchetypePoints, Integer::equals);
        REGRET_POINT_SUPPLIER = ObservableSupplier.of(() -> unspentRegretPoints, Integer::equals);
        expGainedAnimation = new AnimationTwoPhased(0.0f, 1.0f, 0.0f, 500);
        previousTick = System.currentTimeMillis();
    }
}

