/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.component.StatueOptionSlot;
import iskallia.vault.container.LootStatueContainer;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.OmegaStatueUIMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class LootStatueScreen
extends AbstractContainerScreen<LootStatueContainer> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("the_vault", "textures/gui/omega_statue_options.png");
    private final List<StatueOptionSlot> slots = new ArrayList<StatueOptionSlot>();
    List<ItemStack> items = new ArrayList<ItemStack>();
    BlockPos statuePos;
    private int selected = 0;

    public LootStatueScreen(LootStatueContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.f_97726_ = 176;
        this.f_97727_ = 84;
        this.f_97728_ = 88;
        this.f_97729_ = 7;
        ListTag itemList = screenContainer.getItemsCompound();
        for (Tag nbt : itemList) {
            CompoundTag itemNbt = (CompoundTag)nbt;
            this.items.add(ItemStack.m_41712_((CompoundTag)itemNbt));
        }
        this.statuePos = NbtUtils.m_129239_((CompoundTag)screenContainer.getBlockPos());
        int x = 0;
        int y = 29;
        for (int i = 0; i < 5; ++i) {
            x = i == 0 ? (x += 44) : (x += 18);
            this.slots.add(new StatueOptionSlot(x, y, 16, 16, this.items.get(i)));
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initFields();
    }

    protected void initFields() {
        this.f_96541_.f_91068_.m_90926_(true);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        float midX = (float)this.f_96543_ / 2.0f;
        float midY = (float)this.f_96544_ / 2.0f;
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        LootStatueScreen.m_93133_((PoseStack)matrixStack, (int)((int)(midX - (float)(this.f_97726_ / 2))), (int)((int)(midY - (float)(this.f_97727_ / 2))), (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)256, (int)256);
        this.renderTitle(matrixStack);
        this.renderText(matrixStack);
        int startX = this.f_96543_ / 2 - this.f_97726_ / 2;
        int startY = this.f_96544_ / 2 - this.f_97727_ / 2;
        StatueOptionSlot hovered = null;
        for (StatueOptionSlot slot : this.slots) {
            this.renderItem(slot.getStack(), startX + slot.getPosX(), startY + slot.getPosY());
            if (!this.m_6774_(slot.getPosX(), slot.getPosY(), 16, 16, mouseX, mouseY)) continue;
            int l = slot.getPosX();
            int i1 = slot.getPosY();
            this.selected = this.slots.indexOf(slot);
            LootStatueScreen.renderSlotHighlight((PoseStack)matrixStack, (int)(startX + l), (int)(startY + i1), (int)this.m_93252_(), (int)this.getSlotColor(0));
            hovered = slot;
        }
        StatueOptionSlot selected = this.getSelected();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        LootStatueScreen.m_93133_((PoseStack)matrixStack, (int)(startX + selected.getPosX() - 3), (int)(startY + selected.getPosY() - 3), (float)0.0f, (float)84.0f, (int)22, (int)22, (int)256, (int)256);
        if (hovered != null) {
            this.m_6057_(matrixStack, hovered.getStack(), mouseX, mouseY);
        }
    }

    private void renderItem(ItemStack stack, int x, int y) {
        this.f_96542_.m_115123_(stack, x, y);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
    }

    private void renderTitle(PoseStack matrixStack) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        float startX = (float)(i + this.f_97728_) - (float)this.f_96547_.m_92895_(this.f_96539_.getString()) / 2.0f;
        float startY = (float)j + (float)this.f_97729_;
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, startX, startY, 0x404040);
    }

    private void renderText(PoseStack matrixStack) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        TextComponent text = new TextComponent("Select an option for");
        TextComponent text1 = new TextComponent("the statue to generate.");
        float startTextX = (float)i + (float)this.f_97726_ / 2.0f - (float)this.f_96547_.m_92895_(text.getString()) / 2.0f;
        float startTextY = (float)j + 59.0f;
        this.f_96547_.m_92889_(matrixStack, (Component)text, startTextX, startTextY, 0x404040);
        float startText1X = (float)(i + this.f_97728_) - (float)this.f_96547_.m_92895_(text1.getString()) / 2.0f;
        float startText1Y = (float)j + 56.0f + 13.0f;
        this.f_96547_.m_92889_(matrixStack, (Component)text1, startText1X, startText1Y, 0x404040);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int translatedX = (int)Math.max(0.0, mouseX - (double)this.getGuiLeft());
        int translatedY = (int)Math.max(0.0, mouseY - (double)this.getGuiTop());
        StatueOptionSlot slot = this.getSelected();
        if (slot != null) {
            ModNetwork.CHANNEL.sendToServer((Object)OmegaStatueUIMessage.selectItem(slot.getStack(), this.statuePos));
            this.m_7379_();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private StatueOptionSlot getSelected() {
        return this.slots.get(this.selected);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 256 || keyCode == 69) && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            ModNetwork.CHANNEL.sendToServer((Object)OmegaStatueUIMessage.selectItem(this.getSelected().getStack(), this.statuePos));
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        if (keyCode == 263) {
            this.keyDown();
            return true;
        }
        if (keyCode == 262) {
            this.keyUp();
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (amount >= 1.0) {
            this.keyUp();
            return true;
        }
        if (amount <= -1.0) {
            this.keyDown();
            return true;
        }
        return false;
    }

    private void keyDown() {
        this.selected = (this.slots.size() + this.selected - 1) % this.slots.size();
    }

    private void keyUp() {
        this.selected = (this.selected + 1) % this.slots.size();
    }
}

