/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.util.TooltipUtil;
import iskallia.vault.client.util.color.ColorUtil;
import iskallia.vault.config.LegacyMagnetConfigs;
import iskallia.vault.container.inventory.MagnetTableContainerMenu;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.LegacyMagnetItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MagnetTableScreen
extends AbstractContainerScreen<MagnetTableContainerMenu>
implements ContainerListener {
    public static final ResourceLocation TEXTURE = new ResourceLocation("the_vault", "textures/gui/magnet_table.png");
    private float sturdinessBar = 0.0f;
    private final int[] ingredientCounts = new int[]{0, 0, 0, 0};
    private int upgradeVisual = 0;
    private LegacyMagnetItem.Stat upgradedStat = null;
    private boolean upgradedPerk = false;
    private final List<UpgradeButton> upgradeButtons = new ArrayList<UpgradeButton>();

    public MagnetTableScreen(MagnetTableContainerMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 176;
        this.f_97727_ = 200;
        this.f_97731_ += 36;
        ((MagnetTableContainerMenu)this.f_97732_).m_38893_(this);
    }

    public void m_7856_() {
        super.m_7856_();
        this.upgradeButtons.clear();
        this.f_96541_.f_91068_.m_90926_(true);
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        boolean u = false;
        this.m_7934_(this.f_97732_, 0, ((MagnetTableContainerMenu)this.f_97732_).m_38853_(0).m_7993_());
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.upgradeVisual > 0) {
            --this.upgradeVisual;
        }
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, k, l, 0, 0, this.f_97726_, this.f_97727_);
        int barSize = 34;
        int s = Math.round(this.sturdinessBar * (float)barSize);
        ItemStack magnet = this.getMagnet();
        LegacyMagnetItem.Perk perk = LegacyMagnetItem.getPerk(magnet);
        int x0 = k + 46;
        int y0 = l + 48;
        if (s != 0) {
            int cl = LegacyMagnetItem.getSturdinessColor((int)(this.sturdinessBar * 100.0f)).m_126665_();
            GuiComponent.m_93172_((PoseStack)poseStack, (int)x0, (int)y0, (int)(x0 + s), (int)(y0 + 3), (int)(0xFF000000 | cl));
            TextComponent percentage = new TextComponent((int)(this.sturdinessBar * 100.0f) + "%");
            int centerX = x0 + barSize / 2;
            this.f_96547_.m_92763_(poseStack, (Component)percentage, (float)centerX - (float)this.f_96547_.m_92852_((FormattedText)percentage) / 2.0f, (float)(y0 + 5), cl);
            if (perk == LegacyMagnetItem.Perk.NONE) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                GuiComponent.m_93160_((PoseStack)poseStack, (int)(centerX - 3 + (int)((float)(ModConfigs.MAGNET_CONFIG.getSturdinessCutoff() - 50) * 0.13f)), (int)(y0 - 2), (int)6, (int)6, (float)0.0f, (float)204.0f, (int)7, (int)7, (int)256, (int)256);
            }
        }
        if (!magnet.m_41619_()) {
            this.f_96547_.m_92763_(poseStack, (Component)new TranslatableComponent("tooltip.the_vault.magnet_upgrades"), (float)(k += 100), (float)(l += 22), -1);
            int U = 180;
            int V = 94;
            int W = 10;
            for (LegacyMagnetItem.Stat stat : LegacyMagnetItem.Stat.values()) {
                int value = LegacyMagnetItem.getStatUpgrade(magnet, stat);
                if (value != 0) {
                    Objects.requireNonNull(this.f_96547_);
                    int iconSize = 9 - 1;
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                    GuiComponent.m_93160_((PoseStack)poseStack, (int)k, (int)(l += 14), (int)iconSize, (int)iconSize, (float)U, (float)V, (int)W, (int)W, (int)256, (int)256);
                    int color = -1;
                    if (this.upgradeVisual != 0 && this.upgradedStat.equals((Object)stat)) {
                        color = ColorUtil.blendColors(ChatFormatting.GREEN.m_126665_(), -1, (float)this.upgradeVisual / 30.0f);
                    }
                    this.f_96547_.m_92763_(poseStack, (Component)new TextComponent((value > 0 ? " +" : " ") + value), (float)(k + iconSize), (float)l, color);
                }
                V += 18;
            }
            if (perk != LegacyMagnetItem.Perk.NONE) {
                Objects.requireNonNull(this.f_96547_);
                int iconSize = 9 - 1;
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                GuiComponent.m_93160_((PoseStack)poseStack, (int)k, (int)(l += 14), (int)iconSize, (int)iconSize, (float)198.0f, (float)(77 + 18 * perk.ordinal()), (int)W, (int)W, (int)256, (int)256);
                int color = -1;
                MutableComponent perkText = new TextComponent(" " + perk.m_7912_()).m_130948_(Style.f_131099_.m_178520_(ModConfigs.MAGNET_CONFIG.getPerkUpgrade(perk).getColor()));
                if (this.upgradedPerk) {
                    color = ColorUtil.blendColors(ChatFormatting.GREEN.m_126665_(), -1, (float)this.upgradeVisual / 30.0f);
                }
                this.f_96547_.m_92763_(poseStack, (Component)perkText, (float)(k + iconSize), (float)l, color);
            }
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        for (UpgradeButton b : this.upgradeButtons) {
            b.m_7428_(poseStack, mouseX, mouseY);
        }
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    private void renderUpgradeCost(PoseStack poseStack, LegacyMagnetConfigs.Upgrade upgrade) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)(this.m_93252_() + 300));
        int k = (this.f_96543_ - this.f_97726_) / 2 + 4;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        for (int i = 1; i < 5; ++i) {
            int cost = upgrade.getMaterialCost(i - 1);
            if (cost == 0) continue;
            Slot slot = ((MagnetTableContainerMenu)this.f_97732_).m_38853_(i);
            this.f_96547_.m_92750_(poseStack, (cost > this.ingredientCounts[i - 1] ? ChatFormatting.RED : ChatFormatting.GREEN) + "-" + cost, (float)(k + slot.f_40220_), (float)(l + slot.f_40221_), -1);
        }
        poseStack.m_85849_();
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        super.m_7027_(pPoseStack, pMouseX, pMouseY);
    }

    private ItemStack getMagnet() {
        return ((MagnetTableContainerMenu)this.f_97732_).m_38853_(0).m_7993_();
    }

    public boolean m_7933_(int key, int b, int c) {
        if (key == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(key, b, c);
    }

    public void m_7861_() {
        super.m_7861_();
        Minecraft.m_91087_().f_91068_.m_90926_(false);
    }

    public void m_7934_(AbstractContainerMenu pContainerToSend, int pSlotInd, ItemStack pStack) {
        ItemStack magnet = this.getMagnet();
        if (magnet.m_41619_()) {
            this.upgradeButtons.forEach(u -> {
                u.f_93623_ = false;
            });
            this.sturdinessBar = 0.0f;
        } else {
            for (int i = 1; i < 5; ++i) {
                ItemStack item = ((MagnetTableContainerMenu)this.f_97732_).m_38853_(i).m_7993_();
                this.ingredientCounts[i - 1] = item.m_41619_() ? 0 : item.m_41613_();
            }
            for (UpgradeButton b : this.upgradeButtons) {
                b.f_93623_ = b.upgrade.canCraftAndApply(this.ingredientCounts, pStack, b.stat);
            }
            this.sturdinessBar = (float)LegacyMagnetItem.getSturdiness(magnet) / 100.0f;
        }
    }

    public void m_142153_(AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
        boolean a = true;
    }

    protected class UpgradeButton
    extends AbstractButton {
        private final int textureIndex;
        private final LegacyMagnetConfigs.Upgrade upgrade;
        private final LegacyMagnetItem.Stat stat;

        protected UpgradeButton(int x, int y, int index, LegacyMagnetConfigs.Upgrade upgrade, LegacyMagnetItem.Stat stat) {
            super(x, y, 18, 18, TextComponent.f_131282_);
            this.textureIndex = index;
            this.upgrade = upgrade;
            this.stat = stat;
        }

        public void m_6303_(PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int v = this.textureIndex * this.f_93618_;
            int u = 176;
            if (!this.f_93623_) {
                u += this.f_93618_;
            } else if (this.f_93622_) {
                u += this.f_93618_ * 2;
            }
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_, u, v, this.f_93618_, this.f_93619_);
        }

        public void m_7428_(PoseStack pPoseStack, int x, int y) {
            if (this.m_198029_()) {
                MagnetTableScreen.this.renderUpgradeCost(pPoseStack, this.upgrade);
                TooltipUtil.renderTooltip(pPoseStack, this.upgrade.getTooltip(MagnetTableScreen.this.ingredientCounts, this.stat), this.f_93620_ + this.f_93618_ / 2, y, (Screen)MagnetTableScreen.this, true);
            }
        }

        public void m_5691_() {
            MagnetTableScreen.this.upgradeVisual = 30;
            MagnetTableScreen.this.upgradedStat = this.stat;
            MagnetTableScreen.this.upgradedPerk = false;
            if (LegacyMagnetItem.getPerk(MagnetTableScreen.this.getMagnet()) == LegacyMagnetItem.Perk.NONE && LegacyMagnetItem.getSturdiness(MagnetTableScreen.this.getMagnet()) - ModConfigs.MAGNET_CONFIG.getSturdinessDecrement() <= ModConfigs.MAGNET_CONFIG.getSturdinessCutoff()) {
                MagnetTableScreen.this.upgradedPerk = true;
            }
            ((MagnetTableScreen)MagnetTableScreen.this).f_96541_.f_91072_.m_105208_(((MagnetTableContainerMenu)((MagnetTableScreen)MagnetTableScreen.this).f_97732_).f_38840_, this.stat.ordinal());
        }

        public void m_142291_(NarrationElementOutput output) {
        }
    }
}

