/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.container.RenamingContainer;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.RenameUIMessage;
import iskallia.vault.util.RenameType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class RenameScreen
extends AbstractContainerScreen<RenamingContainer> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("the_vault", "textures/gui/rename_screen.png");
    private String name;
    private CompoundTag data;
    private RenameType renameType;
    private Button renameButton;
    private ItemStack itemStack;
    private BlockPos chamberPos;
    private EditBox nameField;

    public RenameScreen(RenamingContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.f_97726_ = 172;
        this.f_97727_ = 66;
        this.f_97728_ = this.f_97726_ / 2;
        this.f_97729_ = 7;
        this.renameType = screenContainer.getRenameType();
        this.data = screenContainer.getNbt();
        switch (this.renameType) {
            case PLAYER_STATUE: {
                this.name = this.data.m_128461_("PlayerNickname");
                break;
            }
            case CRYO_CHAMBER: {
                this.chamberPos = NbtUtils.m_129239_((CompoundTag)this.data.m_128469_("BlockPos"));
                this.name = this.data.m_128461_("EternalName");
                break;
            }
            case VAULT_CRYSTAL: {
                this.itemStack = ItemStack.m_41712_((CompoundTag)this.data);
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initFields();
    }

    protected void initFields() {
        this.f_96541_.f_91068_.m_90926_(true);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.nameField = new EditBox(this.f_96547_, i + 34, j + 26, 103, 12, (Component)new TextComponent(this.name));
        this.nameField.m_94190_(false);
        this.nameField.m_94202_(-1);
        this.nameField.m_94205_(-1);
        this.nameField.m_94182_(false);
        this.nameField.m_94199_(16);
        this.nameField.m_94151_(this::rename);
        this.m_7787_((GuiEventListener)this.nameField);
        this.m_94718_((GuiEventListener)this.nameField);
        this.nameField.m_94144_(this.name);
        this.renameButton = new Button(i + 31, j + 40, 110, 20, (Component)new TextComponent("Confirm"), this::confirmPressed);
        this.m_142416_((GuiEventListener)this.renameButton);
    }

    private void confirmPressed(Button button) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("RenameType", this.renameType.ordinal());
        switch (this.renameType) {
            case PLAYER_STATUE: {
                this.data.m_128359_("PlayerNickname", this.name);
                nbt.m_128365_("Data", (Tag)this.data);
                break;
            }
            case CRYO_CHAMBER: {
                CompoundTag data = new CompoundTag();
                data.m_128365_("BlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.chamberPos));
                data.m_128359_("EternalName", this.name);
                nbt.m_128365_("Data", (Tag)data);
                break;
            }
            case VAULT_CRYSTAL: {
                nbt.m_128365_("Data", (Tag)this.itemStack.serializeNBT());
            }
        }
        ModNetwork.CHANNEL.sendToServer((Object)RenameUIMessage.updateName(this.renameType, nbt));
        this.m_7379_();
    }

    private void rename(String name) {
        this.name = name;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_6915_();
            }
        } else if (keyCode == 257) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            this.confirmPressed(this.renameButton);
        } else if (keyCode == 69) {
            return true;
        }
        return this.nameField.m_7933_(keyCode, scanCode, modifiers) || this.nameField.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        float midX = (float)this.f_96543_ / 2.0f;
        float midY = (float)this.f_96544_ / 2.0f;
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        RenameScreen.m_93133_((PoseStack)matrixStack, (int)((int)(midX - (float)(this.f_97726_ / 2))), (int)((int)(midY - (float)(this.f_97727_ / 2))), (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)256, (int)256);
        this.renderTitle(matrixStack);
        this.renderNameField(matrixStack, mouseX, mouseY, partialTicks);
        this.renameButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
    }

    private void renderTitle(PoseStack matrixStack) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        float startX = (float)(i + this.f_97728_) - (float)this.f_96547_.m_92895_(this.f_96539_.getString()) / 2.0f;
        float startY = (float)j + (float)this.f_97729_;
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, startX, startY, 0x404040);
    }

    public void renderNameField(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.nameField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

