/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.util.TooltipUtil;
import iskallia.vault.client.util.color.ColorUtil;
import iskallia.vault.config.PaxelConfigs;
import iskallia.vault.container.ToolViseContainerMenu;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.tool.PaxelItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ToolViseScreen
extends AbstractContainerScreen<ToolViseContainerMenu>
implements ContainerListener {
    public static final ResourceLocation TEXTURE = new ResourceLocation("the_vault", "textures/gui/tool_vise.png");
    private float sturdinessPercentage = 1.0f;
    private float level = 0.0f;
    private float maxLevel = 0.0f;
    private int levelPerSocket = 0;
    private final int[] ingredientCounts = new int[6];
    private int upgradeVisual = 0;
    private PaxelItem.Stat upgradedStat = null;
    private boolean upgradedPerk = false;
    private final List<UpgradeButton> upgradeButtons = new ArrayList<UpgradeButton>();

    public ToolViseScreen(ToolViseContainerMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 176;
        this.f_97727_ = 218;
        this.f_97731_ += 54;
        ((ToolViseContainerMenu)this.m_6262_()).m_38893_(this);
    }

    public void m_7856_() {
        super.m_7856_();
        this.upgradeButtons.clear();
        this.f_96541_.f_91068_.m_90926_(true);
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        int u = 0;
        for (PaxelItem.Stat stat : PaxelItem.Stat.values()) {
            PaxelConfigs.Upgrade upgrade = ((ToolViseContainerMenu)this.f_97732_).upgrades.get((Object)stat);
            this.upgradeButtons.add((UpgradeButton)this.m_142416_((GuiEventListener)new UpgradeButton(i + 10, j + 19 + 22 * u, u, upgrade, stat)));
            ++u;
        }
        this.m_7934_(this.f_97732_, 36, ((ToolViseContainerMenu)this.f_97732_).m_38853_(36).m_7993_());
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.upgradeVisual > 0) {
            --this.upgradeVisual;
        }
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int xOffset = (this.f_96543_ - this.f_97726_) / 2;
        int yOffset = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, xOffset, yOffset, 0, 0, this.f_97726_, this.f_97727_);
        int barSize = 34;
        float normalizedLevel = this.level / this.maxLevel;
        int barLevel = Math.round(normalizedLevel * (float)barSize);
        ItemStack paxel = this.getPaxel();
        List<PaxelItem.Perk> perks = PaxelItem.getPerks(paxel);
        int x0 = xOffset + 46;
        int y0 = yOffset + 48;
        if (this.sturdinessPercentage != 0.0f) {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)x0, (int)y0, (int)(x0 + barLevel), (int)(y0 + 3), (int)(0xFF000000 | ChatFormatting.YELLOW.m_126665_()));
            int cl = PaxelItem.getSturdinessColor((int)(this.sturdinessPercentage * 100.0f)).m_126665_();
            TextComponent percentage = new TextComponent((int)(this.sturdinessPercentage * 100.0f) + "%");
            int centerX = x0 + barSize / 2;
            this.f_96547_.m_92763_(poseStack, (Component)percentage, (float)centerX - (float)this.f_96547_.m_92852_((FormattedText)percentage) / 2.0f, (float)(y0 + 5), cl);
            if (this.level < this.maxLevel) {
                float nextSlot = (this.level + ((float)this.levelPerSocket - this.level % (float)this.levelPerSocket)) / this.maxLevel;
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                GuiComponent.m_93160_((PoseStack)poseStack, (int)(centerX - barSize / 2 - 3 + (int)(nextSlot * (float)barSize)), (int)(y0 - 2), (int)6, (int)6, (float)230.0f, (float)0.0f, (int)7, (int)7, (int)256, (int)256);
            }
        }
        if (!paxel.m_41619_()) {
            this.f_96547_.m_92763_(poseStack, (Component)new TranslatableComponent("tooltip.the_vault.magnet_upgrades"), (float)(xOffset += 100), (float)(yOffset += 22), -1);
            yOffset += 14;
            int uStat = 0;
            int vStat = 218;
            int widthHeight = 14;
            for (PaxelItem.Stat stat : PaxelItem.Stat.values()) {
                float value = PaxelItem.getStatUpgrade(paxel, stat);
                if (value != 0.0f) {
                    PaxelConfigs.Upgrade upgradeCfg = ModConfigs.PAXEL_CONFIGS.getUpgrade(stat);
                    String valueStr = upgradeCfg.formatValue(value);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                    GuiComponent.m_93160_((PoseStack)poseStack, (int)xOffset, (int)yOffset, (int)widthHeight, (int)widthHeight, (float)uStat, (float)vStat, (int)widthHeight, (int)widthHeight, (int)256, (int)256);
                    int color = -1;
                    if (this.upgradeVisual != 0 && this.upgradedStat.equals((Object)stat)) {
                        color = ColorUtil.blendColors(ChatFormatting.GREEN.m_126665_(), -1, (float)this.upgradeVisual / 30.0f);
                    }
                    this.f_96547_.m_92763_(poseStack, (Component)new TextComponent((value > 0.0f ? " +" : " ") + valueStr), (float)(xOffset + 12), (float)(yOffset + 3), color);
                    yOffset += 16;
                }
                uStat += widthHeight;
            }
            for (PaxelItem.Perk perk : perks) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                GuiComponent.m_93160_((PoseStack)poseStack, (int)xOffset, (int)yOffset, (int)widthHeight, (int)widthHeight, (float)(14 * perk.ordinal()), (float)232.0f, (int)widthHeight, (int)widthHeight, (int)256, (int)256);
                int color = -1;
                MutableComponent perkText = new TextComponent(" " + perk.m_7912_()).m_130948_(Style.f_131099_.m_178520_(ModConfigs.PAXEL_CONFIGS.getPerkUpgrade(perk).getColor()));
                if (this.upgradedPerk) {
                    color = ColorUtil.blendColors(ChatFormatting.GREEN.m_126665_(), -1, (float)this.upgradeVisual / 30.0f);
                }
                this.f_96547_.m_92763_(poseStack, (Component)perkText, (float)(xOffset + 12), (float)(yOffset + 3), color);
                yOffset += 16;
            }
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        for (UpgradeButton b : this.upgradeButtons) {
            b.m_7428_(poseStack, mouseX, mouseY);
        }
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    private void renderUpgradeCost(PoseStack poseStack, PaxelConfigs.Upgrade upgrade) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)(this.m_93252_() + 300));
        int k = (this.f_96543_ - this.f_97726_) / 2 + 4;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        for (int i = 0; i < this.ingredientCounts.length; ++i) {
            int cost = upgrade.getMaterialCost(i);
            if (cost == 0) continue;
            Slot slot = ((ToolViseContainerMenu)this.f_97732_).m_38853_(i + 1 + 36);
            this.f_96547_.m_92750_(poseStack, (cost > this.ingredientCounts[i] ? ChatFormatting.RED : ChatFormatting.GREEN) + "-" + cost, (float)(k + slot.f_40220_), (float)(l + slot.f_40221_), -1);
        }
        poseStack.m_85849_();
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        super.m_7027_(pPoseStack, pMouseX, pMouseY);
    }

    private ItemStack getPaxel() {
        return ((ToolViseContainerMenu)this.f_97732_).m_38853_(36).m_7993_();
    }

    public boolean m_7933_(int key, int b, int c) {
        if (key == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(key, b, c);
    }

    public void m_7861_() {
        super.m_7861_();
        Minecraft.m_91087_().f_91068_.m_90926_(false);
    }

    public void m_7934_(AbstractContainerMenu pContainerToSend, int pSlotInd, ItemStack pStack) {
        ItemStack paxel = this.getPaxel();
        if (paxel.m_41619_()) {
            this.upgradeButtons.forEach(u -> {
                u.f_93623_ = false;
            });
            this.sturdinessPercentage = 0.0f;
            this.level = 0.0f;
            this.maxLevel = 0.0f;
            this.levelPerSocket = 0;
        } else {
            for (int i = 0; i < this.ingredientCounts.length; ++i) {
                ItemStack item = ((ToolViseContainerMenu)this.f_97732_).m_38853_(i + 1 + 36).m_7993_();
                this.ingredientCounts[i] = item.m_41619_() ? 0 : item.m_41613_();
            }
            for (UpgradeButton b : this.upgradeButtons) {
                b.f_93623_ = b.upgrade.canCraftAndApply(this.ingredientCounts, pStack, b.stat);
            }
            this.sturdinessPercentage = (float)PaxelItem.getSturdiness(paxel) / 100.0f;
            this.level = PaxelItem.getLevel(paxel);
            this.maxLevel = ModConfigs.PAXEL_CONFIGS.getTierValues(paxel).getMaxLevel();
            this.levelPerSocket = ModConfigs.PAXEL_CONFIGS.getTierValues(paxel).getLevelsPerSocket();
        }
    }

    public void m_142153_(AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
        boolean a = true;
    }

    public class UpgradeButton
    extends AbstractButton {
        private final int textureIndex;
        private final PaxelConfigs.Upgrade upgrade;
        private final PaxelItem.Stat stat;

        protected UpgradeButton(int x, int y, int index, PaxelConfigs.Upgrade upgrade, PaxelItem.Stat stat) {
            super(x, y, 18, 18, TextComponent.f_131282_);
            this.textureIndex = index;
            this.upgrade = upgrade;
            this.stat = stat;
        }

        public void m_6303_(PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int v = this.textureIndex * this.f_93618_;
            int u = 176;
            if (!this.f_93623_) {
                u += this.f_93618_;
            } else if (this.f_93622_) {
                u += this.f_93618_ * 2;
            }
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_, u, v, this.f_93618_, this.f_93619_);
        }

        public void m_7428_(PoseStack pPoseStack, int x, int y) {
            if (this.m_198029_()) {
                ToolViseScreen.this.renderUpgradeCost(pPoseStack, this.upgrade);
                TooltipUtil.renderTooltip(pPoseStack, this.upgrade.getTooltip(ToolViseScreen.this.ingredientCounts, this.stat), this.f_93620_ + this.f_93618_ / 2, y, (Screen)ToolViseScreen.this, true);
            }
        }

        public void m_5691_() {
            ToolViseScreen.this.upgradeVisual = 30;
            ToolViseScreen.this.upgradedStat = this.stat;
            ToolViseScreen.this.upgradedPerk = false;
            ((ToolViseScreen)ToolViseScreen.this).f_96541_.f_91072_.m_105208_(((ToolViseContainerMenu)((ToolViseScreen)ToolViseScreen.this).f_97732_).f_38840_, this.stat.ordinal());
        }

        public void m_142291_(NarrationElementOutput output) {
        }
    }
}

