/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.accessibility;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ColorSquareElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.SliderElement;
import iskallia.vault.client.gui.framework.element.ToggleButtonElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.util.ColorOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class VaultAccessibilityScreen
extends AbstractElementScreen {
    private ColorOption selectedColorOption;
    private SliderElement redSliderElement;
    private SliderElement greenSliderElement;
    private SliderElement blueSliderElement;
    private NineSliceButtonElement<?> defaultColorButton;
    private ColorSquareElement colorSquareElement;

    public VaultAccessibilityScreen() {
        super((Component)new TextComponent("Vault Hunters Accessibility Options"), ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        Window window = Minecraft.m_91087_().m_91268_();
        this.setGuiSize(Spatials.size(window.m_85445_(), window.m_85446_()));
        int padding = 4;
        int widgetWidth = 150;
        int widgetHeight = 20;
        int startX = 0;
        int startY = 0;
        int x = startX;
        int y = startY;
        IVaultOptions options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        this.selectedColorOption = options.getChestHunterSpec();
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Vault Potion Effects"), () -> options.doVanillaPotionDamageEffects() ? "OFF" : "ON", () -> options.setVanillaPotionDamageEffects(!options.doVanillaPotionDamageEffects())).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Custom Hunter Colors"), () -> options.isHunterCustomColorsEnabled() ? "ON" : "OFF", () -> options.setHunterCustomColorsEnabled(!options.isHunterCustomColorsEnabled())).layout(this.translateWorldSpatial()));
        x = startX;
        ColorOption.HunterSpec[] specs = ColorOption.HunterSpec.values();
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Hunter Target"), () -> this.selectedColorOption.getHunterSpec().name(), () -> {
            int index = this.selectedColorOption.getHunterSpec().ordinal();
            int next = index + 1 >= specs.length ? 0 : index + 1;
            options.setColorOption(specs[index], this.selectedColorOption);
            this.selectedColorOption = options.getBySpec(specs[next]);
            this.updateSliderValues();
        }).layout(this.translateWorldSpatial()));
        this.colorSquareElement = new ColorSquareElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight * 3 + padding * 2), () -> this.selectedColorOption.getColor());
        x = startX;
        this.redSliderElement = new SliderElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), () -> new TextComponent("Red"), () -> Float.valueOf(this.selectedColorOption.getRed()), value -> this.selectedColorOption.setRed(value.floatValue()));
        this.greenSliderElement = new SliderElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), () -> new TextComponent("Green"), () -> Float.valueOf(this.selectedColorOption.getGreen()), value -> this.selectedColorOption.setGreen(value.floatValue()));
        this.blueSliderElement = new SliderElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), () -> new TextComponent("Blue"), () -> Float.valueOf(this.selectedColorOption.getBlue()), value -> this.selectedColorOption.setBlue(value.floatValue()));
        this.defaultColorButton = new NineSliceButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, () -> {
            this.selectedColorOption = options.resetColorOption(this.selectedColorOption.getHunterSpec());
            this.updateSliderValues();
        }).label(() -> new TextComponent("Default Color"), LabelTextStyle.shadow().center());
        x = startX;
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Ability Scrolling"), () -> options.isAbilityScrollingEnabled() ? "ON" : "OFF", () -> options.setAbilityScrollingEnabled(!options.isAbilityScrollingEnabled())).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Cooldown GUI"), () -> options.getCooldownGuiOption().getSerializedNameUpper(), options::cycleCooldownGuiOption).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Show Point Messages"), () -> options.showPointMessages() ? "ON" : "OFF", () -> options.setShowPointMessages(!options.showPointMessages())).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Show Rarity Names"), () -> options.showRarityNames() ? "ON" : "OFF", () -> options.setShowRarityNames(!options.showRarityNames())).layout(this.translateWorldSpatial()));
        this.addElement(this.colorSquareElement).layout(this.translateWorldSpatial());
        this.addElement(this.redSliderElement).layout(this.translateWorldSpatial());
        this.addElement(this.greenSliderElement).layout(this.translateWorldSpatial());
        this.addElement(this.blueSliderElement).layout(this.translateWorldSpatial());
        this.addElement((NineSliceButtonElement)this.defaultColorButton.layout(this.translateWorldSpatial()));
    }

    private void updateSliderValues() {
        this.redSliderElement.setValue(this.selectedColorOption.getRed());
        this.greenSliderElement.setValue(this.selectedColorOption.getGreen());
        this.blueSliderElement.setValue(this.selectedColorOption.getBlue());
    }

    @NotNull
    private ILayoutStrategy translateWorldSpatial() {
        return (screen, gui, parent, world) -> {
            Window window = Minecraft.m_91087_().m_91268_();
            world.translateXY(window.m_85445_() / 2 - 150 - 4, 36);
        };
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_96626_(0);
        VaultAccessibilityScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderBackgroundFill(@NotNull PoseStack poseStack) {
    }

    public void m_96626_(int pVOffset) {
        super.m_96626_(pVOffset);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_(0.0, (double)this.f_96544_ - 32.0, 0.0).m_7421_(0.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)this.f_96544_ - 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_7421_(0.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_(0.0, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        tesselator.m_85914_();
    }
}

