/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.EntityModelElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TabElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.player.element.CuriosElement;
import iskallia.vault.container.WardrobeContainer;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.CuriosGearItem;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.trinket.GearAttributeTrinket;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.item.MagnetItem;
import iskallia.vault.item.gear.VaultArmorItem;
import iskallia.vault.network.message.ServerboundWardrobeTabMessage;
import iskallia.vault.util.StatUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class WardrobeScreen<T extends WardrobeContainer>
extends AbstractElementContainerScreen<T> {
    private static final Map<Class<?>, AttributeTypeHandler<?>> ATTRIBUTE_TYPE_HANDLERS = Map.of(Integer.class, new AttributeTypeHandler<Integer>(100, v -> v == 0, v -> v > 0, v -> -v.intValue()), Float.class, new AttributeTypeHandler<Float>(99, v -> Math.abs(v.floatValue()) < 1.0E-4f, v -> v.floatValue() > 0.0f, v -> Float.valueOf(-v.floatValue())), Double.class, new AttributeTypeHandler<Double>(98, v -> Math.abs(v) < 1.0E-4, v -> v > 0.0, v -> -v.doubleValue()));
    private static final AttributeTypeHandler<?> DEFAULT_ATTRIBUTE_TYPE_HANDLER = new AttributeTypeHandler<Object>(0, v -> false, v -> false, v -> v);
    private static final Set<VaultGearAttribute<?>> EXCLUDED_ATTRIBUTES = Set.of(ModGearAttributes.DURABILITY, ModGearAttributes.SOULBOUND);
    private static final Map<VaultGearAttribute<?>, Integer> ATTRIBUTES_ORDER = new LinkedHashMap();

    private static <T> AttributeTypeHandler<T> getAttributeTypeHandler(T value) {
        return ATTRIBUTE_TYPE_HANDLERS.getOrDefault(value.getClass(), DEFAULT_ATTRIBUTE_TYPE_HANDLER);
    }

    public WardrobeScreen(T container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(204, 194));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXY(0, 0).size(0, 10), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui).add(Spatials.size(-28, 10)))));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 6), (Component)new TextComponent("Wardrobe").m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, ((WardrobeContainer)this.m_6262_()).m_38853_((int)0).f_40221_ - 12), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.addElement((EntityModelElement)new EntityModelElement((IPosition)Spatials.positionXY(this.f_97726_ / 2 - 42, 17), (ISize)Spatials.size(54, 72), () -> inventory.f_35978_, Spatials.positionY(8), 1.0f).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
    }

    private static TabElement<?> createTab(boolean selected, TextureAtlasRegion icon, int x, Runnable onClick) {
        return (TabElement)new TabElement(Spatials.positionXYZ(x, selected ? -28 : -24, 1), new TextureAtlasElement(selected ? ScreenTextures.TAB_BACKGROUND_TOP_SELECTED : ScreenTextures.TAB_BACKGROUND_TOP), new TextureAtlasElement(Spatials.positionXYZ(6, selected ? 9 : 5, 1), icon), onClick).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
    }

    private static <T> int compareAttributeValues(VaultGearAttribute<T> attribute, Object o1Value, Object o2Value) {
        VaultGearAttributeType<T> type = attribute.getType();
        return attribute.getAttributeComparator() == null ? 0 : attribute.getAttributeComparator().compare(type.cast(o1Value), type.cast(o2Value));
    }

    static {
        int i = 0;
        for (VaultGearAttribute attribute : VaultGearAttributeRegistry.getRegistry()) {
            ATTRIBUTES_ORDER.put(attribute, i++);
        }
    }

    private static class AttributeTypeHandler<T> {
        private final Predicate<T> isZero;
        private final Predicate<T> isGreaterThanZero;
        private final int sortOrder;
        private UnaryOperator<T> invert;

        private AttributeTypeHandler(int sortOrder, Predicate<T> isZero, Predicate<T> isGreaterThanZero, UnaryOperator<T> invert) {
            this.isZero = isZero;
            this.isGreaterThanZero = isGreaterThanZero;
            this.sortOrder = sortOrder;
            this.invert = invert;
        }

        public T invert(T value) {
            return (T)this.invert.apply(value);
        }

        public boolean isZero(T value) {
            return this.isZero.test(value);
        }

        public boolean isGreaterThanZero(T value) {
            return this.isGreaterThanZero.test(value);
        }

        public int getSortOrder() {
            return this.sortOrder;
        }
    }

    private static class GearAttributeInstanceRegistryOrderComparator
    implements Comparator<VaultGearAttributeInstance<?>> {
        public static final GearAttributeInstanceRegistryOrderComparator INSTANCE = new GearAttributeInstanceRegistryOrderComparator();

        private GearAttributeInstanceRegistryOrderComparator() {
        }

        @Override
        public int compare(VaultGearAttributeInstance<?> o1, VaultGearAttributeInstance<?> o2) {
            VaultGearAttribute<?> attribute = o1.getAttribute();
            int result = ATTRIBUTES_ORDER.getOrDefault(attribute, -1) - ATTRIBUTES_ORDER.getOrDefault(o2.getAttribute(), -1);
            if (result != 0) {
                return result;
            }
            return WardrobeScreen.compareAttributeValues(attribute, o1.getValue(), o2.getValue());
        }
    }

    private static class GearAttributeInstanceComparator
    implements Comparator<VaultGearAttributeInstance<?>> {
        public static final GearAttributeInstanceRegistryOrderComparator INSTANCE = new GearAttributeInstanceRegistryOrderComparator();

        private GearAttributeInstanceComparator() {
        }

        @Override
        public int compare(VaultGearAttributeInstance<?> o1, VaultGearAttributeInstance<?> o2) {
            AttributeTypeHandler<Class<?>> ath1 = WardrobeScreen.getAttributeTypeHandler(o1.getValue().getClass());
            AttributeTypeHandler<Class<?>> ath2 = WardrobeScreen.getAttributeTypeHandler(o2.getValue().getClass());
            int result = ath1.getSortOrder() - ath2.getSortOrder();
            if (result != 0) {
                return result;
            }
            return WardrobeScreen.compareAttributeValues(o1.getAttribute(), o1.getValue(), o2.getValue());
        }
    }

    public static class Hotbar
    extends WardrobeScreen<WardrobeContainer.Hotbar> {
        public Hotbar(WardrobeContainer.Hotbar container, Inventory inventory, Component title) {
            super(container, inventory, title);
            this.addElement(WardrobeScreen.createTab(false, ScreenTextures.TAB_ICON_WARDROBE_GEAR, 4, () -> ModNetwork.CHANNEL.sendToServer((Object)new ServerboundWardrobeTabMessage(false, ((WardrobeContainer.Hotbar)this.m_6262_()).getPos()))));
            this.addElement(WardrobeScreen.createTab(true, ScreenTextures.TAB_ICON_WARDROBE_HOTBAR, 35, () -> {}));
        }
    }

    public static class Gear
    extends WardrobeScreen<WardrobeContainer.Gear> {
        private final ButtonElement<?> swapButton;
        private final List<Component> swapTooltip = new ArrayList<Component>();
        private boolean isShiftPressed = false;
        boolean inTooltipClearCooldown = false;
        private long tooltipClearTime = 0L;

        public Gear(WardrobeContainer.Gear container, Inventory inventory, Component title) {
            super(container, inventory, title);
            this.addElement(WardrobeScreen.createTab(true, ScreenTextures.TAB_ICON_WARDROBE_GEAR, 4, () -> {}));
            this.addElement(WardrobeScreen.createTab(false, ScreenTextures.TAB_ICON_WARDROBE_HOTBAR, 35, () -> ModNetwork.CHANNEL.sendToServer((Object)new ServerboundWardrobeTabMessage(true, ((WardrobeContainer.Gear)this.m_6262_()).getPos()))));
            this.addElement(new CuriosElement(() -> Spatials.positionXY(-8, this.f_97736_ + 14), ((WardrobeContainer.Gear)this.m_6262_()).getCurioContainerHandler().canScroll(), ((WardrobeContainer.Gear)this.m_6262_()).getCurioContainerHandler().getVisibleSlotCount(), value -> ((WardrobeContainer.Gear)this.m_6262_()).getCurioContainerHandler().scrollTo(value.floatValue())));
            this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(this.f_97726_ - 32, 10, -20).size(32, ((WardrobeContainer.Gear)this.m_6262_()).getCurioContainerHandler().getVisibleSlotCount() * 18 + 16), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
            this.swapButton = (ButtonElement)new ButtonElement(Spatials.positionXY(this.f_97726_ / 2 - 15 - 9, 89), ScreenTextures.BUTTON_WARDROBE_SWAP_TEXTURES, ((WardrobeContainer.Gear)this.m_6262_())::swap).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
            this.swapButton.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                tooltipRenderer.renderComponentTooltip(poseStack, this.getSwapButtonTooltipLines(), mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            });
            this.swapButton.setDisabled(!((WardrobeContainer.Gear)this.m_6262_()).isOwner());
            this.addElement(this.swapButton);
            ((SolidRenderButtonElement)this.addElement(new SolidRenderButtonElement(Spatials.positionXY(this.f_97726_ - 51, 3))).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).tooltip(() -> ((WardrobeContainer.Gear)this.m_6262_()).shouldRenderSolid() ? new TranslatableComponent("screen.the_vault.wardrobe.tooltip.render_solid") : new TranslatableComponent("screen.the_vault.wardrobe.tooltip.render_transparent"));
            ((WardrobeContainer.Gear)this.m_6262_()).setSlotChangeListener(() -> {
                this.inTooltipClearCooldown = true;
                this.tooltipClearTime = System.currentTimeMillis() + 100L;
            });
        }

        protected void m_181908_() {
            super.m_181908_();
            if (this.inTooltipClearCooldown && System.currentTimeMillis() > this.tooltipClearTime) {
                this.inTooltipClearCooldown = false;
                this.swapTooltip.clear();
            }
        }

        private List<Component> getSwapButtonTooltipLines() {
            this.initSwapTooltip();
            return this.swapTooltip;
        }

        private void initSwapTooltip() {
            boolean showDefense;
            boolean showDamage;
            if (!this.swapTooltip.isEmpty() || this.isShiftPressed != ((WardrobeContainer.Gear)this.m_6262_()).isHoldingShift()) {
                return;
            }
            this.swapTooltip.add((Component)new TranslatableComponent("screen.the_vault.wardrobe.tooltip.swap"));
            if (this.isShiftPressed) {
                this.swapTooltip.add((Component)new TranslatableComponent("screen.the_vault.wardrobe.tooltip.swap_all").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            } else {
                this.swapTooltip.add((Component)new TranslatableComponent("screen.the_vault.wardrobe.tooltip.swap_matching").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            }
            this.swapTooltip.add(TextComponent.f_131282_);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Player wardrobePlayer = this.getPlayerWithWardrobeItemsSwapped(player);
            double playerDps = StatUtils.getAverageDps((Player)player);
            double playerArmor = StatUtils.getDefence((Player)player);
            double wardrobeDps = StatUtils.getAverageDps(wardrobePlayer);
            double wardrobeArmor = StatUtils.getDefence(wardrobePlayer);
            double diffDps = wardrobeDps - playerDps;
            double diffArmor = wardrobeArmor - playerArmor;
            boolean bl = showDamage = Math.abs((int)diffDps) > 0;
            if (showDamage) {
                this.swapTooltip.add(this.getTooltipWithValue(diffDps, "screen.the_vault.wardrobe.tooltip.damage", "%.1f", Style.f_131099_.m_178520_(16730699)));
            }
            boolean bl2 = showDefense = Math.abs((int)(diffArmor * 100.0)) > 0;
            if (showDefense) {
                this.swapTooltip.add(this.getTooltipWithValue(diffArmor * 100.0, "screen.the_vault.wardrobe.tooltip.defense", "%.0f", Style.f_131099_.m_178520_(4766456)));
            }
            if (showDamage || showDefense) {
                this.swapTooltip.add(TextComponent.f_131282_);
            }
            ArrayList addingAttributeInstances = new ArrayList();
            ArrayList removingAttributeInstances = new ArrayList();
            HashMap mergeableAttributes = new HashMap();
            this.addEquipmentSlotsAttributes(mergeableAttributes, removingAttributeInstances, equipmentSlot -> {
                if (this.isShiftPressed || !((WardrobeContainer.Gear)this.m_6262_()).getStoredEquipmentBySlot((EquipmentSlot)equipmentSlot).m_41619_()) {
                    return this.simulateVaultGear((EquipmentSlot)equipmentSlot, player.m_6844_(equipmentSlot));
                }
                return ItemStack.f_41583_;
            }, true);
            Map<String, List<Tuple<ItemStack, Integer>>> curiosItemStacks = IntegrationCurios.getCuriosItemStacks((LivingEntity)player);
            if (!this.isShiftPressed) {
                curiosItemStacks.forEach((slotKey, tuples) -> tuples.forEach(t -> {
                    if (((WardrobeContainer.Gear)this.m_6262_()).getStoredCurio((String)slotKey, (Integer)t.m_14419_()).m_41619_()) {
                        t.m_145023_((Object)ItemStack.f_41583_);
                    }
                }));
            }
            this.addCuriosAttributes((Player)player, mergeableAttributes, removingAttributeInstances, curiosItemStacks, true);
            this.addEquipmentSlotsAttributes(mergeableAttributes, addingAttributeInstances, ((WardrobeContainer.Gear)this.m_6262_())::getStoredEquipmentBySlot, false);
            this.addCuriosAttributes((Player)player, mergeableAttributes, addingAttributeInstances, ((WardrobeContainer.Gear)this.m_6262_()).getStoredCurios(), false);
            mergeableAttributes.values().forEach(instance -> Gear.addMergeableAttribute(addingAttributeInstances, removingAttributeInstances, instance));
            addingAttributeInstances.sort(GearAttributeInstanceRegistryOrderComparator.INSTANCE);
            removingAttributeInstances.sort(GearAttributeInstanceRegistryOrderComparator.INSTANCE);
            if (removingAttributeInstances.isEmpty() && addingAttributeInstances.isEmpty()) {
                this.swapTooltip.add((Component)new TranslatableComponent("screen.the_vault.wardrobe.tooltip.no_difference").m_130940_(ChatFormatting.YELLOW));
                return;
            }
            this.swapTooltip.add((Component)new TranslatableComponent("screen.the_vault.wardrobe.tooltip.difference").m_130940_(ChatFormatting.GRAY));
            ATTRIBUTES_ORDER.keySet().forEach(attribute -> {
                addingAttributeInstances.stream().filter(instance -> ((Object)((Object)instance.getAttribute())).equals(attribute)).forEach(inst -> this.addTooltipDisplay((VaultGearAttributeInstance<?>)inst, "+", ChatFormatting.GREEN));
                removingAttributeInstances.stream().filter(instance -> ((Object)((Object)instance.getAttribute())).equals(attribute)).forEach(inst -> this.addTooltipDisplay((VaultGearAttributeInstance<?>)inst, "-", ChatFormatting.RED));
            });
        }

        private Player getPlayerWithWardrobeItemsSwapped(LocalPlayer player) {
            Map<String, List<Tuple<ItemStack, Integer>>> curiosItemStacks;
            Player gearPlayer = new Player(player.f_19853_, ((WardrobeContainer.Gear)this.m_6262_()).getBlockPos(), 0.0f, new GameProfile(null, "dummyWardrobeTooltip")){

                public boolean m_5833_() {
                    return false;
                }

                public boolean m_7500_() {
                    return false;
                }
            };
            if (this.isShiftPressed) {
                curiosItemStacks = ((WardrobeContainer.Gear)this.m_6262_()).getStoredCurios();
            } else {
                curiosItemStacks = IntegrationCurios.getCuriosItemStacks((LivingEntity)player);
                curiosItemStacks.forEach((slotKey, tuples) -> tuples.forEach(t -> {
                    ItemStack storedStack = ((WardrobeContainer.Gear)this.m_6262_()).getStoredCurio((String)slotKey, (Integer)t.m_14419_());
                    if (!storedStack.m_41619_()) {
                        t.m_145023_((Object)storedStack);
                    }
                }));
            }
            gearPlayer.m_21219_();
            player.m_21220_().forEach(arg_0 -> ((Player)gearPlayer).m_7292_(arg_0));
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                ItemStack storedEquipment;
                ItemStack itemStack = storedEquipment = equipmentSlot != EquipmentSlot.MAINHAND ? ((WardrobeContainer.Gear)this.m_6262_()).getStoredEquipmentBySlot(equipmentSlot) : ((WardrobeContainer.Gear)this.m_6262_()).getHotbarItems().getStackInSlot(0);
                if (this.isShiftPressed) {
                    this.updateItemSlot(gearPlayer, equipmentSlot, storedEquipment);
                    continue;
                }
                if (!storedEquipment.m_41619_()) {
                    this.updateItemSlot(gearPlayer, equipmentSlot, storedEquipment);
                    continue;
                }
                this.updateItemSlot(gearPlayer, equipmentSlot, player.m_6844_(equipmentSlot));
            }
            curiosItemStacks.forEach((slotKey, stacks) -> stacks.forEach(t -> IntegrationCurios.setCurioItemStack((LivingEntity)gearPlayer, (ItemStack)t.m_14418_(), slotKey, (Integer)t.m_14419_())));
            return gearPlayer;
        }

        private void updateItemSlot(Player player, EquipmentSlot equipmentSlot, ItemStack stack) {
            player.m_8061_(equipmentSlot, stack);
            stack.m_41638_(equipmentSlot).forEach((attribute, modifier) -> {
                AttributeInstance attributeInstance = player.m_21051_(attribute);
                if (attributeInstance != null) {
                    attributeInstance.m_22118_(modifier);
                }
            });
        }

        private Component getTooltipWithValue(double value, String translationKey, String format, Style style) {
            if (value > 0.0) {
                return new TextComponent("+").m_7220_((Component)new TranslatableComponent(translationKey, new Object[]{String.format(format, value)}).m_130948_(style)).m_130940_(ChatFormatting.GREEN);
            }
            return new TextComponent("-").m_7220_((Component)new TranslatableComponent(translationKey, new Object[]{String.format(format, Math.abs(value))}).m_130948_(style)).m_130940_(ChatFormatting.RED);
        }

        private static <T> void addMergeableAttribute(List<VaultGearAttributeInstance<?>> addingAttributeInstances, List<VaultGearAttributeInstance<?>> removingAttributeInstances, VaultGearAttributeInstance<T> instance) {
            AttributeTypeHandler<T> ath = WardrobeScreen.getAttributeTypeHandler(instance.getValue());
            if (ath.isZero(instance.getValue())) {
                return;
            }
            if (ath.isGreaterThanZero(instance.getValue())) {
                addingAttributeInstances.add(instance);
            } else {
                instance.setValue(ath.invert(instance.getValue()));
                removingAttributeInstances.add(instance);
            }
        }

        private void addEquipmentSlotsAttributes(Map<VaultGearAttribute<?>, VaultGearAttributeInstance<?>> mergeableAttributes, List<VaultGearAttributeInstance<?>> attributeInstances, Function<EquipmentSlot, ItemStack> getItemBySlot, boolean inverted) {
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                Object gearItem;
                Item item;
                ItemStack stack;
                if (equipmentSlot == EquipmentSlot.MAINHAND || (stack = getItemBySlot.apply(equipmentSlot)).m_41619_() || (item = (stack = this.simulateVaultGear(equipmentSlot, stack)).m_41720_()) instanceof VaultGearItem && !(gearItem = (VaultGearItem)item).isIntendedForSlot(stack, equipmentSlot) || (item = stack.m_41720_()) instanceof CuriosGearItem && !(gearItem = (CuriosGearItem)item).isIntendedSlot(stack, equipmentSlot)) continue;
                Object data = AttributeGearData.read(stack);
                if (data instanceof VaultGearData) {
                    VaultGearData gearData = (VaultGearData)data;
                    VaultGearData.Type.ALL_MODIFIERS.getAttributeSource(gearData).forEach(instance -> this.addAttribute(mergeableAttributes, attributeInstances, inverted, VaultGearAttributeInstance.cast(instance.getAttribute(), instance.getValue())));
                    continue;
                }
                ((AttributeGearData)data).getAttributes().forEach(instance -> this.addAttribute(mergeableAttributes, attributeInstances, inverted, VaultGearAttributeInstance.cast(instance.getAttribute(), instance.getValue())));
            }
        }

        private void addAttribute(Map<VaultGearAttribute<?>, VaultGearAttributeInstance<?>> mergeableAttributes, List<VaultGearAttributeInstance<?>> attributeInstances, boolean inverted, VaultGearAttributeInstance<?> instance) {
            VaultGearAttribute<?> attribute = instance.getAttribute();
            if (EXCLUDED_ATTRIBUTES.contains(attribute)) {
                return;
            }
            if (attribute.getAttributeComparator() == null) {
                attributeInstances.add(instance);
            } else {
                this.mergeAttribute(mergeableAttributes, inverted, instance, attribute);
            }
        }

        private <T> void mergeAttribute(Map<VaultGearAttribute<?>, VaultGearAttributeInstance<?>> mergeableAttributes, boolean inverted, VaultGearAttributeInstance<T> instance, VaultGearAttribute<?> attribute) {
            if (mergeableAttributes.containsKey(attribute)) {
                VaultGearAttributeInstance<?> mergeIntoInstance = mergeableAttributes.get(attribute);
                T value = instance.getValue();
                if (inverted) {
                    AttributeTypeHandler<T> ath = WardrobeScreen.getAttributeTypeHandler(value);
                    value = ath.invert(value);
                }
                mergeIntoInstance.setValue(mergeIntoInstance.getAttribute().getAttributeComparator().merge(mergeIntoInstance.getValue(), value));
            } else {
                T value = instance.getValue();
                if (inverted) {
                    AttributeTypeHandler<T> ath = WardrobeScreen.getAttributeTypeHandler(value);
                    instance.setValue(ath.invert(value));
                }
                mergeableAttributes.put(attribute, instance);
            }
        }

        private void addCuriosAttributes(Player player, Map<VaultGearAttribute<?>, VaultGearAttributeInstance<?>> mergeableAttributes, List<VaultGearAttributeInstance<?>> attributeInstances, Map<String, List<Tuple<ItemStack, Integer>>> curiosItemStacks, boolean inverted) {
            TrinketHelper.getTrinkets(curiosItemStacks, GearAttributeTrinket.class).forEach(gearTrinket -> {
                if (gearTrinket.isUsable(player)) {
                    ((GearAttributeTrinket)gearTrinket.trinket()).getAttributes().forEach(instance -> this.addAttribute(mergeableAttributes, attributeInstances, inverted, (VaultGearAttributeInstance<?>)instance));
                }
            });
            curiosItemStacks.forEach((slot, stacks) -> stacks.forEach(stackTpl -> {
                CuriosGearItem curiosGearItem;
                ItemStack stack = (ItemStack)stackTpl.m_14418_();
                if (!AttributeGearData.hasData(stack)) {
                    return;
                }
                Item patt19717$temp = stack.m_41720_();
                if (patt19717$temp instanceof CuriosGearItem && !(curiosGearItem = (CuriosGearItem)patt19717$temp).isIntendedSlot(stack, (String)slot)) {
                    return;
                }
                if (stack.m_150930_((Item)ModItems.MAGNET) && MagnetItem.isLegacy(stack)) {
                    return;
                }
                ((AttributeGearData)AttributeGearData.read(stack)).getAttributes().forEach(instance -> this.addAttribute(mergeableAttributes, attributeInstances, inverted, (VaultGearAttributeInstance<?>)instance));
            }));
        }

        private ItemStack simulateVaultGear(EquipmentSlot slot, ItemStack stack) {
            if (stack.m_41720_() instanceof VaultGearItem) {
                return stack;
            }
            Item item = stack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                ItemStack gearStack = new ItemStack((ItemLike)VaultArmorItem.forSlot(slot));
                VaultGearData data = VaultGearData.read(gearStack);
                data.setState(VaultGearState.IDENTIFIED);
                data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier<Integer>(ModGearAttributes.ARMOR, armorItem.m_40404_()));
                data.addModifier(VaultGearModifier.AffixType.IMPLICIT, new VaultGearModifier<Integer>(ModGearAttributes.ARMOR_TOUGHNESS, (int)armorItem.m_40405_()));
                data.write(gearStack);
                return gearStack;
            }
            return stack;
        }

        private void addTooltipDisplay(VaultGearAttributeInstance<?> vaultGearAttributeInstance, String prefix, ChatFormatting formatting) {
            vaultGearAttributeInstance.getDisplay(VaultGearData.read(new ItemStack((ItemLike)ModItems.BOOTS)), VaultGearModifier.AffixType.IMPLICIT, ItemStack.f_41583_, true).ifPresent(displayText -> {
                if (!prefix.isEmpty()) {
                    displayText = new TextComponent(prefix).m_130940_(formatting).m_7220_((Component)displayText);
                }
                this.swapTooltip.add((Component)displayText);
            });
        }

        @Override
        public void m_94757_(double mouseX, double mouseY) {
            super.m_94757_(mouseX, mouseY);
            if (!this.swapTooltip.isEmpty() && !this.swapButton.m_5953_(mouseX, mouseY)) {
                this.swapTooltip.clear();
            }
        }

        public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
            InputConstants.Key key = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
            if (pKeyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
                this.m_7379_();
                return true;
            }
            if (this.isShiftKey(pKeyCode) && !this.isShiftPressed) {
                this.swapTooltip.clear();
                this.isShiftPressed = true;
            }
            return super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }

        public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
            if (this.isShiftKey(pKeyCode) && this.isShiftPressed) {
                this.swapTooltip.clear();
                this.isShiftPressed = false;
            }
            return super.m_7920_(pKeyCode, pScanCode, pModifiers);
        }

        public boolean isShiftKey(int keyCode) {
            return keyCode == 340 || keyCode == 344;
        }

        private class SolidRenderButtonElement
        extends ButtonElement<SolidRenderButtonElement> {
            public SolidRenderButtonElement(IMutableSpatial position) {
                super(position, ScreenTextures.BUTTON_WARDROBE_TRANSPARENT_TEXTURES, () -> ((WardrobeContainer.Gear)Gear.this.m_6262_()).toggleSolidRender());
            }

            @Override
            public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                ButtonElement.ButtonTextures buttonTextures = ((WardrobeContainer.Gear)Gear.this.m_6262_()).shouldRenderSolid() ? ScreenTextures.BUTTON_WARDROBE_SOLID_TEXTURES : ScreenTextures.BUTTON_WARDROBE_TRANSPARENT_TEXTURES;
                TextureAtlasRegion texture = buttonTextures.selectTexture(this.isDisabled(), this.containsMouse(mouseX, mouseY), this.clickHeld);
                renderer.render(texture, poseStack, (IPosition)this.worldSpatial);
            }
        }
    }
}

