/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block.base;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.block.entity.base.ForgeRecipeTileEntity;
import iskallia.vault.client.ClientForgeRecipesData;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.CraftingSelectorElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.OutputSlotElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TextInputElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.container.spi.ForgeRecipeContainer;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.VaultForgeRequestCraftMessage;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class ForgeRecipeContainerScreen<V extends ForgeRecipeTileEntity, T extends ForgeRecipeContainer<V>>
extends AbstractElementContainerScreen<T> {
    private final ButtonElement<?> craftButton;
    private final Inventory playerInventory;
    private final CraftingSelectorElement<?> craftingSelectorElement;
    private final TextInputElement<?> levelInput;
    private VaultForgeRecipe selectedRecipe = null;

    public ForgeRecipeContainerScreen(T container, Inventory inventory, Component title, int height) {
        this(container, inventory, title, height, 176);
    }

    public ForgeRecipeContainerScreen(T container, Inventory inventory, Component title, int height, int width) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.playerInventory = inventory;
        this.setGuiSize(Spatials.size(width, height));
        Object tile = ((ForgeRecipeContainer)this.m_6262_()).getTile();
        if (tile == null) {
            this.craftButton = null;
            this.craftingSelectorElement = null;
            this.levelInput = null;
            return;
        }
        this.addBackgroundElement();
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 7), (Component)((ForgeRecipeTileEntity)((Object)tile)).m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(((ForgeRecipeContainer)this.m_6262_()).getPlayerInventoryOffset().x, height - 93), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        NonNullList normalSlots = ((ForgeRecipeContainer)this.m_6262_()).f_38839_;
        this.addElement((SlotsElement)new SlotsElement(Spatials.zero(), normalSlots.subList(0, normalSlots.size() - 1), ScreenTextures.INSET_ITEM_SLOT_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.addElement((OutputSlotElement)new OutputSlotElement(Spatials.zero(), (Slot)Iterables.getLast((Iterable)normalSlots), ScreenTextures.INSET_CRAFTING_RESULT_SLOT_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.craftingSelectorElement = this.addElement(this.createCraftingSelector());
        int offsetX = ((ForgeRecipeContainer)this.m_6262_()).getOffset().x;
        int offsetY = ((ForgeRecipeContainer)this.m_6262_()).getOffset().y;
        this.craftButton = (ButtonElement)new ButtonElement(Spatials.positionXY(this.craftingSelectorElement.right() + 3, height - 133), ScreenTextures.BUTTON_CRAFT_TEXTURES, this::onCraftClick).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(this.craftButton);
        this.craftButton.setDisabled(true);
        this.levelInput = this.addElement((TextInputElement)new TextInputElement(Spatials.positionXY(143, offsetY - 1).size(26, 12), Minecraft.m_91087_().f_91062_).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).adjustEditBox(editBox -> {
            editBox.m_94153_(input -> {
                int parsedLevel;
                if (input.isEmpty()) {
                    return true;
                }
                try {
                    parsedLevel = Integer.parseInt(input);
                }
                catch (NumberFormatException exc) {
                    return false;
                }
                return parsedLevel <= VaultBarOverlay.vaultLevel && parsedLevel <= ModConfigs.LEVELS_META.getMaxLevel();
            });
            editBox.m_94199_(3);
            editBox.m_94144_(String.valueOf(VaultBarOverlay.vaultLevel));
        });
        this.levelInput.setVisible(false);
        this.levelInput.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            if (!this.levelInput.isVisible()) {
                return false;
            }
            TextComponent cmp = new TextComponent("Level of crafted gear");
            tooltipRenderer.renderTooltip(poseStack, (Component)cmp, mouseX, mouseY, TooltipDirection.RIGHT);
            return true;
        });
    }

    protected void addBackgroundElement() {
        this.addElement((NineSliceElement)new NineSliceElement(this.getGuiSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui))));
    }

    @Nonnull
    protected abstract CraftingSelectorElement<?> createCraftingSelector();

    protected void setLevelInputVisible(boolean visible) {
        if (this.levelInput != null) {
            boolean changed = this.levelInput.isVisible() != visible;
            this.levelInput.setVisible(visible);
            if (changed && !visible) {
                this.levelInput.setInput(String.valueOf(VaultBarOverlay.vaultLevel));
            }
        }
    }

    protected int getCraftedLevel() {
        String input;
        int requestedLevel = VaultBarOverlay.vaultLevel;
        if (this.levelInput != null && !(input = this.levelInput.getInput()).isEmpty()) {
            try {
                requestedLevel = Mth.m_14045_((int)Integer.parseInt(input), (int)0, (int)Math.min(VaultBarOverlay.vaultLevel, ModConfigs.LEVELS_META.getMaxLevel()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return requestedLevel;
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.craftingSelectorElement != null) {
            this.craftButton.setDisabled(!this.craftingSelectorElement.canCraftSelectedEntry());
        }
        if (this.levelInput != null) {
            this.levelInput.tickEditBox();
        }
    }

    protected CraftingSelectorElement<?> makeCraftingSelector() {
        return this.makeCraftingSelector(ObservableSupplier.empty());
    }

    protected CraftingSelectorElement<?> makeCraftingSelector(ObservableSupplier<Set<ResourceLocation>> discoveredRecipes) {
        if (this.craftingSelectorElement != null) {
            return this.craftingSelectorElement;
        }
        int slotWidth = 0;
        List<VaultForgeRecipe> recipes = Collections.emptyList();
        Object tile = ((ForgeRecipeContainer)this.m_6262_()).getTile();
        if (tile != null) {
            recipes = ClientForgeRecipesData.getRecipes(((ForgeRecipeTileEntity)((Object)tile)).getSupportedRecipeTypes());
            slotWidth = Mth.m_14167_((float)((float)((ForgeRecipeTileEntity)((Object)tile)).getInventory().m_6643_() / 3.0f));
        }
        int offsetX = ((ForgeRecipeContainer)this.m_6262_()).getOffset().x;
        return (CraftingSelectorElement)new CraftingSelectorElement(Spatials.positionXY(offsetX + slotWidth * 18 + 3, this.f_97727_ - 151).height(54), 3, recipes, discoveredRecipes, this::onRecipeSelect, this::getMissingRecipeInputs).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    private void onCraftClick() {
        if (this.selectedRecipe != null) {
            ModNetwork.CHANNEL.sendToServer((Object)new VaultForgeRequestCraftMessage(this.selectedRecipe.getId(), this.getCraftedLevel()));
        }
    }

    protected void onRecipeSelect(VaultForgeRecipe recipe, boolean canCraft) {
        this.craftButton.setDisabled(!canCraft);
        this.selectedRecipe = recipe;
        this.setLevelInputVisible(recipe.usesLevel());
    }

    protected List<ItemStack> getMissingRecipeInputs(List<ItemStack> inputs) {
        Object tile = ((ForgeRecipeContainer)this.f_97732_).getTile();
        if (tile == null) {
            return inputs;
        }
        return InventoryUtil.getMissingInputs(inputs, this.getPlayerInventory(), ((ForgeRecipeTileEntity)((Object)tile)).getInventory());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.levelInput != null && this.levelInput.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            if (this.levelInput == null || !this.levelInput.isFocused()) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.levelInput != null && this.levelInput.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }
}

