/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.bounty.element.task;

import iskallia.vault.bounty.task.ItemSubmissionTask;
import iskallia.vault.bounty.task.properties.ItemSubmissionProperties;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.screen.bounty.element.BountyElement;
import iskallia.vault.client.gui.screen.bounty.element.task.AbstractTaskElement;
import iskallia.vault.util.TextUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemSubmissionTaskElement
extends AbstractTaskElement<ItemSubmissionTask> {
    protected ItemSubmissionTaskElement(ISpatial spatial, ItemSubmissionTask task, BountyElement.Status status) {
        super(spatial, task, status);
    }

    @Override
    protected float getProgressPercentage() {
        return (float)(this.getAmountObtained() / this.getAmountRequired());
    }

    @Override
    protected double getAmountRequired() {
        return ((ItemSubmissionProperties)((ItemSubmissionTask)this.getTask()).getProperties()).getAmount();
    }

    @Override
    protected double getAmountObtained() {
        return ((ItemSubmissionTask)this.getTask()).getAmountObtained();
    }

    @Override
    public List<MutableComponent> getDescription() {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        DecimalFormat df = new DecimalFormat("0");
        ResourceLocation itemId = ((ItemSubmissionProperties)((ItemSubmissionTask)this.getTask()).getProperties()).getItemId();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        TextComponent name = item == null ? TextUtil.formatLocationPathAsProperNoun(itemId) : (MutableComponent)item.m_41466_();
        components.add(new TextComponent("Submit ").m_7220_((Component)new TextComponent(df.format(((ItemSubmissionProperties)((ItemSubmissionTask)this.getTask()).getProperties()).getAmount()) + "x ")).m_7220_((Component)name).m_130946_(" at the Bounty Table"));
        return components;
    }

    @Override
    protected MutableComponent getTargetDisplayName() {
        ResourceLocation itemId = ((ItemSubmissionProperties)((ItemSubmissionTask)this.getTask()).getProperties()).getItemId();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        return item == null ? TextUtil.formatLocationPathAsProperNoun(itemId) : (MutableComponent)item.m_41466_();
    }

    @Override
    protected List<Component> getExtendedDisplay() {
        ResourceLocation itemId = ((ItemSubmissionProperties)((ItemSubmissionTask)this.getTask()).getProperties()).getItemId();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        return new ItemStack((ItemLike)item).m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.ADVANCED);
    }
}

