/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.component.ScrollableContainer;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.AbilitiesElementContainerScreen;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.spi.AbstractDialog;
import iskallia.vault.client.gui.screen.player.legacy.widget.AbilityNodeTextures;
import iskallia.vault.client.gui.screen.player.legacy.widget.AbilityWidget;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.network.message.AbilityLevelMessage;
import iskallia.vault.network.message.AbilitySelectSpecializationMessage;
import iskallia.vault.skill.ability.component.AbilityDescriptionFactory;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.AbilityTree;
import java.awt.Rectangle;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class AbilityDialog
extends AbstractDialog<AbilitiesElementContainerScreen> {
    private final AbilityTree abilityTree;
    private MutableComponent descriptionContentComponent;
    private String selectedAbility = null;
    private String prevSelectedAbility = null;
    private int prevAbilityLevel = -1;
    private AbilityWidget selectedAbilityWidget = null;

    public AbilityDialog(AbilityTree abilityTree, AbilitiesElementContainerScreen skillTreeScreen) {
        super(skillTreeScreen);
        this.abilityTree = abilityTree;
    }

    @Override
    public void update() {
        boolean activeState;
        Button.OnPress pressAction;
        Object buttonText;
        if (this.selectedAbility == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        TieredSkill ability = this.abilityTree.getForId(this.selectedAbility).orElse(null);
        if (ability == null) {
            return;
        }
        SpecializedSkill existing = (SpecializedSkill)ability.getParent();
        boolean isSpecialization = existing.getIndex() != 0;
        this.selectedAbilityWidget = new AbilityWidget(this.selectedAbility, this.abilityTree, 0, 0, isSpecialization ? AbilityNodeTextures.SECONDARY_NODE : AbilityNodeTextures.PRIMARY_NODE, TextureAtlasRegion.of(ModTextureAtlases.ABILITIES, ModConfigs.ABILITIES_GUI.getIcon(this.selectedAbility)));
        SpecializedSkill current = this.selectedAbilityWidget.getAbilityGroup();
        SpecializedSkill target = this.selectedAbilityWidget.makeAbilityNode();
        if (target.getIndex() != 0) {
            buttonText = "Select Specialization";
            pressAction = button -> this.selectSpecialization();
            activeState = existing.getIndex() == 0 && (existing.isUnlocked() || target.isUnlocked()) && VaultBarOverlay.vaultLevel >= target.getUnlockLevel();
            this.regretButton = null;
        } else {
            buttonText = !target.isUnlocked() ? "Learn (" + current.getLearnPointCost() + ")" : (((TieredSkill)existing.getSpecialization()).getUnmodifiedTier() >= ((TieredSkill)target.getSpecialization()).getMaxLearnableTier() ? "Fully Learned" : "Upgrade (" + current.getSpecialization().getLearnPointCost() + ")");
            pressAction = button -> this.upgradeAbility();
            int cost = current.getSpecialization().getLearnPointCost();
            int regretCost = existing.isUnlocked() ? existing.getRegretPointCost() : 0;
            activeState = cost <= VaultBarOverlay.unspentSkillPoints && ((TieredSkill)existing.getSpecialization()).getUnmodifiedTier() < ((TieredSkill)target.getSpecialization()).getMaxLearnableTier() && ((TieredSkill)target.getSpecialization()).getUnmodifiedTier() < ((TieredSkill)target.getSpecialization()).getMaxLearnableTier() + 1 && VaultBarOverlay.vaultLevel >= current.getUnlockLevel();
            Object regretButtonText = !existing.isUnlocked() ? "Unlearn" : "Unlearn (" + regretCost + ")";
            boolean hasDependants = false;
            if (((TieredSkill)existing.getSpecialization()).getUnmodifiedTier() == 1) {
                List<String> dependentNodes = ModConfigs.SKILL_GATES.getGates().getAbilitiesDependingOn(existing.getId());
                for (String dependent : dependentNodes) {
                    if (!this.abilityTree.getForId(dependent).map(Skill::isUnlocked).orElse(false).booleanValue()) continue;
                    hasDependants = true;
                    break;
                }
            }
            this.regretButton = new Button(0, 0, 0, 0, (Component)new TextComponent((String)regretButtonText), button -> this.downgradeAbility(), Button.f_93716_);
            this.regretButton.f_93623_ = existing.isUnlocked() && regretCost <= VaultBarOverlay.unspentRegretPoints && ((TieredSkill)existing.getSpecialization()).getUnmodifiedTier() > 0 && !hasDependants;
        }
        int descriptionTier = ((TieredSkill)current.getSpecialization()).getActualTier();
        if (!Objects.equals(this.selectedAbility, this.prevSelectedAbility) || this.prevAbilityLevel != descriptionTier) {
            int descriptionMaxTier = Math.max(((TieredSkill)current.getSpecialization()).getMaxLearnableTier(), descriptionTier);
            this.descriptionComponent = new ScrollableContainer(this::renderDescriptions);
            this.descriptionContentComponent = AbilityDescriptionFactory.create((TieredSkill)target.getSpecialization(), descriptionTier, descriptionMaxTier, VaultBarOverlay.vaultLevel);
            this.prevSelectedAbility = this.selectedAbility;
            this.prevAbilityLevel = descriptionTier;
        }
        this.learnButton = new Button(0, 0, 0, 0, (Component)new TextComponent((String)buttonText), pressAction, Button.f_93716_);
        this.learnButton.f_93623_ = activeState;
    }

    public void setAbilityWidget(String abilityName) {
        this.selectedAbility = abilityName;
        this.update();
    }

    private void upgradeAbility() {
        TieredSkill ability = this.abilityTree.getForId(this.selectedAbility).orElse(null);
        if (ability.getUnmodifiedTier() >= ability.getMaxLearnableTier()) {
            return;
        }
        Minecraft.m_91087_().f_91074_.m_5496_(ability.isUnlocked() ? ModSounds.SKILL_TREE_UPGRADE_SFX : ModSounds.SKILL_TREE_LEARN_SFX, 1.0f, 1.0f);
        ((SpecializedSkill)ability.getParent()).learn(SkillContext.ofClient());
        this.update();
        ModNetwork.CHANNEL.sendToServer((Object)new AbilityLevelMessage(ability.getParent().getId(), true));
    }

    private void downgradeAbility() {
        TieredSkill ability = this.abilityTree.getForId(this.selectedAbility).orElse(null);
        if (ability == null) {
            return;
        }
        SpecializedSkill group = (SpecializedSkill)ability.getParent();
        if (!group.isUnlocked()) {
            return;
        }
        Minecraft.m_91087_().f_91074_.m_5496_(ModSounds.SKILL_TREE_UPGRADE_SFX, 1.0f, 1.0f);
        group.regret(SkillContext.ofClient());
        this.update();
        ModNetwork.CHANNEL.sendToServer((Object)new AbilityLevelMessage(group.getId(), false));
    }

    private void selectSpecialization() {
        SpecializedSkill targetNode = this.selectedAbilityWidget.makeAbilityNode();
        SpecializedSkill existingNode = this.abilityTree.getForId(this.selectedAbility).map(Skill::getParent).orElse(null);
        String toSelect = targetNode.getSpecialization().getId();
        String abilityName = existingNode.getId();
        if (existingNode.getIndex() != 0 && targetNode.getId().equals(existingNode.getId())) {
            return;
        }
        if (VaultBarOverlay.vaultLevel < targetNode.getUnlockLevel()) {
            return;
        }
        Minecraft.m_91087_().f_91074_.m_5496_(ModSounds.SKILL_TREE_UPGRADE_SFX, 1.0f, 1.0f);
        this.abilityTree.specialize(toSelect, SkillContext.ofClient());
        ((AbilitiesElementContainerScreen)this.skillTreeScreen).update();
        ModNetwork.CHANNEL.sendToServer((Object)new AbilitySelectSpecializationMessage(abilityName, toSelect));
    }

    @Override
    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        if (this.selectedAbility == null || this.selectedAbilityWidget == null) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(this.bounds.x + 5), (double)(this.bounds.y + 5), 0.0);
        this.renderHeading(matrixStack, mouseX, mouseY, partialTicks);
        this.descriptionComponent.setBounds(this.getDescriptionsBounds());
        this.descriptionComponent.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderFooter(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
    }

    private void renderHeading(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Object subText;
        String abilityName;
        boolean learned;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenTextures.UI_RESOURCE);
        SpecializedSkill targetAbilityNode = this.selectedAbilityWidget.makeAbilityNode();
        SpecializedSkill currentAbilityNode = this.abilityTree.getForId(targetAbilityNode.getId()).orElse(null);
        if (targetAbilityNode.getIndex() != 0) {
            learned = targetAbilityNode.getIndex() == currentAbilityNode.getIndex();
            abilityName = targetAbilityNode.getSpecialization().getName();
            subText = learned ? "Selected" : "Not selected";
        } else {
            learned = targetAbilityNode.isUnlocked();
            abilityName = targetAbilityNode.getSpecialization().getName();
            if (!learned) {
                subText = "Not learned yet";
            } else {
                int actualTier;
                int diff;
                TieredSkill tierSkill = (TieredSkill)currentAbilityNode.getSpecialization();
                int currentTier = tierSkill.getUnmodifiedTier();
                Object addedLevel = "";
                if (Minecraft.m_91087_().f_91074_ != null && (diff = (actualTier = tierSkill.getActualTier()) - currentTier) != 0) {
                    addedLevel = " " + (diff > 0 ? "+" : "") + diff;
                }
                subText = "Level: " + currentTier + "/" + tierSkill.getMaxLearnableTier() + (String)addedLevel;
            }
        }
        int width = this.selectedAbilityWidget.m_5711_();
        UIHelper.renderContainerBorder(this, matrixStack, this.getHeadingBounds(), 14, 44, 2, 2, 2, 2, -7631989);
        int gap = 5;
        matrixStack.m_85836_();
        matrixStack.m_85837_(10.0, 0.0, 0.0);
        FontHelper.drawStringWithBorder(matrixStack, abilityName, (float)(width + gap), 13.0f, !learned ? -1 : -1849, !learned ? -16777216 : -12897536);
        FontHelper.drawStringWithBorder(matrixStack, (String)subText, (float)(width + gap), 23.0f, !learned ? -1 : -1849, !learned ? -16777216 : -12897536);
        matrixStack.m_85837_((double)((float)width / 2.0f), 0.0, 0.0);
        matrixStack.m_85837_(0.0, 23.0, 0.0);
        this.selectedAbilityWidget.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
    }

    private void renderDescriptions(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Rectangle bounds = this.descriptionComponent.getRenderableBounds();
        int renderedLineCount = UIHelper.renderWrappedText(matrixStack, (Component)this.descriptionContentComponent, bounds.width, 10);
        this.descriptionComponent.setInnerHeight(renderedLineCount * 10 + 20);
        RenderSystem.m_69482_();
    }

    private void renderFooter(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int containerX = mouseX - this.bounds.x - 5;
        int containerY = mouseY - this.bounds.y - 5;
        this.learnButton.m_6305_(matrixStack, containerX, containerY, partialTicks);
        if (this.regretButton != null) {
            this.regretButton.m_6305_(matrixStack, containerX, containerY, partialTicks);
        }
    }
}

