/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.component.ScrollableContainer;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.legacy.LegacySkillTreeElementContainerScreen;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.spi.AbstractDialog;
import iskallia.vault.client.gui.screen.player.legacy.widget.SkillWidget;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.base.GroupedSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.SkillTree;
import java.awt.Rectangle;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class SkillDialog<T extends SkillTree, S extends LegacySkillTreeElementContainerScreen<T>>
extends AbstractDialog<S> {
    protected final T skilTree;
    protected TieredSkill skillGroup = null;
    protected SkillWidget<T> skillWidget = null;

    protected SkillDialog(T skillTree, S skillTreeScreen) {
        super(skillTreeScreen);
        this.skilTree = skillTree;
    }

    @Override
    public void update() {
        if (this.skillGroup != null) {
            SkillStyle abilityStyle = this.getStyles().get(this.skillGroup.getId());
            this.skillWidget = new SkillWidget<T>(this.skilTree, (Component)new TextComponent("the_vault.widgets.skill"), this.skillGroup, abilityStyle);
            this.skillWidget.setRenderPips(false);
            int cost = this.skillGroup.getLearnPointCost();
            String levelUpText = !this.skillGroup.isUnlocked() ? "Learn (" + this.skillGroup.getLearnPointCost() + ")" : (this.skillGroup.getUnmodifiedTier() >= this.skillGroup.getMaxLearnableTier() ? "Learned" : "Upgrade (" + cost + ")");
            this.learnButton = new Button(0, 0, 0, 0, (Component)new TextComponent(levelUpText), button -> this.upgradeSkill(), Button.f_93716_);
            this.descriptionComponent = new ScrollableContainer(this::renderDescriptions);
            boolean isLocked = this.isSkillLocked();
            boolean fulfillsRequirements = VaultBarOverlay.vaultLevel >= this.skillGroup.getUnlockLevel();
            Skill skill = this.skillGroup.getParent();
            if (skill instanceof GroupedSkill) {
                GroupedSkill grouped = (GroupedSkill)skill;
                grouped.select(this.skillGroup.getId());
                fulfillsRequirements &= grouped.canLearn(SkillContext.ofClient());
            }
            this.learnButton.f_93623_ = cost <= this.getUnspentSkillPoints() && fulfillsRequirements && !isLocked && this.skillGroup.getUnmodifiedTier() < this.skillGroup.getMaxLearnableTier();
            this.updateRegretButton();
        }
    }

    protected abstract int getUnspentSkillPoints();

    protected abstract void updateRegretButton();

    protected boolean isSkillLocked() {
        return ModConfigs.SKILL_GATES.getGates().isLocked(this.skillGroup.getId(), (SkillTree)this.skilTree);
    }

    protected abstract HashMap<String, SkillStyle> getStyles();

    private void upgradeSkill() {
        if (this.skillGroup.getUnmodifiedTier() >= this.skillGroup.getMaxLearnableTier()) {
            return;
        }
        if (VaultBarOverlay.vaultLevel < this.skillGroup.getUnlockLevel()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            minecraft.f_91074_.m_5496_(this.skillGroup.isUnlocked() ? ModSounds.SKILL_TREE_UPGRADE_SFX : ModSounds.SKILL_TREE_LEARN_SFX, 1.0f, 1.0f);
        }
        this.skillGroup.learn(this.getSkillContext());
        this.update();
        this.sendUpgradeMessage();
    }

    protected abstract SkillContext getSkillContext();

    protected abstract void sendUpgradeMessage();

    public void setSkillGroup(TieredSkill skillGroup) {
        this.skillGroup = skillGroup;
        this.update();
    }

    private void renderDescriptions(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Rectangle renderableBounds = this.descriptionComponent.getRenderableBounds();
        TextComponent text = new TextComponent("");
        text.m_7220_((Component)ModConfigs.SKILL_DESCRIPTIONS.getDescriptionFor(this.skillGroup.getId()));
        text.m_130946_("\n\n").m_7220_(this.getAdditionalDescription(this.skillGroup));
        int renderedLineCount = UIHelper.renderWrappedText(matrixStack, (Component)text, renderableBounds.width, 10);
        this.descriptionComponent.setInnerHeight(renderedLineCount * 10 + 20);
        RenderSystem.m_69482_();
    }

    private Component getAdditionalDescription(TieredSkill skillGroup) {
        String arrow = String.valueOf('\u25b6');
        MutableComponent costArrowTxt = new TextComponent(" " + arrow + " ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x484847)));
        MutableComponent lvlReqArrowTxt = new TextComponent(" " + arrow + " ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x484847)));
        MutableComponent txt = new TextComponent("Cost: ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x484847)));
        for (int lvl = 1; lvl <= skillGroup.getMaxLearnableTier(); ++lvl) {
            if (lvl > 1) {
                txt.m_7220_((Component)costArrowTxt);
            }
            int cost = skillGroup.getChild(lvl).getLearnPointCost();
            txt.m_7220_((Component)new TextComponent(String.valueOf(cost)).m_130940_(ChatFormatting.WHITE));
        }
        boolean displayRequirements = false;
        TextComponent lvlReq = new TextComponent("\n\nLevel requirement: ");
        for (int lvl = 1; lvl <= skillGroup.getMaxLearnableTier(); ++lvl) {
            if (lvl > 1) {
                lvlReq.m_7220_((Component)lvlReqArrowTxt);
            }
            int levelRequirement = skillGroup.getChild(lvl).getUnlockLevel();
            TextComponent lvlReqPart = new TextComponent(String.valueOf(levelRequirement));
            if (VaultBarOverlay.vaultLevel < levelRequirement) {
                lvlReqPart.m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x7E0000)));
            } else {
                lvlReqPart.m_130940_(ChatFormatting.WHITE);
            }
            lvlReq.m_7220_((Component)lvlReqPart);
            if (levelRequirement <= 0) continue;
            displayRequirements = true;
        }
        if (displayRequirements) {
            txt.m_7220_((Component)lvlReq);
        } else {
            txt.m_7220_((Component)new TextComponent("\n\nNo Level requirements"));
        }
        return txt;
    }

    @Override
    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85836_();
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        if (this.skillGroup == null) {
            return;
        }
        matrixStack.m_85837_((double)(this.bounds.x + 5), (double)(this.bounds.y + 5), 0.0);
        this.renderHeading(matrixStack, mouseX, mouseY, partialTicks);
        this.descriptionComponent.setBounds(this.getDescriptionsBounds());
        this.descriptionComponent.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderFooter(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
    }

    private void renderHeading(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenTextures.UI_RESOURCE);
        SkillStyle style = this.getStyles().get(this.skillGroup.getId());
        Rectangle widgetBounds = this.skillWidget.getClickableBounds();
        UIHelper.renderContainerBorder(this, matrixStack, this.getHeadingBounds(), 14, 44, 2, 2, 2, 2, -7631989);
        String abilityName = this.skillGroup.getName();
        String subText = !this.skillGroup.isUnlocked() ? "Not Learned Yet" : "Level: " + this.skillGroup.getUnmodifiedTier() + "/" + this.skillGroup.getMaxLearnableTier();
        int gap = 5;
        matrixStack.m_85836_();
        matrixStack.m_85837_(10.0, 0.0, 0.0);
        FontHelper.drawStringWithBorder(matrixStack, abilityName, (float)(widgetBounds.width + gap), 13.0f, !this.skillGroup.isUnlocked() ? -1 : -1849, !this.skillGroup.isUnlocked() ? -16777216 : -12897536);
        FontHelper.drawStringWithBorder(matrixStack, subText, (float)(widgetBounds.width + gap), 23.0f, !this.skillGroup.isUnlocked() ? -1 : -1849, !this.skillGroup.isUnlocked() ? -16777216 : -12897536);
        matrixStack.m_85837_((double)(-style.x), (double)(-style.y), 0.0);
        matrixStack.m_85837_(widgetBounds.getWidth() / 2.0, 0.0, 0.0);
        matrixStack.m_85837_(0.0, 23.0, 0.0);
        this.skillWidget.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
    }

    protected void renderFooter(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int containerX = mouseX - this.bounds.x - 5;
        int containerY = mouseY - this.bounds.y - 5;
        this.learnButton.m_6305_(matrixStack, containerX, containerY, partialTicks);
        this.renderRegretButton(matrixStack, partialTicks, containerX, containerY);
    }

    protected void renderRegretButton(PoseStack matrixStack, float partialTicks, int containerX, int containerY) {
    }
}

