/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.TalentsElementContainerScreen;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog.SkillDialog;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.TalentLevelMessage;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.TalentTree;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class TalentDialog
extends SkillDialog<TalentTree, TalentsElementContainerScreen> {
    public TalentDialog(TalentTree talentTree, TalentsElementContainerScreen skillTreeScreen) {
        super(talentTree, skillTreeScreen);
    }

    @Override
    protected int getUnspentSkillPoints() {
        return VaultBarOverlay.unspentSkillPoints;
    }

    @Override
    protected void updateRegretButton() {
        int regretCost = this.skillGroup.getRegretPointCost();
        boolean hasDependants = false;
        if (this.skillGroup.getUnmodifiedTier() == 1) {
            List<String> dependentNodes = ModConfigs.SKILL_GATES.getGates().getSkillsDependingOn(this.skillGroup.getId(), this.skilTree);
            for (String dependent : dependentNodes) {
                if (!((TalentTree)this.skilTree).getForId(dependent).map(Skill::isUnlocked).orElse(false).booleanValue()) continue;
                hasDependants = true;
                break;
            }
        }
        Object regretText = !this.skillGroup.isUnlocked() ? "Unlearn" : "Unlearn (" + regretCost + ")";
        this.regretButton = new Button(0, 0, 0, 0, (Component)new TextComponent((String)regretText), button -> this.unlearnTalent(), Button.f_93716_);
        this.regretButton.f_93623_ = regretCost <= VaultBarOverlay.unspentRegretPoints && this.skillGroup.isUnlocked() && !this.isSkillLocked() && !hasDependants;
    }

    @Override
    protected HashMap<String, SkillStyle> getStyles() {
        return ModConfigs.TALENTS_GUI.getStyles();
    }

    @Override
    protected SkillContext getSkillContext() {
        return SkillContext.ofClient();
    }

    private void unlearnTalent() {
        if (!this.skillGroup.isUnlocked()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            minecraft.f_91074_.m_5496_(ModSounds.SKILL_TREE_UPGRADE_SFX, 1.0f, 1.0f);
        }
        this.skillGroup.regret(SkillContext.ofClient());
        this.update();
        ModNetwork.CHANNEL.sendToServer((Object)new TalentLevelMessage(this.skillGroup.getId(), false));
    }

    @Override
    protected void renderRegretButton(PoseStack matrixStack, float partialTicks, int containerX, int containerY) {
        this.regretButton.m_6305_(matrixStack, containerX, containerY, partialTicks);
    }

    @Override
    protected void sendUpgradeMessage() {
        ModNetwork.CHANNEL.sendToServer((Object)new TalentLevelMessage(this.skillGroup.getId(), true));
    }
}

