/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.pan;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.screen.player.AbilitiesElementContainerScreen;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog.AbilityDialog;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.spi.AbstractPanRegion;
import iskallia.vault.client.gui.screen.player.legacy.widget.AbilityNodeTextures;
import iskallia.vault.client.gui.screen.player.legacy.widget.AbilityWidgetSelectable;
import iskallia.vault.config.AbilitiesGUIConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.MiscUtils;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class AbilityPanRegion
extends AbstractPanRegion<AbilitiesElementContainerScreen> {
    private final Map<String, AbilityWidgetSelectable> abilityWidgets = new HashMap<String, AbilityWidgetSelectable>();
    private final AbilityDialog abilityDialog;
    private AbilityWidgetSelectable selectedWidget;

    public AbilityPanRegion(AbilityDialog abilityDialog, AbilitiesElementContainerScreen parentScreen) {
        super(parentScreen, (Component)new TextComponent("Abilities Tab"));
        this.abilityDialog = abilityDialog;
    }

    @Override
    protected AbstractPanRegion.CenterButton createCenterButton() {
        return null;
    }

    @Override
    protected Collection<? extends AbstractWidget> getWidgets() {
        return this.abilityWidgets.values();
    }

    @Override
    public void update() {
        this.abilityWidgets.clear();
        AbilityTree abilityTree = ((AbilitiesElementContainerScreen)this.parentScreen).getAbilityTree();
        for (Map.Entry<String, AbilitiesGUIConfig.AbilityStyle> abilityEntry : ModConfigs.ABILITIES_GUI.getStyles().entrySet()) {
            AbilitiesGUIConfig.AbilityStyle abilityStyle = abilityEntry.getValue();
            int index = 0;
            for (Map.Entry<String, AbilitiesGUIConfig.SpecializationStyle> specializationEntry : abilityStyle.getSpecializationStyles().entrySet()) {
                String specializationName = specializationEntry.getKey();
                if (index == 0) {
                    this.abilityWidgets.put(specializationName, new AbilityWidgetSelectable(specializationName, abilityTree, abilityStyle.getX(), abilityStyle.getY(), AbilityNodeTextures.PRIMARY_NODE, TextureAtlasRegion.of(ModTextureAtlases.ABILITIES, specializationEntry.getValue().getIcon())));
                } else {
                    this.abilityWidgets.put(specializationName, new AbilityWidgetSelectable(specializationName, abilityTree, abilityStyle.getX(), abilityStyle.getY() + 2 + 23 * index, AbilityNodeTextures.SECONDARY_NODE, TextureAtlasRegion.of(ModTextureAtlases.ABILITIES, specializationEntry.getValue().getIcon())));
                }
                ++index;
            }
        }
        this.loadViewportTransforms(false);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        Point2D.Float midpoint = MiscUtils.getMidpoint(this.getBounds());
        int containerMouseX = (int)((mouseX - (double)midpoint.x) / (double)this.viewportScale - (double)this.viewportTranslation.f_82470_);
        int containerMouseY = (int)((mouseY - (double)midpoint.y) / (double)this.viewportScale - (double)this.viewportTranslation.f_82471_);
        boolean abilityWidgetClicked = false;
        for (AbilityWidgetSelectable abilityWidget : this.abilityWidgets.values()) {
            if (!abilityWidget.m_5953_(containerMouseX, containerMouseY) || !abilityWidget.m_6375_(containerMouseX, containerMouseY, button)) continue;
            if (this.selectedWidget != null) {
                this.selectedWidget.deselect();
            }
            this.selectedWidget = abilityWidget;
            this.selectedWidget.select();
            this.abilityDialog.setAbilityWidget(this.selectedWidget.getAbilityName());
            abilityWidgetClicked = true;
            break;
        }
        return abilityWidgetClicked;
    }

    @Override
    protected void calculateViewportTranslation(double mouseX, double mouseY) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (AbstractWidget abstractWidget : this.getWidgets()) {
            if (abstractWidget.f_93620_ < minX) {
                minX = abstractWidget.f_93620_;
            }
            if (abstractWidget.f_93620_ <= maxX) continue;
            maxX = abstractWidget.f_93620_;
        }
        float dx = (float)(mouseX - (double)this.grabbedPos.f_82470_) / this.viewportScale;
        this.viewportTranslation = new Vec2(Mth.m_14036_((float)(this.viewportTranslation.f_82470_ + dx), (float)(-maxX), (float)(-minX)), this.viewportTranslation.f_82471_);
        this.saveViewportTransforms();
    }

    @Override
    protected float clampViewportScale(float viewportScale) {
        return Mth.m_14036_((float)viewportScale, (float)1.0f, (float)5.0f);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (AbstractWidget abstractWidget : this.getWidgets()) {
            if (abstractWidget.f_93620_ < minX) {
                minX = abstractWidget.f_93620_;
            }
            if (abstractWidget.f_93620_ <= maxX) continue;
            maxX = abstractWidget.f_93620_;
        }
        this.viewportTranslation = new Vec2((float)Mth.m_14008_((double)((double)this.viewportTranslation.f_82470_ + delta * 16.0), (double)(-maxX), (double)(-minX)), this.viewportTranslation.f_82471_);
        this.saveViewportTransforms();
        return false;
    }

    @Override
    public void renderTabForeground(PoseStack renderStack, Rectangle containerBounds, int mouseX, int mouseY, float pTicks, List<Runnable> postContainerRender) {
        RenderSystem.m_69478_();
        Point2D.Float midpoint = MiscUtils.getMidpoint(this.getBounds());
        renderStack.m_85836_();
        renderStack.m_85837_((double)Math.round(this.viewportTranslation.f_82470_ + midpoint.x), (double)Math.round(this.viewportTranslation.f_82471_ + midpoint.y), 0.0);
        int containerMouseX = (int)(((float)mouseX - midpoint.x) / this.viewportScale - this.viewportTranslation.f_82470_);
        int containerMouseY = (int)(((float)mouseY - midpoint.y) / this.viewportScale - this.viewportTranslation.f_82471_);
        for (AbilityWidgetSelectable abilityWidget : this.abilityWidgets.values()) {
            abilityWidget.renderWidget(renderStack, containerBounds, mouseX, mouseY, containerMouseX, containerMouseY, pTicks, postContainerRender);
        }
        renderStack.m_85849_();
    }
}

