/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.pan;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.screen.player.ArchetypesElementContainerScreen;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog.ArchetypeDialog;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.spi.AbstractPanRegion;
import iskallia.vault.client.gui.screen.player.legacy.widget.ArchetypeNodeTextures;
import iskallia.vault.client.gui.screen.player.legacy.widget.ArchetypeWidgetSelectable;
import iskallia.vault.config.ArchetypeGUIConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.skill.archetype.ArchetypeContainer;
import iskallia.vault.util.MiscUtils;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class ArchetypePanRegion
extends AbstractPanRegion<ArchetypesElementContainerScreen> {
    private final Map<ResourceLocation, ArchetypeWidgetSelectable> widgetMap = new HashMap<ResourceLocation, ArchetypeWidgetSelectable>();
    private final ArchetypeDialog dialog;
    private ArchetypeWidgetSelectable selectedWidget;

    public ArchetypePanRegion(ArchetypeDialog dialog, ArchetypesElementContainerScreen parentScreen) {
        super(parentScreen, (Component)new TextComponent("Archetypes Tab"));
        this.dialog = dialog;
    }

    @Override
    protected AbstractPanRegion.CenterButton createCenterButton() {
        return null;
    }

    @Override
    protected Collection<? extends AbstractWidget> getWidgets() {
        return this.widgetMap.values();
    }

    @Override
    public void update() {
        this.widgetMap.clear();
        ArchetypeContainer archetypeContainer = ((ArchetypesElementContainerScreen)this.parentScreen).getArchetypeContainer();
        for (Map.Entry<ResourceLocation, ArchetypeGUIConfig.ArchetypeStyle> entry : ModConfigs.ARCHETYPES_GUI.getStyles().entrySet()) {
            ArchetypeWidgetSelectable.IIconRenderer iconRenderer;
            ArchetypeGUIConfig.ArchetypeStyle style = entry.getValue();
            if (style.getIcon().m_135815_().equals("builtin/player_face")) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                iconRenderer = ArchetypeWidgetSelectable.PlayerFaceIconRenderer.of(player == null ? null : player.m_5446_().getString(), 48, 1, -16777216);
            } else {
                TextureAtlasRegion icon = TextureAtlasRegion.of(ModTextureAtlases.ARCHETYPES, style.getIcon());
                iconRenderer = ArchetypeWidgetSelectable.TextureAtlasRegionIconRenderer.of(icon);
            }
            this.widgetMap.put(entry.getKey(), new ArchetypeWidgetSelectable(entry.getKey(), () -> archetypeContainer.getCurrentArchetype().getRegistryName(), style.getX(), style.getY(), ArchetypeNodeTextures.NODE, iconRenderer));
        }
        this.loadViewportTransforms(false);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        Point2D.Float midpoint = MiscUtils.getMidpoint(this.getBounds());
        int containerMouseX = (int)((mouseX - (double)midpoint.x) / (double)this.viewportScale - (double)this.viewportTranslation.f_82470_);
        int containerMouseY = (int)((mouseY - (double)midpoint.y) / (double)this.viewportScale - (double)this.viewportTranslation.f_82471_);
        boolean abilityWidgetClicked = false;
        for (ArchetypeWidgetSelectable widget : this.widgetMap.values()) {
            if (!widget.m_5953_(containerMouseX, containerMouseY) || !widget.m_6375_(containerMouseX, containerMouseY, button)) continue;
            if (this.selectedWidget != null) {
                this.selectedWidget.deselect();
            }
            this.selectedWidget = widget;
            this.selectedWidget.select();
            this.dialog.setWidget(this.selectedWidget.getArchetypeId());
            abilityWidgetClicked = true;
            break;
        }
        return abilityWidgetClicked;
    }

    @Override
    protected void calculateViewportTranslation(double mouseX, double mouseY) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (AbstractWidget abstractWidget : this.getWidgets()) {
            if (abstractWidget.f_93620_ < minX) {
                minX = abstractWidget.f_93620_;
            }
            if (abstractWidget.f_93620_ <= maxX) continue;
            maxX = abstractWidget.f_93620_;
        }
        float dx = (float)(mouseX - (double)this.grabbedPos.f_82470_) / this.viewportScale;
        this.viewportTranslation = new Vec2(Mth.m_14036_((float)(this.viewportTranslation.f_82470_ + dx), (float)(-maxX), (float)(-minX)), this.viewportTranslation.f_82471_);
        this.saveViewportTransforms();
    }

    @Override
    protected float clampViewportScale(float viewportScale) {
        return Mth.m_14036_((float)viewportScale, (float)1.0f, (float)5.0f);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (AbstractWidget abstractWidget : this.getWidgets()) {
            if (abstractWidget.f_93620_ < minX) {
                minX = abstractWidget.f_93620_;
            }
            if (abstractWidget.f_93620_ <= maxX) continue;
            maxX = abstractWidget.f_93620_;
        }
        this.viewportTranslation = new Vec2((float)Mth.m_14008_((double)((double)this.viewportTranslation.f_82470_ + delta * 16.0), (double)(-maxX), (double)(-minX)), this.viewportTranslation.f_82471_);
        this.saveViewportTransforms();
        return false;
    }

    @Override
    public void renderTabForeground(PoseStack renderStack, Rectangle containerBounds, int mouseX, int mouseY, float pTicks, List<Runnable> postContainerRender) {
        RenderSystem.m_69478_();
        Point2D.Float midpoint = MiscUtils.getMidpoint(this.getBounds());
        renderStack.m_85836_();
        renderStack.m_85837_((double)Math.round(this.viewportTranslation.f_82470_ + midpoint.x), (double)Math.round(this.viewportTranslation.f_82471_ + midpoint.y), 0.0);
        int containerMouseX = (int)(((float)mouseX - midpoint.x) / this.viewportScale - this.viewportTranslation.f_82470_);
        int containerMouseY = (int)(((float)mouseY - midpoint.y) / this.viewportScale - this.viewportTranslation.f_82471_);
        for (ArchetypeWidgetSelectable widget : this.widgetMap.values()) {
            widget.renderWidget(renderStack, containerBounds, mouseX, mouseY, containerMouseX, containerMouseY, pTicks, postContainerRender);
        }
        renderStack.m_85849_();
    }
}

