/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.legacy.widget.NodeState;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.AbilityTree;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class AbilityWidget
extends AbstractWidget {
    protected final String abilityName;
    protected final AbilityTree abilityTree;
    protected final Map<NodeState, TextureAtlasRegion> background;
    protected final TextureAtlasRegion icon;

    public AbilityWidget(String abilityName, AbilityTree abilityTree, int x, int y, Map<NodeState, TextureAtlasRegion> background, TextureAtlasRegion icon) {
        super(x, y, background.get((Object)NodeState.DEFAULT).width(), background.get((Object)NodeState.DEFAULT).height(), (Component)new TextComponent("the_vault.widgets.ability"));
        this.abilityName = abilityName;
        this.abilityTree = abilityTree;
        this.background = background;
        this.icon = icon;
    }

    public SpecializedSkill makeAbilityNode() {
        SpecializedSkill group = this.getAbilityGroup();
        TieredSkill node = (TieredSkill)group.getSpecialization();
        int level = node.getUnmodifiedTier();
        SpecializedSkill result = (SpecializedSkill)group.copy();
        result.specialize(this.abilityName, SkillContext.ofClient());
        if (node.isUnlocked() && !this.isSpecialization() && level < node.getMaxLearnableTier()) {
            result.learn(SkillContext.ofClient());
        }
        return result;
    }

    public SpecializedSkill getAbilityGroup() {
        return (SpecializedSkill)this.getAbility().getParent();
    }

    public String getAbilityName() {
        return this.abilityName;
    }

    protected TieredSkill getAbility() {
        return this.abilityTree.getForId(this.abilityName).orElse(null);
    }

    protected boolean isSpecialization() {
        return !this.getAbilityGroup().getSpecialization(0).getId().equals(this.abilityName);
    }

    protected boolean isLocked() {
        SpecializedSkill existing;
        if (this.isSpecialization() && (!(existing = this.getAbilityGroup()).isUnlocked() || existing.getIndex() != 0 && !existing.getSpecialization().getId().equals(this.abilityName))) {
            return true;
        }
        return VaultBarOverlay.vaultLevel < this.makeAbilityNode().getUnlockLevel();
    }

    public void renderWidget(PoseStack matrixStack, Rectangle containerBounds, int mouseX, int mouseY, int containerMouseX, int containerMouseY, float partialTicks, List<Runnable> postContainerRender) {
        this.m_6305_(matrixStack, containerMouseX, containerMouseY, partialTicks);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.m_85836_();
        TextureAtlasRegion textureAtlasRegion = this.background.get((Object)NodeState.DEFAULT);
        TextureAtlasSprite sprite = textureAtlasRegion.getSprite();
        matrixStack.m_85837_((double)((float)(-sprite.m_118405_()) / 2.0f), (double)((float)(-sprite.m_118408_()) / 2.0f), 0.0);
        textureAtlasRegion.blit(matrixStack, this.f_93620_, this.f_93621_);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        TextureAtlasSprite sprite2 = this.icon.getSprite();
        matrixStack.m_85837_((double)((float)(-sprite2.m_118405_()) / 2.0f), (double)((float)(-sprite2.m_118408_()) / 2.0f), 0.0);
        this.icon.blit(matrixStack, this.f_93620_, this.f_93621_);
        matrixStack.m_85849_();
    }

    public void m_142291_(@Nonnull NarrationElementOutput narrationElementOutput) {
    }
}

