/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.legacy.widget.ArchetypeNodeTextures;
import iskallia.vault.client.gui.screen.player.legacy.widget.NodeState;
import iskallia.vault.client.util.TooltipUtil;
import iskallia.vault.skill.archetype.AbstractArchetype;
import iskallia.vault.skill.archetype.AbstractArchetypeConfig;
import iskallia.vault.skill.archetype.ArchetypeRegistry;
import iskallia.vault.util.SkinProfile;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ArchetypeWidgetSelectable
extends AbstractWidget {
    protected final ResourceLocation archetypeId;
    protected final AbstractArchetype<?> archetype;
    protected final Map<NodeState, TextureAtlasRegion> background;
    protected final IIconRenderer iconRenderer;
    protected final TranslatableComponent nameComponent;
    private boolean selected;
    protected final Supplier<ResourceLocation> equippedArchetype;

    public ArchetypeWidgetSelectable(ResourceLocation archetypeId, Supplier<ResourceLocation> equippedArchetype, int x, int y, Map<NodeState, TextureAtlasRegion> background, IIconRenderer iconRenderer) {
        super(x, y, background.get((Object)NodeState.DEFAULT).width(), background.get((Object)NodeState.DEFAULT).width(), (Component)new TextComponent("the_vault.widgets.archetype"));
        this.equippedArchetype = equippedArchetype;
        this.archetypeId = archetypeId;
        this.archetype = ArchetypeRegistry.getArchetype(this.archetypeId);
        this.background = background;
        this.iconRenderer = iconRenderer;
        this.nameComponent = new TranslatableComponent(this.archetype.getName());
    }

    public void m_142291_(@Nonnull NarrationElementOutput narrationElementOutput) {
    }

    protected boolean isEquipped() {
        return this.archetypeId.equals((Object)this.equippedArchetype.get());
    }

    public int getClickableWidth() {
        return this.f_93618_;
    }

    public int getClickableHeight() {
        return this.f_93619_;
    }

    public Rectangle getClickableBounds() {
        return new Rectangle(this.f_93620_ - this.getClickableWidth() / 2, this.f_93621_ - this.getClickableHeight() / 2, this.getClickableWidth(), this.getClickableHeight());
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.getClickableBounds().contains(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.selected) {
            return false;
        }
        this.m_7435_(Minecraft.m_91087_().m_91106_());
        return true;
    }

    public void select() {
        this.selected = true;
    }

    public void deselect() {
        this.selected = false;
    }

    public ResourceLocation getArchetypeId() {
        return this.archetypeId;
    }

    public TranslatableComponent getNameComponent() {
        return this.nameComponent;
    }

    protected int getLevelRequirement() {
        return ((AbstractArchetypeConfig)this.archetype.getConfig()).getLevelRequirement();
    }

    protected boolean isLevelLocked() {
        return this.isLevelLocked(this.getLevelRequirement());
    }

    protected boolean isLevelLocked(int levelRequirement) {
        return VaultBarOverlay.vaultLevel < levelRequirement;
    }

    public void renderWidget(PoseStack matrixStack, Rectangle containerBounds, int mouseX, int mouseY, int containerMouseX, int containerMouseY, float partialTicks, List<Runnable> postContainerRender) {
        this.render(containerBounds, matrixStack, mouseX, mouseY, containerMouseX, containerMouseY, partialTicks);
        if (containerBounds.contains(mouseX, mouseY)) {
            Matrix4f current = matrixStack.m_85850_().m_85861_().m_27658_();
            postContainerRender.add(() -> {
                matrixStack.m_85836_();
                matrixStack.m_166854_(current);
                this.renderHover(matrixStack, containerMouseX, containerMouseY, partialTicks);
                matrixStack.m_85849_();
            });
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    public void render(Rectangle containerBounds, PoseStack matrixStack, int mouseX, int mouseY, int containerMouseX, int containerMouseY, float partialTicks) {
        RenderSystem.m_69478_();
        NodeState state = this.isEquipped() ? NodeState.SELECTED : (this.isLevelLocked() ? NodeState.DISABLED : (this.selected || this.getClickableBounds().contains(containerMouseX, containerMouseY) && containerBounds.contains(mouseX, mouseY) ? NodeState.HOVERED : NodeState.DEFAULT));
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((float)(-this.f_93618_) / 2.0f), (double)((float)(-this.f_93619_) / 2.0f), 0.0);
        this.background.get((Object)state).blit(matrixStack, this.f_93620_, this.f_93621_);
        matrixStack.m_85849_();
        if (state == NodeState.DISABLED) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        matrixStack.m_85836_();
        this.iconRenderer.render(matrixStack, this.f_93620_, this.f_93621_);
        matrixStack.m_85849_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ArchetypeNodeTextures.BANNER.blit(matrixStack, this.f_93620_ - ArchetypeNodeTextures.BANNER.width() / 2, this.f_93621_ + 44);
        int borderColor = -398145;
        FormattedCharSequence formattedCharSequence = this.nameComponent.m_7532_();
        Minecraft minecraft = Minecraft.m_91087_();
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float x = (float)this.f_93620_ - (float)minecraft.f_91062_.m_92852_((FormattedText)this.nameComponent) / 2.0f;
        float y = this.f_93621_ + 49;
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        minecraft.f_91062_.m_92733_(formattedCharSequence, x - 1.0f, y, borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
        minecraft.f_91062_.m_92733_(formattedCharSequence, x + 1.0f, y, borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
        minecraft.f_91062_.m_92733_(formattedCharSequence, x - 1.0f, y - 1.0f, borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
        minecraft.f_91062_.m_92733_(formattedCharSequence, x + 1.0f, y - 1.0f, borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
        minecraft.f_91062_.m_92733_(formattedCharSequence, x, y - 1.0f, borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
        minecraft.f_91062_.m_92733_(formattedCharSequence, x, y + 1.0f, borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
        minecraft.f_91062_.m_92733_(formattedCharSequence, x + 1.0f, y + 1.0f, borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
        minecraft.f_91062_.m_92733_(formattedCharSequence, x - 1.0f, y + 1.0f, borderColor, false, matrix, (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
        bufferSource.m_109911_();
        minecraft.f_91062_.m_92889_(matrixStack, (Component)this.nameComponent, x, y, -10138601);
        RenderSystem.m_69482_();
    }

    private void renderHover(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.getClickableBounds().contains(mouseX, mouseY)) {
            return;
        }
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        tooltip.add(this.getNameComponent().m_7532_());
        int levelRequirement = this.getLevelRequirement();
        if (levelRequirement > 0) {
            ChatFormatting color = this.isLevelLocked(levelRequirement) ? ChatFormatting.RED : ChatFormatting.GREEN;
            tooltip.add(FormattedCharSequence.m_13714_((String)("Requires level: " + levelRequirement), (Style)Style.f_131099_.m_131140_(color)));
        }
        TooltipUtil.renderTooltip(matrixStack, tooltip, mouseX, mouseY, Integer.MAX_VALUE, Integer.MAX_VALUE);
        RenderSystem.m_69478_();
    }

    public static interface IIconRenderer {
        public void render(PoseStack var1, int var2, int var3);
    }

    public static class PlayerFaceIconRenderer
    implements IIconRenderer {
        private final SkinProfile skinProfile;
        private final int size;
        private final int sizeHalf;
        private final int borderSize;
        private final int borderColor;

        public static PlayerFaceIconRenderer of(String playerName, int size, int borderSize, int borderColor) {
            return new PlayerFaceIconRenderer(playerName, size, borderSize, borderColor);
        }

        private PlayerFaceIconRenderer(String playerName, int size, int borderSize, int borderColor) {
            this.size = size;
            this.sizeHalf = size / 2;
            this.borderSize = borderSize;
            this.borderColor = borderColor;
            this.skinProfile = new SkinProfile();
            this.skinProfile.updateSkin(playerName);
        }

        @Override
        public void render(PoseStack poseStack, int x, int y) {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(x - this.sizeHalf - this.borderSize), (int)(y - this.sizeHalf - this.borderSize), (int)(x + this.sizeHalf + this.borderSize), (int)(y + this.sizeHalf + this.borderSize), (int)this.borderColor);
            poseStack.m_85837_((double)(-this.sizeHalf), (double)(-this.sizeHalf), 0.0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.skinProfile.getLocationSkin());
            GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)this.size, (int)this.size, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)this.size, (int)this.size, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        }
    }

    public record TextureAtlasRegionIconRenderer(TextureAtlasRegion icon) implements IIconRenderer
    {
        public static TextureAtlasRegionIconRenderer of(TextureAtlasRegion icon) {
            return new TextureAtlasRegionIconRenderer(icon);
        }

        @Override
        public void render(PoseStack poseStack, int x, int y) {
            poseStack.m_85837_((double)(-((float)this.icon.width() / 2.0f)), (double)(-((float)this.icon.height() / 2.0f)), 0.0);
            this.icon.blit(poseStack, x, y);
        }
    }
}

