/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.client.gui.screen.player.legacy.widget.connect.ConnectableWidget;
import iskallia.vault.client.gui.widget.ComponentWidget;
import iskallia.vault.client.util.TooltipUtil;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.research.type.Research;
import iskallia.vault.util.ResourceBoundary;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ResearchWidget
extends AbstractWidget
implements ConnectableWidget,
ComponentWidget {
    private static final int ICON_SIZE = 30;
    private final String researchName;
    private final ResearchTree researchTree;
    private final boolean locked;
    private final SkillStyle style;
    private boolean selected = false;
    private boolean hoverable = true;

    public ResearchWidget(String researchName, ResearchTree researchTree, SkillStyle style) {
        super(style.x, style.y, 30, 30, (Component)new TextComponent("the_vault.widgets.research"));
        this.style = style;
        this.locked = ModConfigs.SKILL_GATES.getGates().isLocked(researchName, researchTree);
        this.researchName = researchName;
        this.researchTree = researchTree;
    }

    public ResearchTree getResearchTree() {
        return this.researchTree;
    }

    public String getResearchName() {
        return this.researchName;
    }

    @Override
    public Rectangle getClickableBounds() {
        return new Rectangle(this.f_93620_, this.f_93621_, 30, 30);
    }

    @Override
    public Point2D.Double getRenderPosition() {
        return new Point2D.Double((double)this.f_93620_ + 2.5, (double)this.f_93621_ + 2.5);
    }

    @Override
    public double getRenderWidth() {
        return 25.0;
    }

    @Override
    public double getRenderHeight() {
        return 25.0;
    }

    public void setHoverable(boolean hoverable) {
        this.hoverable = hoverable;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (!this.hoverable) {
            return false;
        }
        return this.getClickableBounds().contains(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.selected) {
            return false;
        }
        this.m_7435_(Minecraft.m_91087_().m_91106_());
        return true;
    }

    public void select() {
        this.selected = true;
    }

    public void deselect() {
        this.selected = false;
    }

    public void renderWidget(PoseStack matrixStack, Rectangle containerBounds, int mouseX, int mouseY, int containerMouseX, int containerMouseY, float partialTicks, List<Runnable> postContainerRender) {
        this.m_6305_(matrixStack, containerMouseX, containerMouseY, partialTicks);
        if (containerBounds.contains(mouseX, mouseY)) {
            Matrix4f current = matrixStack.m_85850_().m_85861_().m_27658_();
            postContainerRender.add(() -> {
                matrixStack.m_85836_();
                matrixStack.m_166854_(current);
                this.renderHover(matrixStack, containerMouseX, containerMouseY, partialTicks);
                matrixStack.m_85849_();
            });
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderIcon(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void renderHover(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        List<Research> conflicts;
        List<Research> preconditions;
        if (!this.m_5953_(mouseX, mouseY)) {
            return;
        }
        ArrayList<FormattedCharSequence> tTip = new ArrayList<FormattedCharSequence>();
        tTip.add(FormattedCharSequence.m_13714_((String)this.researchName, (Style)Style.f_131099_));
        if (this.locked && !(preconditions = ModConfigs.SKILL_GATES.getGates().getDependencyResearches(this.researchName)).isEmpty()) {
            String tTipRequirement = ModConfigs.SKILL_GATES.getGates().hasEitherSkillGate(this.getResearchName()) ? " any of" : "";
            tTip.add(FormattedCharSequence.m_13714_((String)("Requires" + tTipRequirement + ":"), (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)));
            preconditions.forEach(research -> tTip.add(FormattedCharSequence.m_13714_((String)("- " + research.getName()), (Style)Style.f_131099_.m_131140_(ChatFormatting.RED))));
        }
        if (!(conflicts = ModConfigs.SKILL_GATES.getGates().getLockedByResearches(this.researchName)).isEmpty()) {
            tTip.add(FormattedCharSequence.m_13714_((String)"Cannot be unlocked alongside:", (Style)Style.f_131099_.m_131140_(ChatFormatting.RED)));
            conflicts.forEach(research -> tTip.add(FormattedCharSequence.m_13714_((String)("- " + research.getName()), (Style)Style.f_131099_.m_131140_(ChatFormatting.RED))));
        }
        TooltipUtil.renderTooltip(matrixStack, tTip, mouseX, mouseY, Integer.MAX_VALUE, Integer.MAX_VALUE);
        RenderSystem.m_69478_();
    }

    private void renderIcon(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ResourceBoundary resourceBoundary = this.style.frameType.getResourceBoundary();
        matrixStack.m_85836_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)resourceBoundary.getResource());
        int vOffset = this.locked ? 62 : (this.selected || this.m_5953_(mouseX, mouseY) ? -31 : (this.researchTree.getResearchesDone().contains(this.researchName) ? 31 : 0));
        this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, resourceBoundary.getU(), resourceBoundary.getV() + vOffset, resourceBoundary.getWidth(), resourceBoundary.getHeight());
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-8.0, -8.0, 0.0);
        ITextureAtlas atlas = ModTextureAtlases.RESEARCHES.get();
        RenderSystem.m_157456_((int)0, (ResourceLocation)atlas.getAtlasResourceLocation());
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)(this.f_93620_ + 15), (int)(this.f_93621_ + 15), (int)0, (int)16, (int)16, (TextureAtlasSprite)atlas.getSprite(this.style.icon));
        matrixStack.m_85849_();
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

