/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.ClientHistoricFavoritesData;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.RenderIndexedElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.TitleElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Padding;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.screen.summary.VaultEndScreen;
import iskallia.vault.client.gui.screen.summary.VaultExitContainerScreenData;
import iskallia.vault.client.gui.screen.summary.element.StatLabelListElement;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ServerboundAddHistoricFavoriteMessage;
import iskallia.vault.network.message.ServerboundSendSnapshotLinkMessage;
import iskallia.vault.util.function.ObservableSupplier;
import iskallia.vault.world.data.VaultSnapshots;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class VaultHistoricDataScreen
extends AbstractElementScreen {
    public static final int TITLE_WIDTH = 128;
    public static final int BUTTON_WIDTH = 52;
    public static final int BUTTON_HEIGHT = 19;
    protected ButtonElement<?> closeButton;
    private static final boolean DEBUG = false;
    public static final TextColor XP_COLOR = TextColor.m_131268_((String)"#FFE637");
    private final List<VaultSnapshot> snapshots;
    private final List<VaultSnapshot> prev50;
    private HistoricContainerElement historyContainer;
    private HistoricContainerElement favoritesContainer;
    private LabelElement<?> historicLabel;
    private LabelElement<?> favoritesLabel;
    private VaultHistoricDataTabElement tabs;

    public VaultHistoricDataScreen(List<VaultSnapshot> snapshots, Component title) {
        super(title, ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        this.snapshots = new ArrayList<VaultSnapshot>(snapshots);
        Collections.reverse(this.snapshots);
        this.setGuiSize(Spatials.size(350, 186));
        this.prev50 = Minecraft.m_91087_().f_91074_ != null ? VaultSnapshots.getPrev50(Minecraft.m_91087_().f_91074_.m_142081_(), snapshots) : new ArrayList<VaultSnapshot>();
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionY(-4).positionZ(-12).positionY(6), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.width(128).height(32).translateX((gui.right() - gui.left()) / 2 + gui.left() - 64)));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXY(0, 42).size(this.f_96543_, 19).height(this.getTabContentSpatial()), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() - 8 - 26 + 7).size(gui.width() + 16 + 26, this.getTabContentSpatial().height())));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionY(-4).positionZ(-10), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.x() - 26 + 7).translateY(this.getTabContentSpatial().bottom()).size(gui.width() + 26, gui.height() - 10)));
        this.historyContainer = this.addElement((HistoricContainerElement)new HistoricContainerElement(Spatials.positionX(4).width(-7).height(-16), this.prev50, false).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() + 2 - 26 + 7).translateY(this.getTabContentSpatial().bottom()).width(world.width() + gui.right() - world.x() + 7).height(world.height() + gui.height() - 22)));
        this.favoritesContainer = this.addElement((HistoricContainerElement)new HistoricContainerElement(Spatials.positionX(4).width(-7).height(-16), snapshots, true).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() + 2 - 26 + 7).translateY(this.getTabContentSpatial().bottom()).width(world.width() + gui.right() - world.x() + 7).height(world.height() + gui.height() - 22)));
        this.historicLabel = this.addElement((LabelElement)new LabelElement((IPosition)Spatials.zero(), (Component)new TextComponent("Previous 50 Vaults").m_130940_(ChatFormatting.BLACK), LabelTextStyle.left()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() - 8 - 26 + 13).translateY(48).translateZ(2)));
        this.favoritesLabel = this.addElement((LabelElement)new LabelElement((IPosition)Spatials.zero(), (Component)new TextComponent("Favorites").m_130940_(ChatFormatting.BLACK), LabelTextStyle.left()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.left() - 8 - 26 + 13).translateY(48).translateZ(2)));
        TitleElement titleHistory = this.addElement((TitleElement)new TitleElement((IPosition)Spatials.positionY(16), (Component)new TextComponent("History").m_130940_(ChatFormatting.BLACK), LabelTextStyle.left()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX((gui.right() - gui.left()) / 2 + gui.left() - TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TextComponent("History")))));
        TitleElement titleFavorites = this.addElement((TitleElement)new TitleElement((IPosition)Spatials.positionY(16), (Component)new TextComponent("Favorites").m_130940_(ChatFormatting.BLACK), LabelTextStyle.left()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX((gui.right() - gui.left()) / 2 + gui.left() - TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TextComponent("Favorites")))));
        this.tabs = this.addElement((VaultHistoricDataTabElement)new VaultHistoricDataTabElement(Spatials.positionXY(-3, 3), index -> {
            this.historyContainer.setEnabled(index == 0);
            this.historyContainer.setVisible(index == 0);
            this.historicLabel.setEnabled(index == 0);
            this.historicLabel.setVisible(index == 0);
            titleHistory.setVisible(index == 0);
            titleHistory.setEnabled(index == 0);
            this.favoritesContainer.setEnabled(index == 1);
            this.favoritesContainer.setVisible(index == 1);
            this.favoritesLabel.setEnabled(index == 1);
            this.favoritesLabel.setVisible(index == 1);
            titleFavorites.setVisible(index == 1);
            titleFavorites.setEnabled(index == 1);
        }, false).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateX(gui.right() + 7).translateY(this.getTabContentSpatial().bottom())));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.zero(), (Component)new TextComponent("Close").m_130940_(ChatFormatting.WHITE), LabelTextStyle.border4(ChatFormatting.BLACK).center()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateZ(2).translateX(gui.right() - gui.left() + gui.left() - 26 - 1 - TextBorder.DEFAULT_FONT.get().m_92895_("Close") / 2).translateY(this.getTabContentSpatial().bottom() + gui.height() - 31)));
        this.closeButton = this.addElement((ButtonElement)((ButtonElement)new ButtonElement(Spatials.zero(), ScreenTextures.BUTTON_CLOSE_TEXTURES, () -> {
            this.m_7379_();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.width(52).height(19).translateX(gui.right() - gui.left() + gui.left() - 52).translateY(this.getTabContentSpatial().bottom() + gui.height() - 37))).tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            tooltipRenderer.renderTooltip(poseStack, List.of(new TextComponent("Close")), mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.RIGHT);
            return false;
        }));
    }

    public HistoricContainerElement getFavoritesContainer() {
        return this.favoritesContainer;
    }

    @Override
    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public ISpatial getTabContentSpatial() {
        int padLeft = 21;
        int padTop = 42;
        int width = this.f_96543_ - padLeft * 2;
        int height = 19;
        return Spatials.positionXY(padLeft, padTop).size(width, height);
    }

    @Override
    protected void layout(ISpatial parent) {
        super.layout(parent);
    }

    private static /* synthetic */ void lambda$new$15(ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) {
        world.width(screen).positionY(10);
    }

    public class HistoricContainerElement
    extends VerticalScrollClipContainer<HistoricContainerElement> {
        List<FavoritesDisplayElement> displayElements;
        List<LabelElement> labelElements;
        List<ButtonElement> buttonElements;

        public void removeElements() {
            this.displayElements.forEach(x$0 -> this.removeElement((IElement)x$0));
            this.labelElements.forEach(x$0 -> this.removeElement((IElement)x$0));
            this.buttonElements.forEach(x$0 -> this.removeElement((IElement)x$0));
        }

        public void reset(boolean requiresFavorite) {
            this.reset(requiresFavorite, VaultHistoricDataScreen.this.snapshots);
        }

        public void reset(boolean requiresFavorite, List<VaultSnapshot> snap) {
            int i = 0;
            for (VaultSnapshot snapshot : snap) {
                VaultExitContainerScreenData screenData = new VaultExitContainerScreenData(snapshot, Minecraft.m_91087_().f_91074_.m_142081_());
                Vault vault = screenData.getSnapshot().getEnd();
                if (requiresFavorite) {
                    UUID vaultId = vault.get(Vault.ID);
                    List<UUID> list = ClientHistoricFavoritesData.getFavorites();
                    boolean favorite = false;
                    if (list != null) {
                        for (UUID value : list) {
                            if (!value.equals(vaultId)) continue;
                            favorite = true;
                            break;
                        }
                    }
                    if (!favorite) continue;
                }
                FavoritesDisplayElement element = this.addElement(new FavoritesDisplayElement(Spatials.positionY(5 + 74 * i).positionX(62), ScreenTextures.TAB_ICON_FAVORITES, ScreenTextures.TAB_ICON_FAVORITES_GRAY, (Component)new TextComponent("Vault Level: " + vault.get(Vault.LEVEL).get() + " - ").m_7220_((Component)new TranslatableComponent(screenData.getCompletionTranslationString())), 276, 71, new HashMap<String, String>(), new ArrayList(screenData.getQuickOverview()), screenData));
                this.displayElements.add(element);
                MutableComponent xpGainedComponent = new TextComponent("+ " + screenData.getStatsCollector().getExperience(vault) + " xp").m_130948_(Style.f_131099_.m_131148_(XP_COLOR));
                LabelElement labelElement = this.addElement((LabelElement)((LabelElement)new LabelElement((IPosition)Spatials.positionY(13 + 74 * i).positionX(330 - TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)xpGainedComponent)), (Component)xpGainedComponent, LabelTextStyle.shadow(ChatFormatting.BLACK)).layout((arg_0, arg_1, arg_2, arg_3) -> HistoricContainerElement.lambda$reset$3((Component)xpGainedComponent, arg_0, arg_1, arg_2, arg_3))).tooltip(Tooltips.multi(() -> {
                    StatCollector statCollector = screenData.getStatsCollector();
                    long window = Minecraft.m_91087_().m_91268_().m_85439_();
                    boolean shiftDown = InputConstants.m_84830_((long)window, (int)340) || InputConstants.m_84830_((long)window, (int)344);
                    float xpMultiplier = statCollector.getExpMultiplier();
                    List<Component> xpReceipt = VaultExitContainerScreenData.getXpReceipt(vault, screenData.getStatsCollector(), shiftDown, xpMultiplier);
                    int maxWidth = 0;
                    int spaceWidth = TextBorder.DEFAULT_FONT.get().m_92895_(" ");
                    for (Component component : xpReceipt) {
                        maxWidth = Math.max(TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)component), maxWidth);
                    }
                    MutableComponent titleText = new TextComponent("Vault Xp").m_130948_(Style.f_131099_.m_131148_(XP_COLOR));
                    TextComponent spacer = new TextComponent("");
                    String totalXpString = shiftDown ? String.format("(x%.1f) %s xp", Float.valueOf(xpMultiplier), ModConfigs.VAULT_STATS.getExperience(vault, statCollector)) : String.format("%s xp", statCollector.getExperience(vault));
                    for (int j = 0; j < maxWidth / spaceWidth - 10 - TextBorder.DEFAULT_FONT.get().m_92895_(totalXpString) / spaceWidth; ++j) {
                        spacer.m_130946_(" ");
                    }
                    xpReceipt.add(0, (Component)titleText.m_7220_((Component)spacer).m_130946_(totalXpString));
                    return xpReceipt;
                })));
                this.labelElements.add(labelElement);
                MutableComponent buttonComponent = new TextComponent("Open").m_130940_(ChatFormatting.WHITE);
                LabelElement labelElement2 = this.addElement(new LabelElement((IPosition)Spatials.positionXYZ(30 - TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)buttonComponent) / 2, 41 + 74 * i, 7), (Component)buttonComponent, LabelTextStyle.border4(ChatFormatting.BLACK).center()));
                this.labelElements.add(labelElement2);
                ButtonElement buttonElement = this.addElement((ButtonElement)((ButtonElement)new ButtonElement(Spatials.positionXYZ(5, 36 + 74 * i, 5), ScreenTextures.BUTTON_CLOSE_TEXTURES, () -> {
                    Minecraft.m_91087_().m_91152_((Screen)new VaultEndScreen(screenData.getSnapshot(), (Component)new TextComponent("Vault Exit"), Minecraft.m_91087_().f_91074_.m_142081_(), true));
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                }).layout((screen, gui, parent, world) -> world.width(52).height(19))).tooltip((ITooltipRenderer tooltipRenderer, PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) -> {
                    tooltipRenderer.renderTooltip(poseStack, List.of(new TextComponent("Open Vault Stats")), mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.RIGHT);
                    return false;
                }));
                this.buttonElements.add(buttonElement);
                ButtonElement buttonElement2 = this.addElement((ButtonElement)((ButtonElement)new ButtonElement(Spatials.positionXYZ(21, 13 + 74 * i, 5), ScreenTextures.BUTTON_SHARE_TEXTURES, () -> {
                    ModNetwork.CHANNEL.sendToServer((Object)new ServerboundSendSnapshotLinkMessage(screenData.getSnapshot().getEnd().get(Vault.ID)));
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                }).layout((screen, gui, parent, world) -> world.width(19).height(19))).tooltip((ITooltipRenderer tooltipRenderer, PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) -> {
                    tooltipRenderer.renderTooltip(poseStack, List.of(new TextComponent("Share Vault")), mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.RIGHT);
                    return false;
                }));
                this.buttonElements.add(buttonElement2);
                ++i;
            }
        }

        public HistoricContainerElement(ISpatial spatial, List<VaultSnapshot> snapshots, boolean requiresFavorite) {
            super(spatial, Padding.of(2, 0));
            this.displayElements = new ArrayList<FavoritesDisplayElement>();
            this.labelElements = new ArrayList<LabelElement>();
            this.buttonElements = new ArrayList<ButtonElement>();
            this.reset(requiresFavorite, snapshots);
        }

        private static /* synthetic */ void lambda$reset$3(Component xpGainedComponent, ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) {
            IMutableSpatial iMutableSpatial = world.translateZ(3).width(TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)xpGainedComponent));
            Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
            iMutableSpatial.height(9);
        }
    }

    public class VaultHistoricDataTabElement<E extends VaultHistoricDataTabElement<E>>
    extends ElasticContainerElement<E> {
        private int selectedIndex;

        public VaultHistoricDataTabElement(IPosition position, Consumer<Integer> selectedIndexChangeAction, boolean isCoop) {
            super(Spatials.positionXYZ(position));
            ObservableSupplier<Integer> selectedIndexObserver = ObservableSupplier.of(() -> this.selectedIndex, Integer::equals);
            selectedIndexObserver.ifChanged(selectedIndexChangeAction);
            this.addElement(new StatTabElement(Spatials.positionZ(position).size(31, 28), new TextureAtlasElement(Spatials.positionXYZ(4, 6, position.z() + 1), ScreenTextures.TAB_ICON_HISTORY), () -> this.selectedIndex == 0, () -> {
                this.selectedIndex = 0;
                selectedIndexObserver.ifChanged(selectedIndexChangeAction);
            }, false));
            this.addElement(new StatTabElement(Spatials.positionY(31).positionZ(position).size(31, 28), new TextureAtlasElement(Spatials.positionXYZ(4, 6, position.z() + 1), ScreenTextures.TAB_ICON_FAVORITES), () -> this.selectedIndex == 1, () -> {
                this.selectedIndex = 1;
                selectedIndexObserver.ifChanged(selectedIndexChangeAction);
            }, false));
        }

        private static class StatTabElement
        extends ElasticContainerElement<StatTabElement> {
            private final Runnable onClick;

            public StatTabElement(ISpatial spatial, IRenderedElement iconElement, Supplier<Boolean> selected, Runnable onClick, boolean disabled) {
                super(spatial);
                this.onClick = onClick;
                this.addElement(new RenderIndexedElement(Spatials.zero(), List.of(new TextureAtlasElement(Spatials.positionX(3), ScreenTextures.TAB_BACKGROUND_RIGHT), new TextureAtlasElement(ScreenTextures.TAB_BACKGROUND_RIGHT_SELECTED), new TextureAtlasElement(Spatials.positionX(3), ScreenTextures.TAB_BACKGROUND_RIGHT_DISABLED)), () -> disabled ? 2 : ((Boolean)selected.get() != false ? 1 : 0)));
                this.addElement(iconElement);
            }

            @Override
            public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
                this.onClick.run();
                return true;
            }
        }
    }

    public static class GrayedTextureAtlasElement<E extends TextureAtlasElement<E>>
    extends AbstractSpatialElement<E>
    implements IRenderedElement,
    IGuiEventElement {
        private final TextureAtlasRegion textureAtlasRegion;
        private final TextureAtlasRegion grayTextureAtlasRegion;
        private final UUID vaultID;
        private boolean visible;
        private final Runnable onClick;

        public GrayedTextureAtlasElement(IPosition position, TextureAtlasRegion textureAtlasRegion, TextureAtlasRegion grayTextureAtlasRegion, UUID vaultID, Runnable onClick) {
            this(position, Spatials.size(textureAtlasRegion), textureAtlasRegion, grayTextureAtlasRegion, vaultID, onClick);
        }

        public GrayedTextureAtlasElement(IPosition position, ISize size, TextureAtlasRegion textureAtlasRegion, TextureAtlasRegion grayTextureAtlasRegion, UUID vaultID, Runnable onClick) {
            super(Spatials.positionXYZ(position).size(size));
            this.textureAtlasRegion = textureAtlasRegion;
            this.grayTextureAtlasRegion = grayTextureAtlasRegion;
            this.vaultID = vaultID;
            this.onClick = onClick;
            this.setVisible(true);
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            boolean favorite = false;
            List<UUID> list = ClientHistoricFavoritesData.getFavorites();
            if (list != null) {
                for (UUID value : list) {
                    if (!value.equals(this.vaultID)) continue;
                    favorite = true;
                    break;
                }
            }
            if (favorite) {
                renderer.render(this.textureAtlasRegion, poseStack, (IPosition)this.worldSpatial);
            } else {
                renderer.render(this.grayTextureAtlasRegion, poseStack, (IPosition)this.worldSpatial);
            }
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
            this.onClick.run();
            return true;
        }
    }

    public class FavoritesDisplayElement<E extends FavoritesDisplayElement<E>>
    extends ContainerElement<E> {
        private UUID vaultID;
        private VaultSnapshot snapshot;

        public FavoritesDisplayElement(IPosition position, TextureAtlasRegion icon, TextureAtlasRegion iconGray, Component name, int width, int height, Map<String, String> stringMap, List<StatLabelListElement.Stat<?>> statList, VaultExitContainerScreenData screenData) {
            super(Spatials.positionXYZ(position).size(width, Math.max(height, 31 + stringMap.size() * 16)));
            this.vaultID = screenData.getSnapshot().getEnd().get(Vault.ID);
            this.snapshot = screenData.getSnapshot();
            this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(5, 0, 3).size(24, 24), ScreenTextures.VAULT_EXIT_ELEMENT_ICON).layout((screen, gui, parent, world) -> world.size(24, 24)));
            this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(0, 2, 2).size(width, 20), ScreenTextures.VAULT_EXIT_ELEMENT_TITLE).layout((screen, gui, parent, world) -> world.size(width, 20)));
            this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(4, 20, 1).size(width - 8, height - 20), ScreenTextures.VAULT_EXIT_ELEMENT_BG).layout((screen, gui, parent, world) -> world.size(width - 8, height - 20)));
            this.addElement(new GrayedTextureAtlasElement(Spatials.positionXYZ(8, 4, 5), icon, iconGray, this.vaultID, () -> {
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundAddHistoricFavoriteMessage(this.vaultID));
                Screen patt28324$temp = Minecraft.m_91087_().f_91080_;
                if (patt28324$temp instanceof VaultHistoricDataScreen) {
                    VaultHistoricDataScreen vaultHistoricDataScreen = (VaultHistoricDataScreen)patt28324$temp;
                    VaultHistoricDataScreen.this.favoritesContainer.removeElements();
                    VaultHistoricDataScreen.this.favoritesContainer.reset(true);
                }
            })).tooltip((ITooltipRenderer tooltipRenderer, PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) -> {
                boolean favorite = false;
                List<UUID> list = ClientHistoricFavoritesData.getFavorites();
                if (list != null) {
                    for (UUID value : list) {
                        if (!value.equals(this.vaultID)) continue;
                        favorite = true;
                        break;
                    }
                }
                if (!favorite) {
                    tooltipRenderer.renderTooltip(poseStack, List.of(new TextComponent("Favorite")), mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.RIGHT);
                } else {
                    tooltipRenderer.renderTooltip(poseStack, List.of(new TextComponent("Un-Favorite")), mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.RIGHT);
                }
                return false;
            });
            this.addElement(new StringElement((IPosition)Spatials.positionXYZ(32, 8, 5), (ISize)Spatials.size(16, 7), () -> name, LabelTextStyle.shadow().left()));
            this.addElement((StatLabelListElement)new StatLabelListElement(Spatials.positionY(27).positionX(8).positionZ(2).width(width - 16), TextColor.m_131268_((String)"#000000"), statList).layout((screen, gui, parent, world) -> {
                IMutableSpatial iMutableSpatial = world.width(width - 16);
                int n = statList.size();
                Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
                iMutableSpatial.height(n * 9);
            }));
        }

        private static final class StringElement
        extends DynamicLabelElement<Component, StringElement> {
            private StringElement(IPosition position, ISize size, Supplier<Component> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
                super(position, size, valueSupplier, labelTextStyle);
            }

            @Override
            protected void onValueChanged(Component value) {
                this.set(value);
            }
        }
    }
}

