/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import iskallia.vault.VaultMod;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.screen.summary.VaultEndScreen;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModTextureAtlases;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class VaultCombatStatsElement<E extends VaultCombatStatsElement<E>>
extends ContainerElement<E> {
    public VaultCombatStatsElement(IPosition position, TextureAtlasRegion icon, int width, int height, Component name, Map<ResourceLocation, Integer> mobsKilled, StatCollector statCollector) {
        super(Spatials.positionXYZ(position).size(width, height + mobsKilled.size() * 20 + 4));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(5, 0, 3).size(24, 24), ScreenTextures.VAULT_EXIT_ELEMENT_ICON).layout((screen, gui, parent, world) -> world.size(24, 24)));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(0, 2, 2).size(width, 20), ScreenTextures.VAULT_EXIT_ELEMENT_TITLE).layout((screen, gui, parent, world) -> world.size(width, 20)));
        if (mobsKilled.size() > 0) {
            this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(4, 20, 1).size(width - 8, height - 20 + mobsKilled.size() * 20), ScreenTextures.VAULT_EXIT_ELEMENT_BG).layout((screen, gui, parent, world) -> world.size(width - 8, height - 20 + mobsKilled.size() * 20)));
        }
        this.addElement(new TextureAtlasElement(Spatials.positionXYZ(9, 4, 5), icon));
        this.addElement(new ChestStringElement((IPosition)Spatials.positionXYZ(32, 8, 4), (ISize)Spatials.size(16, 7), () -> name, LabelTextStyle.shadow().left()));
        AtomicReference<Float> totalXp = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicInteger iterator = new AtomicInteger();
        mobsKilled.forEach((resourceLocation, integer) -> {
            String texturePath = resourceLocation.toString().replace(':', '/');
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(resourceLocation);
            String entityName = type == null ? "Unknown" : type.toString();
            Map<ResourceLocation, Float> map = ModConfigs.VAULT_STATS.getMobsKilled();
            float xpMul = map.getOrDefault(resourceLocation, map.get(new ResourceLocation("default"))).floatValue();
            float xp = xpMul * (float)integer.intValue();
            totalXp.updateAndGet(v -> Float.valueOf(v.floatValue() + xp));
            MutableComponent nameComponent = new TextComponent(integer + "x ").m_7220_((Component)new TranslatableComponent(entityName));
            MutableComponent xpComponent = new TranslatableComponent(String.format("%.1f xp", Float.valueOf(xp))).m_130948_(Style.f_131099_.m_131148_(VaultEndScreen.XP_COLOR));
            int textWidth = TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)nameComponent);
            int xpWidth = TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)xpComponent);
            IMutableSpatial iMutableSpatial = Spatials.positionXYZ(29, 30 + iterator.get() * 20, 2);
            Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
            this.addElement((ValueElement)new ValueElement((IPosition)iMutableSpatial, (ISize)Spatials.size(textWidth, 9), (Component)nameComponent, LabelTextStyle.shadow().left()).tooltip(() -> VaultCombatStatsElement.lambda$new$5(type, entityName, (Component)xpComponent)));
            IMutableSpatial iMutableSpatial2 = Spatials.positionXYZ(width - 10 - xpWidth, 30 + iterator.get() * 20, 2);
            Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
            this.addElement((ValueElement)new ValueElement((IPosition)iMutableSpatial2, (ISize)Spatials.size(textWidth, 9), (Component)xpComponent, LabelTextStyle.shadow()).tooltip(() -> new TranslatableComponent(entityName).m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(" " + String.format(Locale.US, "%.1f", Float.valueOf(xpMul)) + " xp").m_130948_(Style.f_131099_.m_131148_(VaultEndScreen.XP_COLOR))).m_7220_((Component)new TextComponent(" Per Unalive").m_130940_(ChatFormatting.WHITE))));
            TextureAtlasRegion textureAtlasRegion = TextureAtlasRegion.of(ModTextureAtlases.MOB_HEADS, VaultMod.id("gui/mob_heads/" + texturePath));
            TextureAtlasSprite textureAtlasSprite = textureAtlasRegion.getSprite();
            boolean missing = textureAtlasSprite.m_118413_().toString().equals("minecraft:missingno");
            this.addElement(new TextureAtlasElement(Spatials.positionXYZ(9, 26 + iterator.get() * 20, 2).size(16, 16), missing ? ScreenTextures.BLANK : textureAtlasRegion));
            iterator.getAndIncrement();
        });
        this.addElement(new ChestStringElement((IPosition)Spatials.positionXYZ(width - 21, 8, 4), (ISize)Spatials.size(16, 7), () -> new TextComponent("+ " + String.format("%.1f xp", totalXp.get())).m_130948_(Style.f_131099_.m_131148_(VaultEndScreen.XP_COLOR)), LabelTextStyle.shadow().right()));
    }

    private static /* synthetic */ Component lambda$new$5(EntityType type, String entityName, Component xpComponent) {
        for (int i = 0; i < ModEntities.VAULT_FIGHTER_TYPES.size() && type != null; ++i) {
            if (!type.equals(ModEntities.VAULT_FIGHTER_TYPES.get(i))) continue;
            return new TranslatableComponent(entityName).m_130946_(" Tier " + (i + 1)).m_130946_(" ").m_7220_(xpComponent);
        }
        return new TranslatableComponent(entityName).m_130946_(" ").m_7220_(xpComponent);
    }

    private static final class ChestStringElement
    extends DynamicLabelElement<Component, ChestStringElement> {
        private ChestStringElement(IPosition position, ISize size, Supplier<Component> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Component value) {
            this.set(value);
        }
    }

    private static final class ValueElement
    extends DynamicLabelElement<Component, ValueElement> {
        private ValueElement(IPosition position, ISize size, Component component, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, () -> component, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Component value) {
            this.set(value);
        }
    }
}

