/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.screen.summary.VaultEndScreen;
import iskallia.vault.client.gui.screen.summary.VaultExitContainerScreenData;
import iskallia.vault.client.gui.screen.summary.element.HeadTextureElement;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.init.ModConfigs;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class VaultCoopPlayersElement<E extends VaultCoopPlayersElement<E>>
extends ContainerElement<E> {
    public VaultCoopPlayersElement(IPosition position, TextureAtlasRegion icon, int width, int height, Component name, Vault vault, Map<UUID, StatCollector> supplier) {
        super(Spatials.positionXYZ(position).size(width, height + supplier.size() * 20 + 6));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(5, 0, 3).size(24, 24), ScreenTextures.VAULT_EXIT_ELEMENT_ICON).layout((screen, gui, parent, world) -> world.size(24, 24)));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(0, 2, 2).size(width, 20), ScreenTextures.VAULT_EXIT_ELEMENT_TITLE).layout((screen, gui, parent, world) -> world.size(width, 20)));
        if (supplier.size() > 0) {
            this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(4, 20, 1).size(width - 8, height - 20 + supplier.size() * 20), ScreenTextures.VAULT_EXIT_ELEMENT_BG).layout((screen, gui, parent, world) -> world.size(width - 8, height - 20 + supplier.size() * 20)));
        }
        this.addElement(new TextureAtlasElement(Spatials.positionXYZ(8, 4, 5), icon));
        this.addElement(new ChestStringElement((IPosition)Spatials.positionXYZ(32, 8, 4), (ISize)Spatials.size(16, 7), () -> name, LabelTextStyle.shadow().left()));
        AtomicInteger iterator = new AtomicInteger();
        Comparator<Map.Entry> byExperience = Comparator.comparingInt(entry -> ((StatCollector)entry.getValue()).getExperience(vault));
        Map sortedMap = supplier.entrySet().stream().sorted(byExperience.reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        sortedMap.forEach((uuid, statCollector) -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Player player = Minecraft.m_91087_().f_91073_.m_46003_(uuid);
            TextComponent playerName = player == null ? new TextComponent("Unknown") : new TextComponent("").m_7220_(player.m_5446_());
            MutableComponent xpComponent = new TranslatableComponent(String.format("%s xp", statCollector.getExperience(vault))).m_130948_(Style.f_131099_.m_131148_(VaultEndScreen.XP_COLOR));
            int textWidth = TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)playerName);
            int xpWidth = TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)xpComponent);
            IMutableSpatial iMutableSpatial = Spatials.positionXYZ(29, 30 + iterator.get() * 20, 2);
            Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
            this.addElement((ValueElement)new ValueElement((IPosition)iMutableSpatial, (ISize)Spatials.size(textWidth, 9), (Component)playerName, LabelTextStyle.shadow().left()).tooltip(() -> VaultCoopPlayersElement.lambda$new$6((MutableComponent)playerName, (Component)xpComponent)));
            IMutableSpatial iMutableSpatial2 = Spatials.positionXYZ(width - 10 - xpWidth, 30 + iterator.get() * 20, 2);
            Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
            this.addElement((ValueElement)new ValueElement((IPosition)iMutableSpatial2, (ISize)Spatials.size(xpWidth, 9), (Component)xpComponent, LabelTextStyle.shadow()).tooltip(Tooltips.multi(() -> {
                long window = Minecraft.m_91087_().m_91268_().m_85439_();
                boolean shiftDown = InputConstants.m_84830_((long)window, (int)340) || InputConstants.m_84830_((long)window, (int)344);
                float xpMultiplier = statCollector.getExpMultiplier();
                List<Component> xpReceipt = VaultExitContainerScreenData.getXpReceipt(vault, statCollector, shiftDown, xpMultiplier);
                int maxWidth = 0;
                int spaceWidth = TextBorder.DEFAULT_FONT.get().m_92895_(" ");
                for (Component component : xpReceipt) {
                    maxWidth = Math.max(TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)component), maxWidth);
                }
                MutableComponent titleText = new TextComponent("Vault Xp").m_130948_(Style.f_131099_.m_131148_(VaultEndScreen.XP_COLOR));
                TextComponent spacer = new TextComponent("");
                String totalXpString = shiftDown ? String.format("(x%.1f) %s xp", Float.valueOf(xpMultiplier), ModConfigs.VAULT_STATS.getExperience(vault, (StatCollector)statCollector)) : String.format("%s xp", statCollector.getExperience(vault));
                for (int i = 0; i < maxWidth / spaceWidth - 10 - TextBorder.DEFAULT_FONT.get().m_92895_(totalXpString) / spaceWidth; ++i) {
                    spacer.m_130946_(" ");
                }
                xpReceipt.add(0, (Component)titleText.m_7220_((Component)spacer).m_130946_(totalXpString));
                return xpReceipt;
            })));
            ClientPacketListener netHandler = Minecraft.m_91087_().m_91403_();
            if (netHandler != null) {
                PlayerInfo info = netHandler.m_104949_(uuid);
                boolean offline = info == null;
                ResourceLocation skin = offline ? DefaultPlayerSkin.m_118626_() : info.m_105337_();
                this.addElement(new HeadTextureElement(Spatials.positionXYZ(9, 26 + iterator.get() * 20, 2).size(16, 16), skin));
            }
            iterator.getAndIncrement();
        });
    }

    private static /* synthetic */ Component lambda$new$6(MutableComponent playerName, Component xpComponent) {
        return playerName.m_130946_(" ").m_7220_(xpComponent);
    }

    private static final class ChestStringElement
    extends DynamicLabelElement<Component, ChestStringElement> {
        private ChestStringElement(IPosition position, ISize size, Supplier<Component> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Component value) {
            this.set(value);
        }
    }

    private static final class ValueElement
    extends DynamicLabelElement<Component, ValueElement> {
        private ValueElement(IPosition position, ISize size, Component string, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, () -> string, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Component value) {
            this.set(value);
        }
    }
}

