/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.ScalableItemElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.screen.summary.VaultEndScreen;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;

public class VaultXpIconElement<E extends VaultXpIconElement<E>>
extends ContainerElement<E> {
    public VaultXpIconElement(IPosition position, TextureAtlasRegion icon, Component name, int width, int total, float xpAmount) {
        super(Spatials.positionXYZ(position).size(width, 24));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(5, 0, 3).size(24, 24), ScreenTextures.VAULT_EXIT_ELEMENT_ICON).layout((screen, gui, parent, world) -> world.size(24, 24)));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(0, 2, 2).size(width, 20), ScreenTextures.VAULT_EXIT_ELEMENT_TITLE).layout((screen, gui, parent, world) -> world.size(width, 20)));
        this.addElement(new TextureAtlasElement(Spatials.positionXYZ(9, 4, 5), icon));
        this.addElement(new StringElement((IPosition)Spatials.positionXYZ(32, 8, 5), (ISize)Spatials.size(16, 7), () -> new TextComponent(total + "x ").m_7220_(name), LabelTextStyle.shadow().left()));
        int textWidth = TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TextComponent(" " + xpAmount + "xp"));
        this.addElement(new StringElement((IPosition)Spatials.positionXYZ(width - 4 - textWidth, 8, 5), (ISize)Spatials.size(16, 7), () -> new TextComponent(" " + xpAmount + "xp").m_130948_(Style.f_131099_.m_131148_(VaultEndScreen.XP_COLOR)), LabelTextStyle.shadow()));
    }

    public VaultXpIconElement(IPosition position, ItemStack icon, Component name, int width, int total, float xpAmount) {
        super(Spatials.positionXYZ(position).size(width, 24));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(5, 0, 3).size(24, 24), ScreenTextures.VAULT_EXIT_ELEMENT_ICON).layout((screen, gui, parent, world) -> world.size(24, 24)));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(0, 2, 2).size(width, 20), ScreenTextures.VAULT_EXIT_ELEMENT_TITLE).layout((screen, gui, parent, world) -> world.size(width, 20)));
        this.addElement(new ScalableItemElement(Spatials.positionXYZ(8, 3, 5), () -> icon, 1.0f));
        this.addElement(new StringElement((IPosition)Spatials.positionXYZ(32, 8, 5), (ISize)Spatials.size(16, 7), () -> new TextComponent(total + "x ").m_7220_(name), LabelTextStyle.shadow().left()));
        int textWidth = TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TextComponent(" " + xpAmount + "xp"));
        this.addElement(new StringElement((IPosition)Spatials.positionXYZ(width - 4 - textWidth, 8, 5), (ISize)Spatials.size(16, 7), () -> new TextComponent(" " + xpAmount + "xp").m_130948_(Style.f_131099_.m_131148_(VaultEndScreen.XP_COLOR)), LabelTextStyle.shadow()));
    }

    protected ScalableItemElement<?> makeElementSlot(ISpatial spatial, Supplier<ItemStack> itemStack, float scale) {
        return new ScalableItemElement(spatial, itemStack, scale);
    }

    private static final class StringElement
    extends DynamicLabelElement<Component, StringElement> {
        private StringElement(IPosition position, ISize size, Supplier<Component> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Component value) {
            this.set(value);
        }
    }

    private static final class ChestTypeValueElement
    extends DynamicLabelElement<Integer, ChestTypeValueElement> {
        Component trailingComponent;
        ChatFormatting chatFormatting;

        private ChestTypeValueElement(IPosition position, ISize size, Supplier<Integer> valueSupplier, LabelTextStyle.Builder labelTextStyle, Component trailingComponent, ChatFormatting chatFormatting) {
            super(position, size, valueSupplier, labelTextStyle);
            this.chatFormatting = chatFormatting;
            this.trailingComponent = trailingComponent;
        }

        private ChestTypeValueElement(IPosition position, ISize size, Supplier<Integer> valueSupplier, LabelTextStyle.Builder labelTextStyle, ChatFormatting chatFormatting) {
            super(position, size, valueSupplier, labelTextStyle);
            this.chatFormatting = chatFormatting;
            this.trailingComponent = new TextComponent("");
        }

        @Override
        protected void onValueChanged(Integer value) {
            this.set((Component)new TranslatableComponent(value.toString()).m_130940_(this.chatFormatting).m_7220_(this.trailingComponent));
        }
    }

    public record ValueSupplier(Supplier<Integer> favorSupplier, Supplier<Component> tooltipTitleSupplier, Supplier<List<Component>> tooltipDescriptionSupplier) {
        public static ValueSupplier of(Supplier<Integer> favorSupplier, Supplier<Component> tooltipTitleSupplier, Supplier<List<Component>> tooltipDescriptionSupplier) {
            return new ValueSupplier(favorSupplier, tooltipTitleSupplier, tooltipDescriptionSupplier);
        }
    }

    private static final class ValueElement
    extends DynamicLabelElement<Integer, ValueElement> {
        private ValueElement(IPosition position, ISize size, Supplier<Integer> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Integer value) {
            this.set((Component)new TextComponent("Total: " + value));
        }
    }
}

